/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.internal;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.openqa.selenium.Capabilities;

public class CapabilityHelpers {
    public static final String APPIUM_PREFIX = "appium:";

    @Nullable
    public static <T> T getCapability(Capabilities caps, String name, Class<T> expectedType) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        possibleNames.add(name);
        if (!name.startsWith(APPIUM_PREFIX)) {
            possibleNames.add(APPIUM_PREFIX + name);
        }
        for (String capName : possibleNames) {
            if (caps.getCapability(capName) == null) continue;
            if (expectedType == String.class) {
                return expectedType.cast(String.valueOf(caps.getCapability(capName)));
            }
            if (!expectedType.isAssignableFrom(caps.getCapability(capName).getClass())) continue;
            return expectedType.cast(caps.getCapability(capName));
        }
        return null;
    }
}

