/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class AppiumBy
extends By
implements By.Remotable {
    private final By.Remotable.Parameters remoteParameters;
    private final String locatorName;

    protected AppiumBy(String selector, String locatorString, String locatorName) {
        Validate.notBlank((CharSequence)locatorString, (String)"Must supply a not empty locator value.", (Object[])new Object[0]);
        this.remoteParameters = new By.Remotable.Parameters(selector, (Object)locatorString);
        this.locatorName = locatorName;
    }

    public List<WebElement> findElements(SearchContext context) {
        return context.findElements((By)this);
    }

    public WebElement findElement(SearchContext context) {
        return context.findElement((By)this);
    }

    public String toString() {
        return String.format("AppiumBy.%s: %s", this.locatorName, this.remoteParameters.value());
    }

    public static By accessibilityId(String accessibilityId) {
        return new ByAccessibilityId(accessibilityId);
    }

    public static By androidDataMatcher(String dataMatcherString) {
        return new ByAndroidDataMatcher(dataMatcherString);
    }

    public static By androidUIAutomator(String uiautomatorText) {
        return new ByAndroidUIAutomator(uiautomatorText);
    }

    public static By androidViewMatcher(String viewMatcherString) {
        return new ByAndroidViewMatcher(viewMatcherString);
    }

    public static By androidViewTag(String tag) {
        return new ByAndroidViewTag(tag);
    }

    public static By className(String selector) {
        return new ByClassName(selector);
    }

    public static By custom(String selector) {
        return new ByCustom(selector);
    }

    public static By image(String b64Template) {
        return new ByImage(b64Template);
    }

    public static By iOSClassChain(String iOSClassChainString) {
        return new ByIosClassChain(iOSClassChainString);
    }

    public static By iOSNsPredicateString(String iOSNsPredicateString) {
        return new ByIosNsPredicate(iOSNsPredicateString);
    }

    public By.Remotable.Parameters getRemoteParameters() {
        return this.remoteParameters;
    }

    public static class ByIosNsPredicate
    extends AppiumBy
    implements Serializable {
        protected ByIosNsPredicate(String locatorString) {
            super("-ios predicate string", locatorString, "iOSNsPredicate");
        }
    }

    public static class ByIosClassChain
    extends AppiumBy
    implements Serializable {
        protected ByIosClassChain(String locatorString) {
            super("-ios class chain", locatorString, "iOSClassChain");
        }
    }

    public static class ByImage
    extends AppiumBy
    implements Serializable {
        protected ByImage(String b64Template) {
            super("-image", b64Template, "image");
        }
    }

    public static class ByCustom
    extends AppiumBy
    implements Serializable {
        protected ByCustom(String selector) {
            super("-custom", selector, "custom");
        }
    }

    public static class ByClassName
    extends AppiumBy
    implements Serializable {
        protected ByClassName(String selector) {
            super("class name", selector, "className");
        }
    }

    public static class ByAndroidViewTag
    extends AppiumBy
    implements Serializable {
        public ByAndroidViewTag(String tag) {
            super("-android viewtag", tag, "androidViewTag");
        }
    }

    public static class ByAndroidViewMatcher
    extends AppiumBy
    implements Serializable {
        protected ByAndroidViewMatcher(String locatorString) {
            super("-android viewmatcher", locatorString, "androidViewMatcher");
        }
    }

    public static class ByAndroidUIAutomator
    extends AppiumBy
    implements Serializable {
        public ByAndroidUIAutomator(String uiautomatorText) {
            super("-android uiautomator", uiautomatorText, "androidUIAutomator");
        }
    }

    public static class ByAndroidDataMatcher
    extends AppiumBy
    implements Serializable {
        protected ByAndroidDataMatcher(String locatorString) {
            super("-android datamatcher", locatorString, "androidDataMatcher");
        }
    }

    public static class ByAccessibilityId
    extends AppiumBy
    implements Serializable {
        public ByAccessibilityId(String accessibilityId) {
            super("accessibility id", accessibilityId, "accessibilityId");
        }
    }
}

