/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class Activity {
    private final String appPackage;
    private final String appActivity;
    private String appWaitPackage;
    private String appWaitActivity;
    private String intentAction;
    private String intentCategory;
    private String intentFlags;
    private String optionalIntentArguments;
    private boolean stopApp;

    public Activity(String appPackage, String appActivity) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appPackage) ? 1 : 0) != 0, (Object)"App package should be defined as not empty or null string");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appActivity) ? 1 : 0) != 0, (Object)"App activity should be defined as not empty or null string");
        this.appPackage = appPackage;
        this.appActivity = appActivity;
        this.stopApp = true;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public String getAppActivity() {
        return this.appActivity;
    }

    public String getAppWaitPackage() {
        return this.appWaitPackage;
    }

    public String getAppWaitActivity() {
        return this.appWaitActivity;
    }

    public String getIntentAction() {
        return this.intentAction;
    }

    public String getIntentCategory() {
        return this.intentCategory;
    }

    public String getIntentFlags() {
        return this.intentFlags;
    }

    public String getOptionalIntentArguments() {
        return this.optionalIntentArguments;
    }

    public boolean isStopApp() {
        return this.stopApp;
    }

    public Activity setAppWaitPackage(String appWaitPackage) {
        this.appWaitPackage = appWaitPackage;
        return this;
    }

    public Activity setAppWaitActivity(String appWaitActivity) {
        this.appWaitActivity = appWaitActivity;
        return this;
    }

    public Activity setIntentAction(String intentAction) {
        this.intentAction = intentAction;
        return this;
    }

    public Activity setIntentCategory(String intentCategory) {
        this.intentCategory = intentCategory;
        return this;
    }

    public Activity setIntentFlags(String intentFlags) {
        this.intentFlags = intentFlags;
        return this;
    }

    public Activity setOptionalIntentArguments(String optionalIntentArguments) {
        this.optionalIntentArguments = optionalIntentArguments;
        return this;
    }

    public Activity setStopApp(boolean stopApp) {
        this.stopApp = stopApp;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Activity)) {
            return false;
        }
        Activity other = (Activity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStopApp() != other.isStopApp()) {
            return false;
        }
        String this$appPackage = this.getAppPackage();
        String other$appPackage = other.getAppPackage();
        if (this$appPackage == null ? other$appPackage != null : !this$appPackage.equals(other$appPackage)) {
            return false;
        }
        String this$appActivity = this.getAppActivity();
        String other$appActivity = other.getAppActivity();
        if (this$appActivity == null ? other$appActivity != null : !this$appActivity.equals(other$appActivity)) {
            return false;
        }
        String this$appWaitPackage = this.getAppWaitPackage();
        String other$appWaitPackage = other.getAppWaitPackage();
        if (this$appWaitPackage == null ? other$appWaitPackage != null : !this$appWaitPackage.equals(other$appWaitPackage)) {
            return false;
        }
        String this$appWaitActivity = this.getAppWaitActivity();
        String other$appWaitActivity = other.getAppWaitActivity();
        if (this$appWaitActivity == null ? other$appWaitActivity != null : !this$appWaitActivity.equals(other$appWaitActivity)) {
            return false;
        }
        String this$intentAction = this.getIntentAction();
        String other$intentAction = other.getIntentAction();
        if (this$intentAction == null ? other$intentAction != null : !this$intentAction.equals(other$intentAction)) {
            return false;
        }
        String this$intentCategory = this.getIntentCategory();
        String other$intentCategory = other.getIntentCategory();
        if (this$intentCategory == null ? other$intentCategory != null : !this$intentCategory.equals(other$intentCategory)) {
            return false;
        }
        String this$intentFlags = this.getIntentFlags();
        String other$intentFlags = other.getIntentFlags();
        if (this$intentFlags == null ? other$intentFlags != null : !this$intentFlags.equals(other$intentFlags)) {
            return false;
        }
        String this$optionalIntentArguments = this.getOptionalIntentArguments();
        String other$optionalIntentArguments = other.getOptionalIntentArguments();
        return !(this$optionalIntentArguments == null ? other$optionalIntentArguments != null : !this$optionalIntentArguments.equals(other$optionalIntentArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Activity;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.isStopApp() ? 79 : 97);
        String $appPackage = this.getAppPackage();
        result = result * 59 + ($appPackage == null ? 43 : $appPackage.hashCode());
        String $appActivity = this.getAppActivity();
        result = result * 59 + ($appActivity == null ? 43 : $appActivity.hashCode());
        String $appWaitPackage = this.getAppWaitPackage();
        result = result * 59 + ($appWaitPackage == null ? 43 : $appWaitPackage.hashCode());
        String $appWaitActivity = this.getAppWaitActivity();
        result = result * 59 + ($appWaitActivity == null ? 43 : $appWaitActivity.hashCode());
        String $intentAction = this.getIntentAction();
        result = result * 59 + ($intentAction == null ? 43 : $intentAction.hashCode());
        String $intentCategory = this.getIntentCategory();
        result = result * 59 + ($intentCategory == null ? 43 : $intentCategory.hashCode());
        String $intentFlags = this.getIntentFlags();
        result = result * 59 + ($intentFlags == null ? 43 : $intentFlags.hashCode());
        String $optionalIntentArguments = this.getOptionalIntentArguments();
        result = result * 59 + ($optionalIntentArguments == null ? 43 : $optionalIntentArguments.hashCode());
        return result;
    }

    public String toString() {
        return "Activity(appPackage=" + this.getAppPackage() + ", appActivity=" + this.getAppActivity() + ", appWaitPackage=" + this.getAppWaitPackage() + ", appWaitActivity=" + this.getAppWaitActivity() + ", intentAction=" + this.getIntentAction() + ", intentCategory=" + this.getIntentCategory() + ", intentFlags=" + this.getIntentFlags() + ", optionalIntentArguments=" + this.getOptionalIntentArguments() + ", stopApp=" + this.isStopApp() + ")";
    }
}

