/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.nativekey;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.android.nativekey.AndroidKey;
import io.appium.java_client.android.nativekey.KeyEventFlag;
import io.appium.java_client.android.nativekey.KeyEventMetaModifier;
import java.util.Map;
import java.util.Optional;

public class KeyEvent {
    private Integer keyCode;
    private Integer metaState;
    private Integer flags;

    public KeyEvent() {
    }

    public KeyEvent(AndroidKey key) {
        this.keyCode = key.getCode();
    }

    public KeyEvent withKey(AndroidKey key) {
        this.keyCode = key.getCode();
        return this;
    }

    public KeyEvent withMetaModifier(KeyEventMetaModifier keyEventMetaModifier) {
        if (this.metaState == null) {
            this.metaState = 0;
        }
        this.metaState = this.metaState | keyEventMetaModifier.getValue();
        return this;
    }

    public KeyEvent withFlag(KeyEventFlag keyEventFlag) {
        if (this.flags == null) {
            this.flags = 0;
        }
        this.flags = this.flags | keyEventFlag.getValue();
        return this;
    }

    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int keyCode = Optional.ofNullable(this.keyCode).orElseThrow(() -> new IllegalStateException("The key code must be set"));
        builder.put((Object)"keycode", (Object)keyCode);
        Optional.ofNullable(this.metaState).ifPresent(x -> {
            ImmutableMap.Builder builder2 = builder.put((Object)"metastate", x);
        });
        Optional.ofNullable(this.flags).ifPresent(x -> {
            ImmutableMap.Builder builder2 = builder.put((Object)"flags", x);
        });
        return builder.build();
    }
}

