/*
 * Decompiled with CFR 0.152.
 */
package com.github.appiclogics.pdfviewer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.github.appiclogics.pdfviewer.PDFView;
import com.github.appiclogics.pdfviewer.PdfFile;
import com.github.appiclogics.pdfviewer.exception.PageRenderingException;
import com.github.appiclogics.pdfviewer.model.PagePart;

class RenderingHandler
extends Handler {
    static final int MSG_RENDER_TASK = 1;
    private static final String TAG = RenderingHandler.class.getName();
    private PDFView pdfView;
    private RectF renderBounds = new RectF();
    private Rect roundedRenderBounds = new Rect();
    private Matrix renderMatrix = new Matrix();
    private boolean running = false;

    RenderingHandler(Looper looper, PDFView pdfView) {
        super(looper);
        this.pdfView = pdfView;
    }

    void addRenderingTask(int page, float width, float height, RectF bounds, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
        RenderingTask task = new RenderingTask(width, height, bounds, page, thumbnail, cacheOrder, bestQuality, annotationRendering);
        Message msg = this.obtainMessage(1, task);
        this.sendMessage(msg);
    }

    public void handleMessage(Message message) {
        RenderingTask task = (RenderingTask)message.obj;
        try {
            final PagePart part = this.proceed(task);
            if (part != null) {
                if (this.running) {
                    this.pdfView.post(new Runnable(){

                        @Override
                        public void run() {
                            RenderingHandler.this.pdfView.onBitmapRendered(part);
                        }
                    });
                } else {
                    part.getRenderedBitmap().recycle();
                }
            }
        }
        catch (PageRenderingException ex) {
            this.pdfView.post(new Runnable(){

                @Override
                public void run() {
                    RenderingHandler.this.pdfView.onPageError(ex);
                }
            });
        }
    }

    private PagePart proceed(RenderingTask renderingTask) throws PageRenderingException {
        Bitmap render;
        PdfFile pdfFile = this.pdfView.pdfFile;
        pdfFile.openPage(renderingTask.page);
        int w = Math.round(renderingTask.width);
        int h = Math.round(renderingTask.height);
        if (w == 0 || h == 0 || pdfFile.pageHasError(renderingTask.page)) {
            return null;
        }
        try {
            render = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)(renderingTask.bestQuality ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Cannot create bitmap", (Throwable)e);
            return null;
        }
        this.calculateBounds(w, h, renderingTask.bounds);
        pdfFile.renderPageBitmap(render, renderingTask.page, this.roundedRenderBounds, renderingTask.annotationRendering);
        return new PagePart(renderingTask.page, render, renderingTask.bounds, renderingTask.thumbnail, renderingTask.cacheOrder);
    }

    private void calculateBounds(int width, int height, RectF pageSliceBounds) {
        this.renderMatrix.reset();
        this.renderMatrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        this.renderMatrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        this.renderBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.renderMatrix.mapRect(this.renderBounds);
        this.renderBounds.round(this.roundedRenderBounds);
    }

    void stop() {
        this.running = false;
    }

    void start() {
        this.running = true;
    }

    private class RenderingTask {
        float width;
        float height;
        RectF bounds;
        int page;
        boolean thumbnail;
        int cacheOrder;
        boolean bestQuality;
        boolean annotationRendering;

        RenderingTask(float width, float height, RectF bounds, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
            this.page = page;
            this.width = width;
            this.height = height;
            this.bounds = bounds;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
            this.bestQuality = bestQuality;
            this.annotationRendering = annotationRendering;
        }
    }
}

