/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PagerAdapter
extends FragmentPagerAdapter {
    private List<Fragment> fragments;
    private Map<Integer, Fragment> retainedFragments;

    public PagerAdapter(FragmentManager fm, @NonNull List<Fragment> fragments) {
        super(fm);
        this.fragments = fragments;
        this.retainedFragments = new HashMap<Integer, Fragment>();
    }

    public Fragment getItem(int position) {
        if (!this.fragments.isEmpty()) {
            if (this.retainedFragments.containsKey(position)) {
                return this.retainedFragments.get(position);
            }
            return this.fragments.get(position);
        }
        return null;
    }

    public int getCount() {
        return this.fragments.size();
    }

    @NonNull
    public List<Fragment> getFragments() {
        return this.fragments;
    }

    @NonNull
    public Collection<Fragment> getRetainedFragments() {
        return this.retainedFragments.values();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        Fragment fragment = (Fragment)super.instantiateItem(container, position);
        this.retainedFragments.put(position, fragment);
        return fragment;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.retainedFragments.containsKey(position)) {
            this.retainedFragments.remove(position);
        }
        super.destroyItem(container, position, object);
    }
}

