/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import com.github.paolorotolo.appintro.ScrollerCustomDuration;
import java.lang.reflect.Field;

public final class AppIntroViewPager
extends ViewPager {
    private static final int ON_ILLEGALLY_REQUESTED_NEXT_PAGE_MAX_INTERVAL = 1000;
    private boolean pagingEnabled = true;
    private boolean nextPagingEnabled = true;
    private float currentTouchDownX;
    private long illegallyRequestedNextPageLastCalled;
    private int lockPage = 0;
    private ScrollerCustomDuration mScroller = null;
    private OnNextPageRequestedListener nextPageRequestedListener;
    private ViewPager.OnPageChangeListener pageChangeListener;

    public AppIntroViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initViewPagerScroller();
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        super.addOnPageChangeListener(listener);
        this.pageChangeListener = listener;
    }

    public void setCurrentItem(int item) {
        boolean invokeMeLater = false;
        if (super.getCurrentItem() == 0 && item == 0) {
            invokeMeLater = true;
        }
        super.setCurrentItem(item);
        if (invokeMeLater && this.pageChangeListener != null) {
            this.pageChangeListener.onPageSelected(0);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.currentTouchDownX = event.getX();
            return super.onInterceptTouchEvent(event);
        }
        if (this.checkPagingState(event) || this.checkCanRequestNextPage(event)) {
            this.checkIllegallyRequestedNextPage(event);
            return false;
        }
        return super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.currentTouchDownX = event.getX();
            return super.onTouchEvent(event);
        }
        if (this.checkPagingState(event) || this.checkCanRequestNextPage(event)) {
            this.checkIllegallyRequestedNextPage(event);
            return false;
        }
        return super.onTouchEvent(event);
    }

    private boolean checkPagingState(MotionEvent event) {
        if (!this.pagingEnabled) {
            return true;
        }
        if (!this.nextPagingEnabled) {
            if (event.getAction() == 0) {
                this.currentTouchDownX = event.getX();
            }
            if (event.getAction() == 2 && this.detectSwipeToRight(event)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkCanRequestNextPage(MotionEvent event) {
        return this.nextPageRequestedListener != null && !this.nextPageRequestedListener.onCanRequestNextPage();
    }

    private void checkIllegallyRequestedNextPage(MotionEvent event) {
        int swipeThreshold = 25;
        if (event.getAction() == 2 && Math.abs(event.getX() - this.currentTouchDownX) >= (float)swipeThreshold && System.currentTimeMillis() - this.illegallyRequestedNextPageLastCalled >= 1000L) {
            this.illegallyRequestedNextPageLastCalled = System.currentTimeMillis();
            if (this.nextPageRequestedListener != null) {
                this.nextPageRequestedListener.onIllegallyRequestedNextPage();
            }
        }
    }

    private void initViewPagerScroller() {
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new ScrollerCustomDuration(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean detectSwipeToRight(MotionEvent event) {
        boolean SWIPE_THRESHOLD = false;
        boolean result = false;
        try {
            float diffX = event.getX() - this.currentTouchDownX;
            if (Math.abs(diffX) > 0.0f && diffX < 0.0f) {
                result = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return result;
    }

    public void setOnNextPageRequestedListener(OnNextPageRequestedListener nextPageRequestedListener) {
        this.nextPageRequestedListener = nextPageRequestedListener;
    }

    public void setNextPagingEnabled(boolean nextPagingEnabled) {
        this.nextPagingEnabled = nextPagingEnabled;
        if (!nextPagingEnabled) {
            this.lockPage = this.getCurrentItem();
        }
    }

    public void setScrollDurationFactor(double scrollFactor) {
        this.mScroller.setScrollDurationFactor(scrollFactor);
    }

    public boolean isNextPagingEnabled() {
        return this.nextPagingEnabled;
    }

    public boolean isPagingEnabled() {
        return this.pagingEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.pagingEnabled = pagingEnabled;
    }

    public int getLockPage() {
        return this.lockPage;
    }

    public void setLockPage(int lockPage) {
        this.lockPage = lockPage;
    }

    public static interface OnNextPageRequestedListener {
        public boolean onCanRequestNextPage();

        public void onIllegallyRequestedNextPage();
    }
}

