/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal.viewpager;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import com.github.appintro.AppIntroPageTransformerType;
import com.github.appintro.R;
import com.github.appintro.internal.viewpager.ViewPagerTransformerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/appintro/internal/viewpager/ViewPagerTransformer;", "Landroidx/viewpager/widget/ViewPager$PageTransformer;", "transformType", "Lcom/github/appintro/AppIntroPageTransformerType;", "(Lcom/github/appintro/AppIntroPageTransformerType;)V", "descriptionPF", "", "imagePF", "titlePF", "applyParallax", "", "page", "Landroid/view/View;", "position", "", "computeParallax", "parallaxFactor", "transformDepth", "transformFade", "transformPage", "transformParallax", "transformSlideOver", "transformZoom", "appintro_release"})
public final class ViewPagerTransformer
implements ViewPager.PageTransformer {
    private double titlePF;
    private double imagePF;
    private double descriptionPF;
    private final AppIntroPageTransformerType transformType;

    public void transformPage(@NotNull View page, float position) {
        block1: {
            AppIntroPageTransformerType appIntroPageTransformerType;
            block5: {
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
                                appIntroPageTransformerType = this.transformType;
                                if (!Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Flow.INSTANCE)) break block0;
                                page.setRotationY(position * -30.0f);
                                break block1;
                            }
                            if (!Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.SlideOver.INSTANCE)) break block2;
                            this.transformSlideOver(position, page);
                            break block1;
                        }
                        if (!Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Depth.INSTANCE)) break block3;
                        this.transformDepth(position, page);
                        break block1;
                    }
                    if (!Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Zoom.INSTANCE)) break block4;
                    this.transformZoom(position, page);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)appIntroPageTransformerType, (Object)AppIntroPageTransformerType.Fade.INSTANCE)) break block5;
                this.transformFade(position, page);
                break block1;
            }
            if (!(appIntroPageTransformerType instanceof AppIntroPageTransformerType.Parallax)) break block1;
            this.titlePF = ((AppIntroPageTransformerType.Parallax)this.transformType).getTitleParallaxFactor();
            this.imagePF = ((AppIntroPageTransformerType.Parallax)this.transformType).getImageParallaxFactor();
            this.descriptionPF = ((AppIntroPageTransformerType.Parallax)this.transformType).getDescriptionParallaxFactor();
            this.transformParallax(position, page);
        }
    }

    private final void transformParallax(float position, View page) {
        if (position > (float)-1 && position < 1.0f) {
            try {
                this.applyParallax(page, position);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    private final void applyParallax(View page, float position) {
        View view = page.findViewById(R.id.title);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"page.findViewById<TextView>(R.id.title)");
        ((TextView)view).setTranslationX(this.computeParallax(page, position, this.titlePF));
        View view2 = page.findViewById(R.id.image);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"page.findViewById<ImageView>(R.id.image)");
        ((ImageView)view2).setTranslationX(this.computeParallax(page, position, this.imagePF));
        View view3 = page.findViewById(R.id.description);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"page.findViewById<TextView>(R.id.description)");
        ((TextView)view3).setTranslationX(this.computeParallax(page, position, this.descriptionPF));
    }

    private final float computeParallax(View page, float position, double parallaxFactor) {
        return (float)((double)(-position) * ((double)page.getWidth() / parallaxFactor));
    }

    private final void transformFade(float position, View page) {
        if (position <= -1.0f || position >= 1.0f) {
            page.setTranslationX((float)page.getWidth());
            page.setAlpha(0.0f);
            page.setClickable(false);
        } else if (position == 0.0f) {
            page.setTranslationX(0.0f);
            page.setAlpha(1.0f);
            page.setClickable(true);
        } else {
            page.setTranslationX((float)page.getWidth() * -position);
            page.setAlpha(1.0f - Math.abs(position));
        }
    }

    private final void transformZoom(float position, View page) {
        if (position >= (float)-1 && position <= 1.0f) {
            ViewPagerTransformerKt.access$setScaleXY$p(page, Math.max(0.85f, 1.0f - Math.abs(position)));
            page.setAlpha(0.5f + (ViewPagerTransformerKt.access$getScaleXY$p(page) - 0.85f) / 0.14999998f * 0.5f);
            float vMargin = (float)page.getHeight() * (1.0f - ViewPagerTransformerKt.access$getScaleXY$p(page)) / (float)2;
            float hMargin = (float)page.getWidth() * (1.0f - ViewPagerTransformerKt.access$getScaleXY$p(page)) / (float)2;
            if (position < 0.0f) {
                page.setTranslationX(hMargin - vMargin / (float)2);
            } else {
                page.setTranslationX(-hMargin + vMargin / (float)2);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformDepth(float position, View page) {
        if (position > 0.0f && position < 1.0f) {
            page.setAlpha(1.0f - position);
            ViewPagerTransformerKt.access$setScaleXY$p(page, 0.75f + 0.25f * (1.0f - Math.abs(position)));
            page.setTranslationX((float)page.getWidth() * -position);
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    private final void transformSlideOver(float position, View page) {
        if (position < 0.0f && position > (float)-1) {
            ViewPagerTransformerKt.access$setScaleXY$p(page, Math.abs(Math.abs(position) - 1.0f) * 0.14999998f + 0.85f);
            page.setAlpha(Math.max(0.35f, 1.0f - Math.abs(position)));
            int pageWidth = page.getWidth();
            float translateValue = position * (float)(-pageWidth);
            if (translateValue > (float)(-pageWidth)) {
                page.setTranslationX(translateValue);
            } else {
                page.setTranslationX(0.0f);
            }
        } else {
            ViewPagerTransformerKt.access$transformDefaults(page);
        }
    }

    public ViewPagerTransformer(@NotNull AppIntroPageTransformerType transformType) {
        Intrinsics.checkParameterIsNotNull((Object)transformType, (String)"transformType");
        this.transformType = transformType;
    }
}

