/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.github.paolorotolo.appintro.internal.LogHelper;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/paolorotolo/appintro/internal/CustomFontCache;", "", "()V", "TAG", "", "cache", "Ljava/util/HashMap;", "Landroid/graphics/Typeface;", "Lkotlin/collections/HashMap;", "get", "path", "ctx", "Landroid/content/Context;", "appintro_release"})
public final class CustomFontCache {
    private static final String TAG;
    private static final HashMap<String, Typeface> cache;
    public static final CustomFontCache INSTANCE;

    @Nullable
    public final Typeface get(@Nullable String path, @NotNull Context ctx) {
        Typeface typeface;
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        CharSequence charSequence = path;
        if (charSequence == null || charSequence.length() == 0) {
            LogHelper.w$default(TAG, "Empty typeface path provided!", null, 4, null);
            return null;
        }
        Typeface storedTypeface = cache.get(path);
        if (storedTypeface != null) {
            typeface = storedTypeface;
        } else {
            Typeface newTypeface = Typeface.createFromAsset((AssetManager)ctx.getAssets(), (String)path);
            Map map = cache;
            String string2 = path;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Typeface typeface2 = newTypeface;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeface2, (String)"newTypeface");
            Typeface typeface3 = typeface2;
            map.put(string3, typeface3);
            typeface = newTypeface;
        }
        return typeface;
    }

    private CustomFontCache() {
    }

    static {
        CustomFontCache customFontCache;
        INSTANCE = customFontCache = new CustomFontCache();
        TAG = LogHelper.INSTANCE.makeLogTag(Reflection.getOrCreateKotlinClass(CustomFontCache.class));
        cache = new HashMap();
    }
}

