/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.paolorotolo.appintro.CustomFontCache;
import com.github.paolorotolo.appintro.ISlideBackgroundColorHolder;
import com.github.paolorotolo.appintro.ISlideSelectionListener;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.util.LogHelper;

public abstract class AppIntroBaseFragment
extends Fragment
implements ISlideSelectionListener,
ISlideBackgroundColorHolder {
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_TITLE_TYPEFACE = "title_typeface";
    protected static final String ARG_DESC = "desc";
    protected static final String ARG_DESC_TYPEFACE = "desc_typeface";
    protected static final String ARG_DRAWABLE = "drawable";
    protected static final String ARG_BG_COLOR = "bg_color";
    protected static final String ARG_TITLE_COLOR = "title_color";
    protected static final String ARG_DESC_COLOR = "desc_color";
    private static final String TAG = LogHelper.makeLogTag(AppIntroBaseFragment.class);
    private int drawable;
    private int bgColor;
    private int titleColor;
    private int descColor;
    private int layoutId;
    private String title;
    private String titleTypeface;
    private String description;
    private String descTypeface;
    private LinearLayout mainLayout;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (this.getArguments() != null && this.getArguments().size() != 0) {
            this.drawable = this.getArguments().getInt(ARG_DRAWABLE);
            this.title = this.getArguments().getString(ARG_TITLE);
            this.titleTypeface = this.getArguments().containsKey(ARG_TITLE_TYPEFACE) ? this.getArguments().getString(ARG_TITLE_TYPEFACE) : "";
            this.description = this.getArguments().getString(ARG_DESC);
            this.descTypeface = this.getArguments().containsKey(ARG_DESC_TYPEFACE) ? this.getArguments().getString(ARG_DESC_TYPEFACE) : "";
            this.bgColor = this.getArguments().getInt(ARG_BG_COLOR);
            this.titleColor = this.getArguments().containsKey(ARG_TITLE_COLOR) ? this.getArguments().getInt(ARG_TITLE_COLOR) : 0;
            this.descColor = this.getArguments().containsKey(ARG_DESC_COLOR) ? this.getArguments().getInt(ARG_DESC_COLOR) : 0;
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.drawable = savedInstanceState.getInt(ARG_DRAWABLE);
            this.title = savedInstanceState.getString(ARG_TITLE);
            this.titleTypeface = savedInstanceState.getString(ARG_TITLE_TYPEFACE);
            this.description = savedInstanceState.getString(ARG_DESC);
            this.descTypeface = savedInstanceState.getString(ARG_DESC_TYPEFACE);
            this.bgColor = savedInstanceState.getInt(ARG_BG_COLOR);
            this.titleColor = savedInstanceState.getInt(ARG_TITLE_COLOR);
            this.descColor = savedInstanceState.getInt(ARG_DESC_COLOR);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(this.getLayoutId(), container, false);
        TextView t = (TextView)v.findViewById(R.id.title);
        TextView d = (TextView)v.findViewById(R.id.description);
        ImageView i = (ImageView)v.findViewById(R.id.image);
        this.mainLayout = (LinearLayout)v.findViewById(R.id.main);
        t.setText((CharSequence)this.title);
        if (this.titleColor != 0) {
            t.setTextColor(this.titleColor);
        }
        if (this.titleTypeface != null && this.titleTypeface.equals("") && CustomFontCache.get(this.titleTypeface, this.getContext()) != null) {
            t.setTypeface(CustomFontCache.get(this.titleTypeface, this.getContext()));
        }
        d.setText((CharSequence)this.description);
        if (this.descColor != 0) {
            d.setTextColor(this.descColor);
        }
        if (this.descTypeface != null && this.descTypeface.equals("") && CustomFontCache.get(this.descTypeface, this.getContext()) != null) {
            d.setTypeface(CustomFontCache.get(this.descTypeface, this.getContext()));
        }
        i.setImageResource(this.drawable);
        this.mainLayout.setBackgroundColor(this.bgColor);
        return v;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(ARG_DRAWABLE, this.drawable);
        outState.putString(ARG_TITLE, this.title);
        outState.putString(ARG_DESC, this.description);
        outState.putInt(ARG_BG_COLOR, this.bgColor);
        outState.putInt(ARG_TITLE_COLOR, this.titleColor);
        outState.putInt(ARG_DESC_COLOR, this.descColor);
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onSlideDeselected() {
        LogHelper.d(TAG, String.format("Slide %s has been deselected.", this.title));
    }

    @Override
    public void onSlideSelected() {
        LogHelper.d(TAG, String.format("Slide %s has been selected.", this.title));
    }

    @Override
    public int getDefaultBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.mainLayout.setBackgroundColor(backgroundColor);
    }

    @LayoutRes
    protected abstract int getLayoutId();
}

