/*
 * Decompiled with CFR 0.152.
 */
package com.github.apetrelli.gwtintegration.spring.security;

import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;

public class SpringSecurityLoggingExceptionHandler
implements ExceptionHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ServerFailure createServerFailure(Throwable throwable) {
        if (throwable != null) {
            String type = null;
            String message = "A server error occurred";
            if (throwable instanceof AccessDeniedException) {
                this.log.warn("Access denied, possible session expiration", throwable);
                type = "security";
                message = "Security error";
            }
            this.log.error("Server failure on request factory", throwable);
            return new ServerFailure(message, type, null, true);
        }
        this.log.error("Unrecognized server failure on request factory");
        return new ServerFailure("An unrecognized server error occurred", null, null, true);
    }
}

