/*
 * Decompiled with CFR 0.152.
 */
package com.github.apetrelli.gwtintegration.hibernate.validator;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoFallbackResourceBundleLocator
implements ResourceBundleLocator {
    private static final Logger log = LoggerFactory.getLogger(NoFallbackResourceBundleLocator.class);
    private String bundleName;

    public NoFallbackResourceBundleLocator(String bundleName) {
        this.bundleName = bundleName;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        ClassLoader classLoader = GetClassLoader.fromContext();
        if (classLoader != null) {
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by thread local classloader");
        }
        if (rb == null) {
            classLoader = GetClassLoader.fromClass(NoFallbackResourceBundleLocator.class);
            rb = this.loadBundle(classLoader, locale, this.bundleName + " not found by validator classloader");
        }
        if (rb != null) {
            log.debug("{} found.", (Object)this.bundleName);
        } else {
            log.debug("{} not found.", (Object)this.bundleName);
        }
        return rb;
    }

    private ResourceBundle loadBundle(ClassLoader classLoader, Locale locale, String message) {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(this.bundleName, locale, classLoader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        }
        catch (MissingResourceException e) {
            log.trace(message);
        }
        return rb;
    }

    private static class GetClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final Class<?> clazz;

        public static ClassLoader fromContext() {
            GetClassLoader action = new GetClassLoader(null);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        public static ClassLoader fromClass(Class<?> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class is null");
            }
            GetClassLoader action = new GetClassLoader(clazz);
            if (System.getSecurityManager() != null) {
                return AccessController.doPrivileged(action);
            }
            return action.run();
        }

        private GetClassLoader(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public ClassLoader run() {
            if (this.clazz != null) {
                return this.clazz.getClassLoader();
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

