/*
 * Decompiled with CFR 0.152.
 */
package ove.crypto.digest;

import java.security.MessageDigest;
import java.util.concurrent.TimeUnit;
import ove.alphazero.util.CmdLineArgs;
import ove.crypto.digest.Blake2b;

public class Bench
implements Runnable {
    static volatile boolean f_run = true;
    private final String md_name;
    private final int iters;
    private final int datalen;
    private final byte[] b;
    private final Call call;

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            System.exit(Usage.usage());
        }
        CmdLineArgs clargs = CmdLineArgs.parse(null, args);
        try {
            String md_name = null;
            md_name = clargs.getOption("d", "blake2b");
            int iters = clargs.getIntOption("i", 1000);
            int datalen = clargs.getIntOption("n", 1024);
            Bench bench = new Bench(md_name, iters, datalen);
            Thread brth = new Thread((Runnable)bench, "bench-runner");
            brth.start();
            System.in.read();
            f_run = false;
            brth.join();
        }
        catch (Throwable e) {
            System.exit(Usage.usage());
        }
    }

    Bench(String md_name, int iters, int datalen) {
        this.md_name = md_name;
        this.iters = iters;
        this.datalen = datalen;
        this.b = new byte[datalen];
        for (int i = 0; i < this.b.length; ++i) {
            this.b[i] = (byte)i;
        }
        this.call = this.getBenchedCall();
    }

    private Call getBenchedCall() {
        Call call = null;
        call = this.md_name.equalsIgnoreCase("blake2b") ? Bench.newCallBlake2b() : Bench.newCallJCEAlgorithm(this.md_name);
        return call;
    }

    private static final void puts(String s) {
        System.out.format("%s\n", s);
    }

    @Override
    public void run() {
        Bench.puts("Bench - hit any key to stop.");
        Bench.puts("");
        Bench.puts("digest   | iterations | size (b/iter) | dt (nsec/iter) | throughput (b/usec)");
        while (f_run) {
            long start = System.nanoTime();
            for (int i = 0; i < this.iters; ++i) {
                this.call.func(this.b);
            }
            long delta = System.nanoTime() - start;
            long delta_us = TimeUnit.NANOSECONDS.toMicros(delta);
            double thrpt = (double)this.b.length * (double)this.iters / (double)delta_us;
            System.out.format("%-8s | %10d | %13d | %14d |    %16.6f\r", this.md_name, this.iters, this.b.length, delta, thrpt);
        }
    }

    public static Call newCallBlake2b() {
        final Blake2b.Digest digest = Blake2b.Digest.newInstance(new Blake2b.Param().setDigestLength(20));
        return new Call(){

            @Override
            public final byte[] func(byte[] b) {
                digest.update(b, 0, b.length);
                return digest.digest();
            }
        };
    }

    public static Call newCallJCEAlgorithm(String md_name) {
        final MessageDigest digest = Bench.silentGet(md_name);
        return new Call(){

            @Override
            public final byte[] func(byte[] b) {
                digest.update(b, 0, b.length);
                return digest.digest();
            }
        };
    }

    public static MessageDigest silentGet(String mdname) {
        try {
            return MessageDigest.getInstance(mdname);
        }
        catch (Throwable e) {
            throw new Error(String.format("Error getting instance of digest <%s>", mdname), e);
        }
    }

    static interface Call {
        public byte[] func(byte[] var1);
    }

    static class Usage {
        Usage() {
        }

        private static void explain(String opt, String details) {
            System.out.format("%3s\t%s\n", opt, details);
        }

        static int usage() {
            System.out.println("usage: java -cp .. ove.crypto.digest.Bench [options]");
            System.out.println("[options]");
            Usage.explain("-d", "digest to bench, one of {blake2, sha1, md5}. default: blake2b");
            Usage.explain("-i", "number of iterations (digest function calls) per bench round. default: 1000");
            Usage.explain("-n", "size of the digested buffer in bytes. default: 1024 b / call");
            return -1;
        }
    }

    static interface Default {
        public static final int iterations = 1000;
        public static final int datalen = 1024;
        public static final String digest = "blake2b";
    }
}

