/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class GenericParquetWriter {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericParquetWriter() {
    }

    public static <T> ParquetValueWriter<T> buildWriter(MessageType type) {
        return (ParquetValueWriter)ParquetTypeVisitor.visit((Type)type, (ParquetTypeVisitor)new WriteBuilder(type));
    }

    private static class RecordWriter
    extends ParquetValueWriters.StructWriter<Record> {
        private RecordWriter(List<ParquetValueWriter<?>> writers) {
            super(writers);
        }

        protected Object get(Record struct, int index) {
            return struct.get(index);
        }
    }

    private static class FixedWriter
    extends ParquetValueWriters.PrimitiveWriter<byte[]> {
        private FixedWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, byte[] value) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])value));
        }
    }

    private static class TimestamptzWriter
    extends ParquetValueWriters.PrimitiveWriter<OffsetDateTime> {
        private TimestamptzWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, OffsetDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value));
        }
    }

    private static class TimestampWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDateTime> {
        private TimestampWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalDateTime value) {
            this.column.writeLong(repetitionLevel, ChronoUnit.MICROS.between(EPOCH, value.atOffset(ZoneOffset.UTC)));
        }
    }

    private static class TimeWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalTime> {
        private TimeWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalTime value) {
            this.column.writeLong(repetitionLevel, value.toNanoOfDay() / 1000L);
        }
    }

    private static class DateWriter
    extends ParquetValueWriters.PrimitiveWriter<LocalDate> {
        private DateWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void write(int repetitionLevel, LocalDate value) {
            this.column.writeInteger(repetitionLevel, (int)ChronoUnit.DAYS.between(EPOCH_DAY, value));
        }
    }

    private static class WriteBuilder
    extends ParquetTypeVisitor<ParquetValueWriter<?>> {
        private final MessageType type;

        WriteBuilder(MessageType type) {
            this.type = type;
        }

        public ParquetValueWriter<?> message(MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(message.asGroupType(), fieldWriters);
        }

        public ParquetValueWriter<?> struct(GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List fields = struct.getFields();
            ArrayList writers = Lists.newArrayListWithExpectedSize((int)fieldWriters.size());
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = struct.getType(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
                writers.add(ParquetValueWriters.option((Type)fieldType, (int)fieldD, fieldWriters.get(i)));
            }
            return new RecordWriter(writers);
        }

        public ParquetValueWriter<?> list(GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = ((Type)array.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName()));
            return ParquetValueWriters.collections((int)repeatedD, (int)repeatedR, (ParquetValueWriter)ParquetValueWriters.option((Type)elementType, (int)elementD, elementWriter));
        }

        public ParquetValueWriter<?> map(GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = ((Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName()));
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName()));
            return ParquetValueWriters.maps((int)repeatedD, (int)repeatedR, (ParquetValueWriter)ParquetValueWriters.option((Type)keyType, (int)keyD, keyWriter), (ParquetValueWriter)ParquetValueWriters.option((Type)valueType, (int)valueD, valueWriter));
        }

        public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return ParquetValueWriters.strings((ColumnDescriptor)desc);
                    }
                    case INT_8: 
                    case INT_16: 
                    case INT_32: 
                    case INT_64: {
                        return ParquetValueWriters.unboxed((ColumnDescriptor)desc);
                    }
                    case DATE: {
                        return new DateWriter(desc);
                    }
                    case TIME_MICROS: {
                        return new TimeWriter(desc);
                    }
                    case TIMESTAMP_MICROS: {
                        return new TimestamptzWriter(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case INT32: {
                                return ParquetValueWriters.decimalAsInteger((ColumnDescriptor)desc, (int)decimal.getPrecision(), (int)decimal.getScale());
                            }
                            case INT64: {
                                return ParquetValueWriters.decimalAsLong((ColumnDescriptor)desc, (int)decimal.getPrecision(), (int)decimal.getScale());
                            }
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return ParquetValueWriters.decimalAsFixed((ColumnDescriptor)desc, (int)decimal.getPrecision(), (int)decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
                    }
                    case BSON: {
                        return ParquetValueWriters.byteBuffers((ColumnDescriptor)desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedWriter(desc);
                }
                case BINARY: {
                    return ParquetValueWriters.byteBuffers((ColumnDescriptor)desc);
                }
                case INT32: 
                case INT64: 
                case BOOLEAN: 
                case FLOAT: 
                case DOUBLE: {
                    return ParquetValueWriters.unboxed((ColumnDescriptor)desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }

        private String[] path(String name) {
            String[] path = new String[this.fieldNames.size() + 1];
            path[this.fieldNames.size()] = name;
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

