/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class GenericOrcReader
implements OrcValueReader<Record> {
    private final Schema schema;
    private final List<TypeDescription> columns;
    private final Converter[] converters;

    private GenericOrcReader(Schema expectedSchema, TypeDescription readSchema) {
        this.schema = expectedSchema;
        this.columns = readSchema.getChildren();
        this.converters = this.buildConverters();
    }

    private Converter[] buildConverters() {
        Preconditions.checkState((this.schema.columns().size() == this.columns.size() ? 1 : 0) != 0, (Object)"Expected schema must have same number of columns as projection.");
        Converter[] newConverters = new Converter[this.columns.size()];
        List icebergCols = this.schema.columns();
        for (int c = 0; c < newConverters.length; ++c) {
            newConverters[c] = GenericOrcReader.buildConverter((Types.NestedField)icebergCols.get(c), this.columns.get(c));
        }
        return newConverters;
    }

    public static OrcValueReader<Record> buildReader(Schema expectedSchema, TypeDescription fileSchema) {
        return new GenericOrcReader(expectedSchema, fileSchema);
    }

    public Record read(VectorizedRowBatch batch, int row) {
        GenericRecord rowRecord = GenericRecord.create(this.schema);
        for (int c = 0; c < batch.cols.length; ++c) {
            rowRecord.set(c, this.converters[c].convert(batch.cols[c], row));
        }
        return rowRecord;
    }

    private static Converter buildConverter(Types.NestedField icebergField, TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return new BooleanConverter();
            }
            case BYTE: {
                return new ByteConverter();
            }
            case SHORT: {
                return new ShortConverter();
            }
            case DATE: 
            case INT: {
                return new IntConverter();
            }
            case LONG: {
                return new LongConverter();
            }
            case FLOAT: {
                return new FloatConverter();
            }
            case DOUBLE: {
                return new DoubleConverter();
            }
            case TIMESTAMP: {
                return new TimestampConverter();
            }
            case DECIMAL: {
                return new DecimalConverter();
            }
            case BINARY: {
                return new BinaryConverter();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return new StringConverter();
            }
            case STRUCT: {
                return new StructConverter(icebergField, schema);
            }
            case LIST: {
                return new ListConverter(icebergField, schema);
            }
            case MAP: {
                return new MapConverter(icebergField, schema);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + schema);
    }

    private static class StructConverter
    implements Converter<Record> {
        private final Converter[] children;
        private final Schema icebergStructSchema;

        StructConverter(Types.NestedField icebergField, TypeDescription schema) {
            Preconditions.checkArgument((boolean)icebergField.type().isStructType());
            this.icebergStructSchema = new Schema(icebergField.type().asStructType().fields());
            List icebergChildren = icebergField.type().asStructType().fields();
            this.children = new Converter[schema.getChildren().size()];
            Preconditions.checkState((icebergChildren.size() == this.children.length ? 1 : 0) != 0, (Object)"Expected schema must have same number of columns as projection.");
            for (int c = 0; c < this.children.length; ++c) {
                this.children[c] = GenericOrcReader.buildConverter((Types.NestedField)icebergChildren.get(c), (TypeDescription)schema.getChildren().get(c));
            }
        }

        Record writeStruct(StructColumnVector vector, int row) {
            GenericRecord data = GenericRecord.create(this.icebergStructSchema);
            for (int c = 0; c < this.children.length; ++c) {
                data.set(c, this.children[c].convert(vector.fields[c], row));
            }
            return data;
        }

        @Override
        public Record convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return this.writeStruct((StructColumnVector)vector, rowIndex);
        }
    }

    private static class MapConverter
    implements Converter {
        private final Converter keyConvert;
        private final Converter valueConvert;

        MapConverter(Types.NestedField icebergField, TypeDescription schema) {
            Preconditions.checkArgument((boolean)icebergField.type().isMapType());
            TypeDescription keyType = (TypeDescription)schema.getChildren().get(0);
            TypeDescription valueType = (TypeDescription)schema.getChildren().get(1);
            List mapFields = icebergField.type().asMapType().fields();
            this.keyConvert = GenericOrcReader.buildConverter((Types.NestedField)mapFields.get(0), keyType);
            this.valueConvert = GenericOrcReader.buildConverter((Types.NestedField)mapFields.get(1), valueType);
        }

        Map<?, ?> readMap(MapColumnVector vector, int row) {
            int offset = (int)vector.offsets[row];
            int length = (int)vector.lengths[row];
            HashMap map = Maps.newHashMapWithExpectedSize((int)length);
            for (int c = 0; c < length; ++c) {
                String key = String.valueOf(this.keyConvert.convert(vector.keys, offset + c));
                Object value = this.valueConvert.convert(vector.values, offset + c);
                map.put(key, value);
            }
            return map;
        }

        public Map convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return this.readMap((MapColumnVector)vector, rowIndex);
        }
    }

    private static class ListConverter
    implements Converter<List<?>> {
        private final Converter childConverter;

        ListConverter(Types.NestedField icebergField, TypeDescription schema) {
            Preconditions.checkArgument((boolean)icebergField.type().isListType());
            TypeDescription child = (TypeDescription)schema.getChildren().get(0);
            this.childConverter = GenericOrcReader.buildConverter((Types.NestedField)icebergField.type().asListType().fields().get(0), child);
        }

        List<?> readList(ListColumnVector vector, int row) {
            int offset = (int)vector.offsets[row];
            int length = (int)vector.lengths[row];
            ArrayList list = Lists.newArrayListWithExpectedSize((int)length);
            for (int c = 0; c < length; ++c) {
                list.add(this.childConverter.convert(vector.child, offset + c));
            }
            return list;
        }

        @Override
        public List<?> convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return this.readList((ListColumnVector)vector, rowIndex);
        }
    }

    private static class DecimalConverter
    implements Converter<BigDecimal> {
        private DecimalConverter() {
        }

        @Override
        public BigDecimal convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return ((DecimalColumnVector)vector).vector[rowIndex].getHiveDecimal().bigDecimalValue();
        }
    }

    private static class StringConverter
    implements Converter<String> {
        private StringConverter() {
        }

        @Override
        public String convert(ColumnVector vector, int row) {
            BinaryConverter converter = new BinaryConverter();
            byte[] byteData = converter.convert(vector, row);
            if (byteData == null) {
                return null;
            }
            return new String(byteData, StandardCharsets.UTF_8);
        }
    }

    private static class BinaryConverter
    implements Converter<byte[]> {
        private BinaryConverter() {
        }

        @Override
        public byte[] convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return Arrays.copyOfRange(bytesVector.vector[rowIndex], bytesVector.start[rowIndex], bytesVector.start[rowIndex] + bytesVector.length[rowIndex]);
        }
    }

    private static class TimestampConverter
    implements Converter<Long> {
        private TimestampConverter() {
        }

        private Long convert(TimestampColumnVector vector, int row) {
            return vector.time[row] / 1000L * 1000000L + (long)(vector.nanos[row] / 1000);
        }

        @Override
        public Long convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return this.convert((TimestampColumnVector)vector, rowIndex);
        }
    }

    private static class DoubleConverter
    implements Converter<Double> {
        private DoubleConverter() {
        }

        @Override
        public Double convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return ((DoubleColumnVector)vector).vector[rowIndex];
        }
    }

    private static class FloatConverter
    implements Converter<Float> {
        private FloatConverter() {
        }

        @Override
        public Float convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return Float.valueOf((float)((DoubleColumnVector)vector).vector[rowIndex]);
        }
    }

    private static class LongConverter
    implements Converter<Long> {
        private LongConverter() {
        }

        @Override
        public Long convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return ((LongColumnVector)vector).vector[rowIndex];
        }
    }

    private static class IntConverter
    implements Converter<Integer> {
        private IntConverter() {
        }

        @Override
        public Integer convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return (int)((LongColumnVector)vector).vector[rowIndex];
        }
    }

    private static class ShortConverter
    implements Converter<Short> {
        private ShortConverter() {
        }

        @Override
        public Short convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return (short)((LongColumnVector)vector).vector[rowIndex];
        }
    }

    private static class ByteConverter
    implements Converter<Byte> {
        private ByteConverter() {
        }

        @Override
        public Byte convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return (byte)((LongColumnVector)vector).vector[rowIndex];
        }
    }

    private static class BooleanConverter
    implements Converter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean convert(ColumnVector vector, int row) {
            int rowIndex;
            int n = rowIndex = vector.isRepeating ? 0 : row;
            if (!vector.noNulls && vector.isNull[rowIndex]) {
                return null;
            }
            return ((LongColumnVector)vector).vector[rowIndex] != 0L;
        }
    }

    static interface Converter<T> {
        public T convert(ColumnVector var1, int var2);
    }
}

