/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.iceberg.util.CharSequenceWrapper;

public class CharSequenceSet
implements Set<CharSequence>,
Serializable {
    private final Set<CharSequenceWrapper> wrapperSet;
    private final CharSequenceWrapper containsWrapper = CharSequenceWrapper.wrap(null);

    public static Set<CharSequence> of(Iterable<CharSequence> charSequences) {
        return new CharSequenceSet(charSequences);
    }

    private CharSequenceSet(Iterable<CharSequence> charSequences) {
        this.wrapperSet = Sets.newHashSet((Iterable)Iterables.transform(charSequences, CharSequenceWrapper::wrap));
    }

    @Override
    public int size() {
        return this.wrapperSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapperSet.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof CharSequence) {
            return this.wrapperSet.contains(this.containsWrapper.set((CharSequence)obj));
        }
        return false;
    }

    @Override
    public Iterator<CharSequence> iterator() {
        return Iterators.transform(this.wrapperSet.iterator(), CharSequenceWrapper::get);
    }

    @Override
    public Object[] toArray() {
        return Iterators.toArray(this.iterator(), CharSequence.class);
    }

    @Override
    public <T> T[] toArray(T[] destArray) {
        int size = this.wrapperSet.size();
        if (destArray.length < size) {
            return this.toArray();
        }
        Iterator<CharSequence> iter = this.iterator();
        int ind = 0;
        while (iter.hasNext()) {
            destArray[ind] = iter.next();
            ++ind;
        }
        if (destArray.length > size) {
            destArray[size] = null;
        }
        return destArray;
    }

    @Override
    public boolean add(CharSequence charSequence) {
        return this.wrapperSet.add(CharSequenceWrapper.wrap(charSequence));
    }

    @Override
    public boolean remove(Object obj) {
        if (obj instanceof CharSequence) {
            return this.wrapperSet.remove(this.containsWrapper.set((CharSequence)obj));
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.all(objects, this::contains);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends CharSequence> charSequences) {
        if (charSequences != null) {
            return Iterables.addAll(this.wrapperSet, (Iterable)Iterables.transform(charSequences, CharSequenceWrapper::wrap));
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.removeAll(this.wrapperSet, objects);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects != null) {
            return Iterables.removeAll(this.wrapperSet, objects);
        }
        return false;
    }

    @Override
    public void clear() {
        this.wrapperSet.clear();
    }
}

