/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public interface ManifestFile {
    public static final Schema SCHEMA = new Schema(Types.NestedField.required(500, "manifest_path", Types.StringType.get()), Types.NestedField.required(501, "manifest_length", Types.LongType.get()), Types.NestedField.required(502, "partition_spec_id", Types.IntegerType.get()), Types.NestedField.optional(503, "added_snapshot_id", Types.LongType.get()), Types.NestedField.optional(504, "added_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(505, "existing_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(506, "deleted_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(507, "partitions", Types.ListType.ofRequired(508, Types.StructType.of(Types.NestedField.required(509, "contains_null", Types.BooleanType.get()), Types.NestedField.optional(510, "lower_bound", Types.BinaryType.get()), Types.NestedField.optional(511, "upper_bound", Types.BinaryType.get())))), Types.NestedField.optional(512, "added_rows_count", Types.LongType.get()), Types.NestedField.optional(513, "existing_rows_count", Types.LongType.get()), Types.NestedField.optional(514, "deleted_rows_count", Types.LongType.get()));

    public static Schema schema() {
        return SCHEMA;
    }

    public String path();

    public long length();

    public int partitionSpecId();

    public Long snapshotId();

    default public boolean hasAddedFiles() {
        return this.addedFilesCount() == null || this.addedFilesCount() > 0;
    }

    public Integer addedFilesCount();

    public Long addedRowsCount();

    default public boolean hasExistingFiles() {
        return this.existingFilesCount() == null || this.existingFilesCount() > 0;
    }

    public Integer existingFilesCount();

    public Long existingRowsCount();

    default public boolean hasDeletedFiles() {
        return this.deletedFilesCount() == null || this.deletedFilesCount() > 0;
    }

    public Integer deletedFilesCount();

    public Long deletedRowsCount();

    public List<PartitionFieldSummary> partitions();

    public ManifestFile copy();

    public static interface PartitionFieldSummary {
        public static final Types.StructType TYPE = ManifestFile.schema().findType("partitions").asListType().elementType().asStructType();

        public static Types.StructType getType() {
            return TYPE;
        }

        public boolean containsNull();

        public ByteBuffer lowerBound();

        public ByteBuffer upperBound();

        public PartitionFieldSummary copy();
    }
}

