/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class Expression {
    protected static final Double ZERO = new Double(0.0);
    protected static final Double ONE = new Double(1.0);
    protected static final Double NOT_A_NUMBER = new Double(Double.NaN);
    private boolean contextDependencyKnown = false;
    private boolean contextDependent;

    public synchronized boolean isContextDependent() {
        if (!this.contextDependencyKnown) {
            this.contextDependent = this.computeContextDependent();
            this.contextDependencyKnown = true;
        }
        return this.contextDependent;
    }

    public abstract boolean computeContextDependent();

    public abstract Object computeValue(EvalContext var1);

    public abstract Object compute(EvalContext var1);

    public Iterator iterate(EvalContext context) {
        Object result = this.compute(context);
        if (result instanceof EvalContext) {
            return new ValueIterator((EvalContext)result);
        }
        if (result instanceof NodeSet) {
            return new ValueIterator(((NodeSet)result).getPointers().iterator());
        }
        return ValueUtils.iterate(result);
    }

    public Iterator iteratePointers(EvalContext context) {
        Object result = this.compute(context);
        if (result == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result instanceof EvalContext) {
            return (EvalContext)result;
        }
        if (result instanceof NodeSet) {
            return new PointerIterator(((NodeSet)result).getPointers().iterator(), new QName(null, "value"), context.getRootContext().getCurrentNodePointer().getLocale());
        }
        return new PointerIterator(ValueUtils.iterate(result), new QName(null, "value"), context.getRootContext().getCurrentNodePointer().getLocale());
    }

    public static class ValueIterator
    implements Iterator {
        private Iterator iterator;

        public ValueIterator(Iterator it) {
            this.iterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            return o instanceof Pointer ? ((Pointer)o).getValue() : o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PointerIterator
    implements Iterator {
        private Iterator iterator;
        private QName qname;
        private Locale locale;

        public PointerIterator(Iterator it, QName qname, Locale locale) {
            this.iterator = it;
            this.qname = qname;
            this.locale = locale;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            return o instanceof Pointer ? o : NodePointer.newNodePointer(this.qname, o, this.locale);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

