/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class ParentContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean setStarted = false;
    private NodePointer currentNodePointer;

    public ParentContext(EvalContext parentContext, NodeTest nodeTest) {
        super(parentContext);
        this.nodeTest = nodeTest;
    }

    @Override
    public NodePointer getCurrentNodePointer() {
        return this.currentNodePointer;
    }

    @Override
    public int getCurrentPosition() {
        return 1;
    }

    @Override
    public int getDocumentOrder() {
        return -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.setStarted = false;
    }

    @Override
    public boolean setPosition(int position) {
        super.setPosition(position);
        return position == 1;
    }

    @Override
    public boolean nextNode() {
        if (this.setStarted) {
            return false;
        }
        this.setStarted = true;
        NodePointer thisLocation = this.parentContext.getCurrentNodePointer();
        this.currentNodePointer = thisLocation.getImmediateParentPointer();
        while (this.currentNodePointer != null && this.currentNodePointer.isContainer()) {
            this.currentNodePointer = this.currentNodePointer.getImmediateParentPointer();
        }
        if (this.currentNodePointer != null && this.currentNodePointer.testNode(this.nodeTest)) {
            ++this.position;
            return true;
        }
        return false;
    }
}

