/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.commons.jxpath.JXPathBeanInfo;

public class JXPathBasicBeanInfo
implements JXPathBeanInfo {
    private static final long serialVersionUID = -3863803443111484155L;
    private static final Comparator PROPERTY_DESCRIPTOR_COMPARATOR = new Comparator(){

        public int compare(Object left, Object right) {
            return ((PropertyDescriptor)left).getName().compareTo(((PropertyDescriptor)right).getName());
        }
    };
    private boolean atomic = false;
    private Class clazz;
    private Class dynamicPropertyHandlerClass;
    private transient PropertyDescriptor[] propertyDescriptors;
    private transient HashMap propertyDescriptorMap;

    public JXPathBasicBeanInfo(Class clazz) {
        this.clazz = clazz;
    }

    public JXPathBasicBeanInfo(Class clazz, boolean atomic) {
        this.clazz = clazz;
        this.atomic = atomic;
    }

    public JXPathBasicBeanInfo(Class clazz, Class dynamicPropertyHandlerClass) {
        this.clazz = clazz;
        this.atomic = false;
        this.dynamicPropertyHandlerClass = dynamicPropertyHandlerClass;
    }

    @Override
    public boolean isAtomic() {
        return this.atomic;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamicPropertyHandlerClass != null;
    }

    @Override
    public synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            if (this.clazz == Object.class) {
                this.propertyDescriptors = new PropertyDescriptor[0];
            } else {
                try {
                    BeanInfo bi = this.clazz.isInterface() ? Introspector.getBeanInfo(this.clazz) : Introspector.getBeanInfo(this.clazz, Object.class);
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    PropertyDescriptor[] descriptors = new PropertyDescriptor[pds.length];
                    System.arraycopy(pds, 0, descriptors, 0, pds.length);
                    Arrays.sort(descriptors, PROPERTY_DESCRIPTOR_COMPARATOR);
                    this.propertyDescriptors = descriptors;
                }
                catch (IntrospectionException ex) {
                    ex.printStackTrace();
                    return new PropertyDescriptor[0];
                }
            }
        }
        if (this.propertyDescriptors.length == 0) {
            return this.propertyDescriptors;
        }
        PropertyDescriptor[] result = new PropertyDescriptor[this.propertyDescriptors.length];
        System.arraycopy(this.propertyDescriptors, 0, result, 0, this.propertyDescriptors.length);
        return result;
    }

    @Override
    public synchronized PropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (this.propertyDescriptorMap == null) {
            this.propertyDescriptorMap = new HashMap();
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                this.propertyDescriptorMap.put(pds[i].getName(), pds[i]);
            }
        }
        return (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public Class getDynamicPropertyHandlerClass() {
        return this.dynamicPropertyHandlerClass;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BeanInfo [class = ");
        buffer.append(this.clazz.getName());
        if (this.isDynamic()) {
            buffer.append(", dynamic");
        }
        if (this.isAtomic()) {
            buffer.append(", atomic");
        }
        buffer.append(", properties = ");
        PropertyDescriptor[] jpds = this.getPropertyDescriptors();
        for (int i = 0; i < jpds.length; ++i) {
            buffer.append("\n    ");
            buffer.append(jpds[i].getPropertyType());
            buffer.append(": ");
            buffer.append(jpds[i].getName());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

