/*
 * Decompiled with CFR 0.152.
 */
package com.aohanyao.jelly.library;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.OvershootInterpolator;
import com.aohanyao.jelly.library.R;
import com.aohanyao.jelly.library.inf.BouncingJellyListener;
import com.aohanyao.jelly.library.util.BouncingInterpolatorType;
import com.aohanyao.jelly.library.util.ScreenUtils;
import com.nineoldandroids.view.ViewHelper;

public class BouncingJellyView
extends NestedScrollView {
    private int dowY;
    private int moveX;
    private int moveY;
    private float bouncingOffset = 2850.0f;
    private float offsetScale;
    private ValueAnimator animator;
    private boolean isTop = true;
    private String TAG = "BouncingJellyScroolView";
    private BouncingJellyListener onBouncingJellyListener;
    private TimeInterpolator mTimeInterpolator;
    private int mBouncingDuration = 300;
    private int mBouncingType;
    private int dowY2;
    private View childAt;
    private int downY;
    private int downX;
    private int mTouchSlop;

    public BouncingJellyView(Context context) {
        this(context, null);
    }

    public BouncingJellyView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BouncingJellyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(attrs);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.childAt = this.getChildAt(0);
    }

    private void initAttr(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BouncingJellyView);
            this.mTimeInterpolator = BouncingInterpolatorType.getTimeInterpolator(typedArray.getInteger(R.styleable.BouncingJellyView_BouncingInterpolator, 1));
            this.mBouncingDuration = typedArray.getInteger(R.styleable.BouncingJellyView_BouncingDuration, this.mBouncingDuration);
            this.mBouncingType = typedArray.getInt(R.styleable.BouncingJellyView_BouncingType, 3);
            typedArray.recycle();
            this.bouncingOffset = ScreenUtils.getScreenHeight(this.getContext()) * 3;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int contentHeight = this.getChildAt(0).getHeight();
        if (contentHeight > 0 && contentHeight <= ScreenUtils.getScreenHeight(this.getContext())) {
            this.mBouncingType = 1;
        }
    }

    public void bouncingTo() {
        ViewHelper.setPivotX(this.childAt, this.getWidth() / 2);
        ViewHelper.setPivotY(this.childAt, 0.0f);
        ViewHelper.setScaleY(this.childAt, 1.0f + this.offsetScale);
        if (this.onBouncingJellyListener != null) {
            this.onBouncingJellyListener.onBouncingJelly(1.0f + this.offsetScale);
        }
    }

    public void bouncingBottom() {
        ViewHelper.setPivotX(this.childAt, this.getWidth() / 2);
        ViewHelper.setPivotY(this.childAt, this.childAt.getHeight());
        ViewHelper.setScaleY(this.childAt, 1.0f + this.offsetScale);
        if (this.onBouncingJellyListener != null) {
            this.onBouncingJellyListener.onBouncingJelly(1.0f + this.offsetScale);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.dowY = (int)event.getRawY();
                this.dowY2 = (int)event.getRawY();
                break;
            }
            case 2: {
                if (this.mBouncingType == 0) break;
                this.moveX = (int)event.getRawX();
                this.moveY = (int)event.getRawY();
                int dy = this.moveY - this.dowY;
                this.dowY = this.moveY;
                if (dy > 0 && this.getScrollY() == 0) {
                    if (this.mBouncingType == 1 || this.mBouncingType == 3) {
                        int abs = this.moveY - this.dowY2;
                        this.offsetScale = (float)Math.abs(abs) / this.bouncingOffset;
                        if (this.offsetScale > 0.3f) {
                            this.offsetScale = 0.3f;
                        }
                        this.isTop = true;
                        this.bouncingTo();
                        return true;
                    }
                } else if (this.getScrollY() == 0 && dy < 0 && this.offsetScale > 0.0f && (this.mBouncingType == 1 || this.mBouncingType == 3)) {
                    int abs = this.moveY - this.dowY2;
                    this.offsetScale = (float)Math.abs(abs) / this.bouncingOffset;
                    if (this.offsetScale > 0.3f) {
                        this.offsetScale = 0.3f;
                    }
                    if (abs <= 0) {
                        this.offsetScale = 0.0f;
                        this.dowY2 = this.moveY;
                    }
                    this.isTop = true;
                    this.bouncingTo();
                    return true;
                }
                if (dy < 0 && this.getScrollY() + this.getHeight() >= this.computeVerticalScrollRange()) {
                    if (this.mBouncingType != 2 && this.mBouncingType != 3) break;
                    int abs = this.moveY - this.dowY2;
                    this.offsetScale = (float)Math.abs(abs) / this.bouncingOffset;
                    if (this.offsetScale > 0.3f) {
                        this.offsetScale = 0.3f;
                    }
                    this.isTop = false;
                    this.bouncingBottom();
                    break;
                }
                if (dy <= 0 || this.getScrollY() + this.getHeight() < this.computeVerticalScrollRange() || !(this.offsetScale > 0.0f) || this.mBouncingType != 2 && this.mBouncingType != 3) break;
                int abs = this.moveY - this.dowY2;
                this.offsetScale = (float)Math.abs(abs) / this.bouncingOffset;
                if (this.offsetScale > 0.3f) {
                    this.offsetScale = 0.3f;
                }
                if (abs >= 0) {
                    this.offsetScale = 0.0f;
                    this.dowY2 = this.moveY;
                }
                this.isTop = false;
                this.bouncingBottom();
                return true;
            }
            case 1: {
                if (this.mBouncingType == 0 || !(this.offsetScale > 0.0f)) break;
                this.backBouncing(this.offsetScale, 0.0f);
                return true;
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        int action = e.getAction();
        switch (action) {
            case 0: {
                this.downX = (int)e.getRawX();
                this.downY = (int)e.getRawY();
                break;
            }
            case 2: {
                int moveY = (int)e.getRawY();
                if (Math.abs(moveY - this.downY) <= this.mTouchSlop) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    private void backBouncing(float from, float to) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
            this.animator = null;
            this.offsetScale = 0.0f;
            this.bouncingTo();
        }
        if (this.mTimeInterpolator == null) {
            this.mTimeInterpolator = new OvershootInterpolator();
        }
        this.animator = ValueAnimator.ofFloat((float[])new float[]{from, to}).setDuration((long)this.mBouncingDuration);
        this.animator.setInterpolator(this.mTimeInterpolator);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BouncingJellyView.this.offsetScale = ((Float)animation.getAnimatedValue()).floatValue();
                if (BouncingJellyView.this.isTop) {
                    BouncingJellyView.this.bouncingTo();
                } else {
                    BouncingJellyView.this.bouncingBottom();
                }
            }
        });
        this.animator.start();
    }

    public void setOnBouncingJellyListener(BouncingJellyListener onBouncingJellyListener) {
        this.onBouncingJellyListener = onBouncingJellyListener;
    }

    public void setmTimeInterpolator(TimeInterpolator mTimeInterpolator) {
        this.mTimeInterpolator = mTimeInterpolator;
    }

    public void setmTimeInterpolatorType() {
    }

    public void setmBouncingDuration(int mBouncingDuration) {
        this.mBouncingDuration = mBouncingDuration;
    }
}

