/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import com.github.anzewei.parallaxbacklayout.ViewDragHelper;

public class ParallaxBackLayout
extends FrameLayout {
    private Rect mInsets = new Rect();
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.3f;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int EDGE_LEFT = 1;
    public static final int LAYOUT_PARALLAX = 1;
    public static final int LAYOUT_COVER = 0;
    public static final int LAYOUT_SLIDE = 2;
    private float mScrollThreshold = 0.3f;
    private Activity mSwipeHelper;
    private boolean mEnable = true;
    private View mContentView;
    private ViewDragHelper mDragHelper;
    private ViewDragCallback mViewDragCallback = new ViewDragCallback();
    private int mContentLeft;
    private int mContentTop;
    private int mLayoutType = 1;
    private IBackgroundView mBackgroundView;
    private GradientDrawable mShadowLeft;
    private boolean mInLayout;
    private int mTrackingEdge;
    private int mEdgeFlag = -1;

    public ParallaxBackLayout(Context context) {
        super(context);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, this.mViewDragCallback);
        this.setEdgeFlag(1);
    }

    @TargetApi(value=20)
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        int top = insets.getSystemWindowInsetTop();
        if (this.mContentView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mContentView.getLayoutParams();
            this.mInsets.set(params.leftMargin, params.topMargin + top, params.rightMargin, params.bottomMargin);
        }
        this.applyWindowInset();
        return super.onApplyWindowInsets(insets);
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public void setScrollThresHold(float threshold) {
        if (threshold >= 1.0f || threshold <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollThreshold = threshold;
    }

    public void attachToActivity(Activity activity) {
        this.mSwipeHelper = activity;
        ViewGroup decor = (ViewGroup)activity.getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild, -1, -1);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
    }

    private void applyWindowInset() {
        if (this.mInsets == null) {
            return;
        }
        if (this.mEdgeFlag == 4) {
            this.mDragHelper.setEdgeSize(this.mInsets.top + this.mDragHelper.getEdgeSizeDefault());
        } else if (this.mEdgeFlag == 8) {
            this.mDragHelper.setEdgeSize(this.mInsets.bottom + this.mDragHelper.getEdgeSizeDefault());
        } else if (this.mEdgeFlag == 1) {
            this.mDragHelper.setEdgeSize(this.mDragHelper.getEdgeSizeDefault() + this.mInsets.left);
        } else {
            this.mDragHelper.setEdgeSize(this.mDragHelper.getEdgeSizeDefault() + this.mInsets.right);
        }
    }

    public void scrollToFinishActivity() {
        int childWidth = this.mContentView.getWidth();
        int left = 0;
        int top = 0;
        left = childWidth;
        this.mTrackingEdge = 1;
        this.mDragHelper.smoothSlideViewTo(this.mContentView, left, top);
        this.invalidate();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mEnable || !this.mBackgroundView.canGoBack()) {
            return false;
        }
        try {
            return this.mDragHelper.shouldInterceptTouchEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable || !this.mBackgroundView.canGoBack()) {
            return false;
        }
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            int cleft = this.mContentLeft;
            int ctop = this.mContentTop;
            ViewGroup.LayoutParams params = this.mContentView.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                cleft += ((ViewGroup.MarginLayoutParams)params).leftMargin;
                ctop += ((ViewGroup.MarginLayoutParams)params).topMargin;
            }
            this.mContentView.layout(cleft, ctop, cleft + this.mContentView.getMeasuredWidth(), ctop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawContent;
        boolean bl = drawContent = child == this.mContentView;
        if (this.mEnable) {
            this.drawThumb(canvas, child);
        }
        boolean ret = super.drawChild(canvas, child, drawingTime);
        if (this.mEnable && drawContent && this.mDragHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
        }
        return ret;
    }

    private void drawThumb(Canvas canvas, View child) {
        if (this.mContentLeft == 0 && this.mContentTop == 0) {
            return;
        }
        int store = canvas.save();
        if (this.mLayoutType == 1) {
            this.translateParallax(canvas, child);
        } else if (this.mLayoutType == 2) {
            this.translateSlide(canvas, child);
        } else {
            this.translateCover(canvas, child);
        }
        this.mBackgroundView.draw(canvas);
        canvas.restoreToCount(store);
    }

    private void translateParallax(Canvas canvas, View child) {
        if (this.mEdgeFlag == 1) {
            int left = (child.getLeft() - this.getWidth()) / 2;
            canvas.translate((float)left, 0.0f);
            canvas.clipRect(0, 0, left + this.getWidth(), child.getBottom());
        } else if (this.mEdgeFlag == 4) {
            int top = (child.getTop() - child.getHeight()) / 2;
            canvas.translate(0.0f, (float)top);
            canvas.clipRect(0, 0, child.getRight(), child.getHeight() + top + this.getSystemBarSize());
        } else if (this.mEdgeFlag == 2) {
            int left = (child.getLeft() + child.getWidth() - this.mInsets.left) / 2;
            canvas.translate((float)left, 0.0f);
            canvas.clipRect(left + this.mInsets.left, 0, this.getWidth(), child.getBottom());
        } else if (this.mEdgeFlag == 8) {
            int top = (child.getBottom() - this.getSystemBarSize()) / 2;
            canvas.translate(0.0f, (float)top);
            canvas.clipRect(0, top + this.getSystemBarSize(), child.getRight(), this.getHeight());
        }
    }

    private void translateSlide(Canvas canvas, View child) {
        if (this.mEdgeFlag == 1) {
            int left = child.getLeft() - child.getWidth() - this.mInsets.left;
            canvas.translate((float)left, 0.0f);
        } else if (this.mEdgeFlag == 4) {
            int top = child.getTop() - child.getHeight() + this.getSystemBarSize();
            canvas.translate(0.0f, (float)top);
        } else if (this.mEdgeFlag == 2) {
            int left = child.getRight() - this.mInsets.left;
            canvas.translate((float)left, 0.0f);
        } else if (this.mEdgeFlag == 8) {
            int top = child.getBottom() - this.getSystemBarSize();
            canvas.translate(0.0f, (float)top);
            canvas.clipRect(0, this.getSystemBarSize(), child.getRight(), this.getHeight());
        }
    }

    private void translateCover(Canvas canvas, View child) {
        if (this.mEdgeFlag == 1) {
            canvas.clipRect(0, 0, child.getLeft(), child.getBottom());
        } else if (this.mEdgeFlag == 4) {
            canvas.clipRect(0, 0, child.getRight(), child.getTop() + this.getSystemBarSize());
        } else if (this.mEdgeFlag == 2) {
            canvas.clipRect(child.getRight(), 0, this.getWidth(), child.getBottom());
        } else if (this.mEdgeFlag == 8) {
            canvas.clipRect(0, child.getBottom(), child.getRight(), this.getHeight());
        }
    }

    private void drawShadow(Canvas canvas, View child) {
        if (this.mContentLeft == 0 && this.mContentTop == 0) {
            return;
        }
        if (this.mEdgeFlag == 1) {
            this.mShadowLeft.setBounds(child.getLeft() - this.mShadowLeft.getIntrinsicWidth(), child.getTop(), child.getLeft(), child.getBottom());
        } else if (this.mEdgeFlag == 2) {
            this.mShadowLeft.setBounds(child.getRight(), child.getTop(), child.getRight() + this.mShadowLeft.getIntrinsicWidth(), child.getBottom());
        } else if (this.mEdgeFlag == 8) {
            this.mShadowLeft.setBounds(child.getLeft(), child.getBottom(), child.getRight(), child.getBottom() + this.mShadowLeft.getIntrinsicHeight());
        } else if (this.mEdgeFlag == 4) {
            this.mShadowLeft.setBounds(child.getLeft(), child.getTop() - this.mShadowLeft.getIntrinsicHeight() + this.getSystemBarSize(), child.getRight(), child.getTop() + this.getSystemBarSize());
        }
        this.mShadowLeft.draw(canvas);
    }

    public void setBackgroundView(IBackgroundView backgroundView) {
        this.mBackgroundView = backgroundView;
    }

    public int getEdgeFlag() {
        return this.mEdgeFlag;
    }

    @TargetApi(value=16)
    public void setEdgeFlag(int edgeFlag) {
        if (this.mEdgeFlag == edgeFlag) {
            return;
        }
        this.mEdgeFlag = edgeFlag;
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        if (edgeFlag == 1) {
            orientation = GradientDrawable.Orientation.RIGHT_LEFT;
        } else if (edgeFlag == 4) {
            orientation = GradientDrawable.Orientation.BOTTOM_TOP;
        } else if (edgeFlag == 2) {
            orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        } else if (edgeFlag == 8) {
            orientation = GradientDrawable.Orientation.TOP_BOTTOM;
        }
        if (Build.VERSION.SDK_INT < 16) {
            this.mShadowLeft = null;
        }
        if (this.mShadowLeft == null) {
            int[] colors = new int[]{-1728053248, 0x11000000, 0};
            this.mShadowLeft = new GradientDrawable(orientation, colors);
            this.mShadowLeft.setGradientRadius(90.0f);
            this.mShadowLeft.setSize(50, 50);
        } else {
            this.mShadowLeft.setOrientation(orientation);
        }
        this.applyWindowInset();
    }

    private int getSystemBarSize() {
        return this.mInsets.top;
    }

    public int getLayoutType() {
        return this.mLayoutType;
    }

    public void setLayoutType(int layoutType) {
        this.mLayoutType = layoutType;
    }

    public static interface IBackgroundView {
        public void draw(Canvas var1);

        public boolean canGoBack();
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private float mScrollPercent;

        private ViewDragCallback() {
        }

        @Override
        public boolean tryCaptureView(View view, int pointerId) {
            boolean ret = ParallaxBackLayout.this.mDragHelper.isEdgeTouched(ParallaxBackLayout.this.mEdgeFlag, pointerId);
            if (ret) {
                ParallaxBackLayout.this.mTrackingEdge = ParallaxBackLayout.this.mEdgeFlag;
            }
            boolean directionCheck = false;
            if (ParallaxBackLayout.this.mEdgeFlag == 1 || ParallaxBackLayout.this.mEdgeFlag == 2) {
                directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(2, pointerId);
            } else if (ParallaxBackLayout.this.mEdgeFlag == 8 || ParallaxBackLayout.this.mEdgeFlag == 4) {
                directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(1, pointerId);
            }
            return ret & directionCheck;
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return ParallaxBackLayout.this.mEdgeFlag & 3;
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return ParallaxBackLayout.this.mEdgeFlag & 0xC;
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                this.mScrollPercent = Math.abs((float)(left - ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left) / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                this.mScrollPercent = Math.abs((float)(left - ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left) / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                this.mScrollPercent = Math.abs((float)(top - ParallaxBackLayout.this.getSystemBarSize()) / (float)ParallaxBackLayout.this.mContentView.getHeight());
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                this.mScrollPercent = Math.abs((float)top / (float)ParallaxBackLayout.this.mContentView.getHeight());
            }
            ParallaxBackLayout.this.mContentLeft = left;
            ParallaxBackLayout.this.mContentTop = top;
            ParallaxBackLayout.this.invalidate();
            if ((double)this.mScrollPercent >= 0.999 && !ParallaxBackLayout.this.mSwipeHelper.isFinishing()) {
                ParallaxBackLayout.this.mSwipeHelper.finish();
                ParallaxBackLayout.this.mSwipeHelper.overridePendingTransition(0, 0);
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int childHeight = releasedChild.getHeight();
            int left = ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            int top = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                int n = left = xvel >= 0.0f && this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? childWidth + ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left : ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                int n = left = xvel <= 0.0f && this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? -childWidth + ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left : ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                int n = top = yvel >= 0.0f && this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? childHeight : 0;
            }
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                top = yvel <= 0.0f && this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? -childHeight + ParallaxBackLayout.this.getSystemBarSize() : 0;
            }
            ParallaxBackLayout.this.mDragHelper.settleCapturedViewAt(left, top);
            ParallaxBackLayout.this.invalidate();
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = ((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            } else if ((ParallaxBackLayout.this.mTrackingEdge & 2) != 0) {
                ret = Math.min(((ParallaxBackLayout)ParallaxBackLayout.this).mInsets.left, Math.max(left, -child.getWidth()));
            }
            return ret;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            int ret = ParallaxBackLayout.this.mContentView.getTop();
            if ((ParallaxBackLayout.this.mTrackingEdge & 8) != 0) {
                ret = Math.min(0, Math.max(top, -child.getHeight()));
            } else if ((ParallaxBackLayout.this.mTrackingEdge & 4) != 0) {
                ret = Math.min(child.getHeight(), Math.max(top, 0));
            }
            return ret;
        }
    }
}

