/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.github.anzewei.parallaxbacklayout.LinkedStack;
import com.github.anzewei.parallaxbacklayout.ParallaxBack;
import com.github.anzewei.parallaxbacklayout.R;
import com.github.anzewei.parallaxbacklayout.widget.ParallaxBackLayout;

public class ParallaxHelper
implements Application.ActivityLifecycleCallbacks {
    private static ParallaxHelper sParallaxHelper;
    private LinkedStack<Activity, TraceInfo> mLinkedStack = new LinkedStack();

    public static ParallaxHelper getInstance() {
        if (sParallaxHelper == null) {
            sParallaxHelper = new ParallaxHelper();
        }
        return sParallaxHelper;
    }

    private ParallaxHelper() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        TraceInfo traceInfo = new TraceInfo();
        this.mLinkedStack.put(activity, traceInfo);
        traceInfo.mCurrent = activity;
        ParallaxBack parallaxBack = this.checkAnnotation(activity.getClass());
        if (this.mLinkedStack.size() > 0 && parallaxBack != null) {
            ParallaxBackLayout layout = ParallaxHelper.enableParallaxBack(activity);
            layout.setEdgeFlag(parallaxBack.edge().getValue());
            layout.setEdgeMode(parallaxBack.edgeMode().getValue());
            layout.setLayoutType(parallaxBack.layout().getValue(), null);
        }
    }

    private ParallaxBack checkAnnotation(Class<? extends Activity> c) {
        Class<? extends Activity> mc = c;
        while (Activity.class.isAssignableFrom(mc)) {
            ParallaxBack parallaxBack = mc.getAnnotation(ParallaxBack.class);
            if (parallaxBack != null) {
                return parallaxBack;
            }
            mc = mc.getSuperclass();
        }
        return null;
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mLinkedStack.remove(activity);
    }

    public static void disableParallaxBack(Activity activity) {
        ParallaxBackLayout layout = ParallaxHelper.getParallaxBackLayout(activity);
        if (layout != null) {
            layout.setEnableGesture(false);
        }
    }

    public static ParallaxBackLayout enableParallaxBack(Activity activity) {
        ParallaxBackLayout layout = ParallaxHelper.getParallaxBackLayout(activity, true);
        layout.setEnableGesture(true);
        return layout;
    }

    public static ParallaxBackLayout getParallaxBackLayout(Activity activity) {
        return ParallaxHelper.getParallaxBackLayout(activity, false);
    }

    public static ParallaxBackLayout getParallaxBackLayout(Activity activity, boolean create) {
        View view = ((ViewGroup)activity.getWindow().getDecorView()).getChildAt(0);
        if (view instanceof ParallaxBackLayout) {
            return (ParallaxBackLayout)view;
        }
        view = activity.findViewById(R.id.pllayout);
        if (view instanceof ParallaxBackLayout) {
            return (ParallaxBackLayout)view;
        }
        if (create) {
            ParallaxBackLayout backLayout = new ParallaxBackLayout((Context)activity);
            backLayout.setId(R.id.pllayout);
            backLayout.attachToActivity(activity);
            backLayout.setBackgroundView(new GoBackView(activity));
            return backLayout;
        }
        return null;
    }

    public static class GoBackView
    implements ParallaxBackLayout.IBackgroundView {
        private Activity mActivity;
        private Activity mActivityBack;

        private GoBackView(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mActivityBack != null) {
                this.mActivityBack.getWindow().getDecorView().requestLayout();
                this.mActivityBack.getWindow().getDecorView().draw(canvas);
            }
        }

        @Override
        public boolean canGoBack() {
            this.mActivityBack = sParallaxHelper.mLinkedStack.before(this.mActivity);
            return this.mActivityBack != null;
        }
    }

    public static class TraceInfo {
        private Activity mCurrent;
    }
}

