/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.github.anzewei.parallaxbacklayout.LinkedStack;
import com.github.anzewei.parallaxbacklayout.ParallaxBack;
import com.github.anzewei.parallaxbacklayout.ParallaxBackLayout;
import com.github.anzewei.parallaxbacklayout.R;

public class ParallaxHelper
implements Application.ActivityLifecycleCallbacks {
    private static ParallaxHelper sParallaxHelper;
    private LinkedStack<Activity, TraceInfo> mLinkedStack = new LinkedStack();

    public static ParallaxHelper getInstance() {
        if (sParallaxHelper == null) {
            sParallaxHelper = new ParallaxHelper();
        }
        return sParallaxHelper;
    }

    private ParallaxHelper() {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Log.d((String)ParallaxHelper.class.getSimpleName(), (String)(activity + "onActivityCreated"));
        TraceInfo traceInfo = new TraceInfo();
        this.mLinkedStack.put(activity, traceInfo);
        traceInfo.mCurrent = activity;
        if (this.mLinkedStack.size() > 0 && activity.getClass().getAnnotation(ParallaxBack.class) != null) {
            traceInfo.mBackLayout = new ParallaxBackLayout((Context)activity);
            traceInfo.mBackLayout.setId(R.id.pllayout);
            traceInfo.mBackLayout.attachToActivity(activity);
            traceInfo.mBackLayout.setBackgroundView(new GoBackView(activity));
        }
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        Log.d((String)ParallaxHelper.class.getSimpleName(), (String)(activity + "onActivitySaveInstanceState"));
    }

    public void onActivityDestroyed(Activity activity) {
        this.mLinkedStack.remove(activity);
        Log.d((String)ParallaxHelper.class.getSimpleName(), (String)(activity + "onActivityDestroyed"));
    }

    public ParallaxBackLayout getParallaxBackLayout(Activity activity) {
        View view = ((ViewGroup)activity.getWindow().getDecorView()).getChildAt(0);
        if (view instanceof ParallaxBackLayout) {
            return (ParallaxBackLayout)view;
        }
        view = activity.findViewById(R.id.pllayout);
        if (view instanceof ParallaxBackLayout) {
            return (ParallaxBackLayout)view;
        }
        return null;
    }

    private static class GoBackView
    implements ParallaxBackLayout.IBackgroundView {
        private Activity mActivity;
        private Activity mActivityBack;

        private GoBackView(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mActivityBack != null) {
                this.mActivityBack.getWindow().getDecorView().draw(canvas);
            }
        }

        @Override
        public boolean canGoBack() {
            this.mActivityBack = sParallaxHelper.mLinkedStack.before(this.mActivity);
            return this.mActivityBack != null;
        }
    }

    public static class TraceInfo {
        private Activity mCurrent;
        private ParallaxBackLayout mBackLayout;
    }
}

