/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.anzewei.parallaxbacklayout.ParallaxBackActivityHelper;
import com.github.anzewei.parallaxbacklayout.R;
import com.github.anzewei.parallaxbacklayout.ViewDragHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ParallaxBackLayout
extends FrameLayout {
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.3f;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int EDGE_LEFT = 1;
    private float mScrollThreshold = 0.3f;
    private ParallaxBackActivityHelper mSwipeHelper;
    private boolean mEnable = true;
    private View mContentView;
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, new ViewDragCallback());
    private float mScrollPercent;
    private int mContentLeft;
    private int mContentTop;
    private String mThumbFile;
    private Drawable mShadowLeft = this.getResources().getDrawable(R.drawable.shadow_left);
    private Bitmap mSecondBitmap;
    private Paint mPaintCache = new Paint(1);
    private float mScrimOpacity;
    private int mScrimColor = -1728053248;
    private boolean mInLayout;
    private int mTrackingEdge;

    public ParallaxBackLayout(Context context) {
        this(context, null);
    }

    public ParallaxBackLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ParallaxBackLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public void setScrimColor(int color) {
        this.mScrimColor = color;
        this.invalidate();
    }

    public void setScrollThresHold(float threshold) {
        if (threshold >= 1.0f || threshold <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollThreshold = threshold;
    }

    public void onStartActivity() {
        this.buildDrawingCache();
        final Bitmap bitmap = this.getDrawingCache();
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileOutputStream fileOutputStream = null;
                try {
                    File bmpFile = ParallaxBackLayout.this.getCacheFile();
                    File tmpFile = new File(bmpFile.getParent(), bmpFile.getName() + "tmp");
                    fileOutputStream = new FileOutputStream(tmpFile);
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)fileOutputStream);
                    ParallaxBackLayout.this.destroyDrawingCache();
                    fileOutputStream.close();
                    tmpFile.renameTo(bmpFile);
                }
                catch (FileNotFoundException bmpFile) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void attachToActivity(ParallaxBackActivityHelper activity) {
        this.mSwipeHelper = activity;
        ViewGroup decor = (ViewGroup)activity.getActivity().getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
        this.mThumbFile = activity.getActivity().getIntent().getStringExtra("plfile");
    }

    public void scrollToFinishActivity() {
        if (!this.mEnable || this.mThumbFile == null) {
            this.mSwipeHelper.getActivity().finish();
            return;
        }
        if (!new File(this.mThumbFile).exists()) {
            return;
        }
        int childWidth = this.mContentView.getWidth();
        int left = 0;
        int top = 0;
        left = childWidth;
        this.mTrackingEdge = 1;
        this.mDragHelper.smoothSlideViewTo(this.mContentView, left, top);
        this.invalidate();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.onStartActivity();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.filename = this.mThumbFile;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mThumbFile = ss.filename;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return false;
        }
        try {
            return this.mDragHelper.shouldInterceptTouchEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable || this.mThumbFile == null || !new File(this.mThumbFile).exists()) {
            return false;
        }
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            this.mContentView.layout(this.mContentLeft, this.mContentTop, this.mContentLeft + this.mContentView.getMeasuredWidth(), this.mContentTop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawContent;
        boolean bl = drawContent = child == this.mContentView;
        if (this.mEnable && this.mThumbFile != null) {
            this.drawThumb(canvas, child);
        }
        boolean ret = super.drawChild(canvas, child, drawingTime);
        if (this.mThumbFile != null && this.mEnable && this.mScrimOpacity > 0.0f && drawContent && this.mDragHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
            this.drawScrim(canvas, child);
        }
        return ret;
    }

    private void drawScrim(Canvas canvas, View child) {
        int baseAlpha = (this.mScrimColor & 0xFF000000) >>> 24;
        int alpha = (int)((float)baseAlpha * this.mScrimOpacity);
        int color = alpha << 24 | this.mScrimColor & 0xFFFFFF;
        if ((this.mTrackingEdge & 1) != 0) {
            canvas.clipRect(0, 0, child.getLeft(), this.getHeight());
        }
        canvas.drawColor(color);
    }

    private void drawThumb(Canvas canvas, View child) {
        Bitmap bitmap;
        if (child.getLeft() == 0) {
            return;
        }
        int store = canvas.save();
        int left = (child.getLeft() - this.getWidth()) / 2;
        canvas.translate((float)left, 0.0f);
        canvas.clipRect(0, 0, (child.getLeft() + this.getWidth()) / 2, child.getBottom());
        if (this.mThumbFile != null && (bitmap = this.getCacheBitmap(this.mThumbFile)) != null) {
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mPaintCache);
        }
        canvas.restoreToCount(store);
    }

    private Bitmap getCacheBitmap(String cacheFile) {
        if (this.mSecondBitmap != null && !this.mSecondBitmap.isRecycled()) {
            return this.mSecondBitmap;
        }
        this.mSecondBitmap = BitmapFactory.decodeFile((String)cacheFile);
        return this.mSecondBitmap;
    }

    private void drawShadow(Canvas canvas, View child) {
        this.mShadowLeft.setBounds(child.getLeft() - this.mShadowLeft.getIntrinsicWidth(), child.getTop(), child.getLeft(), child.getBottom());
        this.mShadowLeft.setAlpha((int)(this.mScrimOpacity * 255.0f));
        this.mShadowLeft.draw(canvas);
    }

    public File getCacheFile() {
        File file = this.getContext().getCacheDir();
        File bmpFile = new File(file, String.valueOf(System.identityHashCode((Object)this)));
        return bmpFile;
    }

    static class SavedState
    extends View.BaseSavedState {
        String filename;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.filename = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.filename);
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private boolean mIsScrollOverValid;

        private ViewDragCallback() {
        }

        @Override
        public boolean tryCaptureView(View view, int i) {
            boolean ret = ParallaxBackLayout.this.mDragHelper.isEdgeTouched(1, i);
            if (ret) {
                ParallaxBackLayout.this.mTrackingEdge = 1;
                this.mIsScrollOverValid = true;
            }
            boolean directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(2, i);
            return ret & directionCheck;
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return 1;
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return 0;
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ParallaxBackLayout.this.mScrollPercent = Math.abs((float)left / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            ParallaxBackLayout.this.mContentLeft = left;
            ParallaxBackLayout.this.mContentTop = top;
            ParallaxBackLayout.this.invalidate();
            if (ParallaxBackLayout.this.mScrollPercent < ParallaxBackLayout.this.mScrollThreshold && !this.mIsScrollOverValid) {
                this.mIsScrollOverValid = true;
            }
            if ((double)ParallaxBackLayout.this.mScrollPercent >= 0.9 && !ParallaxBackLayout.this.mSwipeHelper.getActivity().isFinishing()) {
                File file;
                ParallaxBackLayout.this.mSwipeHelper.getActivity().finish();
                ParallaxBackLayout.this.mSwipeHelper.getActivity().overridePendingTransition(0, 0);
                if (ParallaxBackLayout.this.mThumbFile != null && (file = new File(ParallaxBackLayout.this.mThumbFile)).exists()) {
                    file.delete();
                }
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int left = 0;
            int top = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                left = xvel > 0.0f || xvel == 0.0f && ParallaxBackLayout.this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? childWidth : 0;
            }
            ParallaxBackLayout.this.mDragHelper.settleCapturedViewAt(left, top);
            ParallaxBackLayout.this.invalidate();
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            }
            return ret;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return 0;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
        }
    }
}

