/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.github.anzewei.parallaxbacklayout.ParallaxBackActivityHelper;
import com.github.anzewei.parallaxbacklayout.ParallaxBackLayout;

public abstract class ParallaxActivityBase
extends AppCompatActivity {
    private ParallaxBackActivityHelper mHelper;

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.mHelper.onPostCreate();
    }

    @NonNull
    public View findViewById(int id) {
        View v = super.findViewById(id);
        if (v == null && this.mHelper != null) {
            return this.mHelper.findViewById(id);
        }
        return v;
    }

    public ParallaxBackLayout getBackLayout() {
        return this.mHelper.getBackLayout();
    }

    public void setBackEnable(boolean enable) {
        this.mHelper.setBackEnable(enable);
    }

    public void scrollToFinishActivity() {
        this.mHelper.scrollToFinishActivity();
    }

    public void onBackPressed() {
        if (!this.getSupportFragmentManager().popBackStackImmediate()) {
            this.scrollToFinishActivity();
        }
    }

    public void startActivityForResult(Intent intent, int requestCode, @Nullable Bundle options) {
        intent.putExtra("plfile", this.mHelper.getBackLayout().getCacheFile().getAbsolutePath());
        super.startActivityForResult(intent, requestCode, options);
        this.mHelper.onStartActivity();
    }

    protected void onCreate(Bundle arg0) {
        super.onCreate(arg0);
        this.mHelper = new ParallaxBackActivityHelper((Activity)this);
    }
}

