/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.anzewei.parallaxbacklayout.ParallaxActivityBase;
import com.github.anzewei.parallaxbacklayout.ParallaxBackActivityHelper;
import com.github.anzewei.parallaxbacklayout.R;
import com.github.anzewei.parallaxbacklayout.ViewDragHelper;

public class ParallaxBackLayout
extends FrameLayout {
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int FULL_ALPHA = 255;
    private static final float DEFAULT_SCROLL_THRESHOLD = 0.3f;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int EDGE_LEFT = 1;
    private float mScrollThreshold = 0.3f;
    private ParallaxBackActivityHelper mSwipeHelper;
    private boolean mEnable = true;
    private View mContentView;
    private ViewDragHelper mDragHelper = ViewDragHelper.create((ViewGroup)this, new ViewDragCallback());
    private float mScrollPercent;
    private int mContentLeft;
    private int mContentTop;
    private Drawable mShadowLeft = this.getResources().getDrawable(R.drawable.shadow_left);
    private float mScrimOpacity;
    private int mScrimColor = -1728053248;
    private boolean mInLayout;
    private int mTrackingEdge;

    public ParallaxBackLayout(Context context) {
        this(context, null);
    }

    public ParallaxBackLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ParallaxBackLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
    }

    private void setContentView(View view) {
        this.mContentView = view;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setEnableGesture(boolean enable) {
        this.mEnable = enable;
    }

    public void setScrimColor(int color) {
        this.mScrimColor = color;
        this.invalidate();
    }

    public void setScrollThresHold(float threshold) {
        if (threshold >= 1.0f || threshold <= 0.0f) {
            throw new IllegalArgumentException("Threshold value should be between 0 and 1.0");
        }
        this.mScrollThreshold = threshold;
    }

    public void scrollToFinishActivity() {
        if (!this.mEnable) {
            this.mSwipeHelper.getActivity().finish();
            return;
        }
        int childWidth = this.mContentView.getWidth();
        int left = 0;
        int top = 0;
        left = childWidth;
        this.mTrackingEdge = 1;
        this.mDragHelper.smoothSlideViewTo(this.mContentView, left, top);
        this.invalidate();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return false;
        }
        try {
            return this.mDragHelper.shouldInterceptTouchEvent(event);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnable) {
            return false;
        }
        this.mDragHelper.processTouchEvent(event);
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mInLayout = true;
        if (this.mContentView != null) {
            this.mContentView.layout(this.mContentLeft, this.mContentTop, this.mContentLeft + this.mContentView.getMeasuredWidth(), this.mContentTop + this.mContentView.getMeasuredHeight());
        }
        this.mInLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawContent;
        boolean bl = drawContent = child == this.mContentView;
        if (this.mEnable && this.getContext() instanceof ParallaxActivityBase) {
            this.drawThumb(canvas, child);
        }
        boolean ret = super.drawChild(canvas, child, drawingTime);
        if (this.mScrimOpacity > 0.0f && drawContent && this.mDragHelper.getViewDragState() != 0) {
            this.drawShadow(canvas, child);
            this.drawScrim(canvas, child);
        }
        return ret;
    }

    private void drawScrim(Canvas canvas, View child) {
        int baseAlpha = (this.mScrimColor & 0xFF000000) >>> 24;
        int alpha = (int)((float)baseAlpha * this.mScrimOpacity);
        int color = alpha << 24 | this.mScrimColor & 0xFFFFFF;
        if ((this.mTrackingEdge & 1) != 0) {
            canvas.clipRect(0, 0, child.getLeft(), this.getHeight());
        }
        canvas.drawColor(color);
    }

    private void drawThumb(Canvas canvas, View child) {
        if (child.getLeft() == 0) {
            return;
        }
        int store = canvas.save();
        int left = (child.getLeft() - this.getWidth()) / 2;
        canvas.translate((float)left, 0.0f);
        canvas.clipRect(0, 0, (child.getLeft() + this.getWidth()) / 2, child.getBottom());
        ParallaxBackActivityHelper activityBase = this.mSwipeHelper.getSecondActivity();
        if (activityBase != null) {
            activityBase.drawThumb(canvas);
        }
        canvas.restoreToCount(store);
    }

    private void drawShadow(Canvas canvas, View child) {
        this.mShadowLeft.setBounds(child.getLeft() - this.mShadowLeft.getIntrinsicWidth(), child.getTop(), child.getLeft(), child.getBottom());
        this.mShadowLeft.setAlpha((int)(this.mScrimOpacity * 255.0f));
        this.mShadowLeft.draw(canvas);
    }

    public void attachToActivity(ParallaxBackActivityHelper activity) {
        this.mSwipeHelper = activity;
        ViewGroup decor = (ViewGroup)activity.getActivity().getWindow().getDecorView();
        ViewGroup decorChild = (ViewGroup)decor.getChildAt(0);
        decor.removeView((View)decorChild);
        this.addView((View)decorChild);
        this.setContentView((View)decorChild);
        decor.addView((View)this);
    }

    public void computeScroll() {
        this.mScrimOpacity = 1.0f - this.mScrollPercent;
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private boolean mIsScrollOverValid;

        private ViewDragCallback() {
        }

        @Override
        public boolean tryCaptureView(View view, int i) {
            boolean ret = ParallaxBackLayout.this.mDragHelper.isEdgeTouched(1, i);
            if (ret) {
                ParallaxBackLayout.this.mTrackingEdge = 1;
                this.mIsScrollOverValid = true;
            }
            boolean directionCheck = !ParallaxBackLayout.this.mDragHelper.checkTouchSlop(2, i);
            return ret & directionCheck;
        }

        @Override
        public int getViewHorizontalDragRange(View child) {
            return 1;
        }

        @Override
        public int getViewVerticalDragRange(View child) {
            return 0;
        }

        @Override
        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            super.onViewPositionChanged(changedView, left, top, dx, dy);
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ParallaxBackLayout.this.mScrollPercent = Math.abs((float)left / (float)ParallaxBackLayout.this.mContentView.getWidth());
            }
            ParallaxBackLayout.this.mContentLeft = left;
            ParallaxBackLayout.this.mContentTop = top;
            ParallaxBackLayout.this.invalidate();
            if (ParallaxBackLayout.this.mScrollPercent < ParallaxBackLayout.this.mScrollThreshold && !this.mIsScrollOverValid) {
                this.mIsScrollOverValid = true;
            }
            if (ParallaxBackLayout.this.mScrollPercent >= 1.0f && !ParallaxBackLayout.this.mSwipeHelper.getActivity().isFinishing()) {
                ParallaxBackLayout.this.mSwipeHelper.getActivity().finish();
                ParallaxBackLayout.this.mSwipeHelper.getActivity().overridePendingTransition(0, 0);
            }
        }

        @Override
        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int childWidth = releasedChild.getWidth();
            int left = 0;
            int top = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                left = xvel > 0.0f || xvel == 0.0f && ParallaxBackLayout.this.mScrollPercent > ParallaxBackLayout.this.mScrollThreshold ? childWidth : 0;
            }
            ParallaxBackLayout.this.mDragHelper.settleCapturedViewAt(left, top);
            ParallaxBackLayout.this.invalidate();
        }

        @Override
        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int ret = 0;
            if ((ParallaxBackLayout.this.mTrackingEdge & 1) != 0) {
                ret = Math.min(child.getWidth(), Math.max(left, 0));
            }
            return ret;
        }

        @Override
        public int clampViewPositionVertical(View child, int top, int dy) {
            return 0;
        }

        @Override
        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
        }
    }
}

