/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.design;

import android.content.Context;
import android.graphics.Rect;
import android.support.design.widget.CollapsingToolbarLayout;
import android.util.AttributeSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class CollapsingCenterLayout
extends CollapsingToolbarLayout {
    private CollapsingTextHelper mHelper;
    private Rect mRect;

    public CollapsingCenterLayout(Context context) {
        super(context);
        this.findRect();
        this.mHelper = new CollapsingTextHelper(this);
    }

    public CollapsingCenterLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mHelper = new CollapsingTextHelper(this);
        this.findRect();
    }

    public CollapsingCenterLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mHelper = new CollapsingTextHelper(this);
        this.findRect();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mHelper.setCollapsedBounds(0, bottom - this.mRect.height(), this.getWidth(), bottom);
        this.mHelper.recalculate();
    }

    private void findRect() {
        try {
            Field personNameField = CollapsingToolbarLayout.class.getDeclaredField("mTmpRect");
            personNameField.setAccessible(true);
            this.mRect = (Rect)personNameField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CollapsingTextHelper {
        private Object mCollapsingTextHelper;
        private Method methodsetCollapsedBounds;
        private Method methodsetrecalculate;

        CollapsingTextHelper(CollapsingToolbarLayout layout) {
            try {
                Class<?> class1 = Class.forName("android.support.design.widget.CollapsingTextHelper");
                Field personNameField = CollapsingToolbarLayout.class.getDeclaredField("mCollapsingTextHelper");
                personNameField.setAccessible(true);
                this.mCollapsingTextHelper = personNameField.get(layout);
                this.methodsetCollapsedBounds = class1.getDeclaredMethod("setCollapsedBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.methodsetCollapsedBounds.setAccessible(true);
                this.methodsetrecalculate = class1.getMethod("recalculate", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setCollapsedBounds(int left, int top, int right, int bottom) {
            try {
                this.methodsetCollapsedBounds.invoke(this.mCollapsingTextHelper, left, top, right, bottom);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void recalculate() {
            try {
                this.methodsetrecalculate.invoke(this.mCollapsingTextHelper, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

