/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewOffsetHelper;
import android.support.design.widget.ViewUtils;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.github.anzewei.design.R;
import java.lang.reflect.Field;

public class ParallaxScaleBehavior
extends AppBarLayout.Behavior {
    private static final String TAG = "ParallaxScaleBehavior";
    private ViewOffsetHelper mTopHelper;
    private View mContent;
    private ValueAnimatorCompat mAnimator;
    private static final int ANIMATE_PER_SECOND = 300;
    private Field mOffset;
    private CollapsingToolbarLayout mToolLayout;

    public ParallaxScaleBehavior() {
    }

    public ParallaxScaleBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onLayoutChild(CoordinatorLayout parent, AppBarLayout abl, int layoutDirection) {
        if (this.mTopHelper == null) {
            this.mContent = this.getParallaxView(abl);
            if (this.mContent != null) {
                this.mTopHelper = new ViewOffsetHelper(this.mContent);
                this.clipChild(parent, this.mContent);
            }
        }
        if (this.mToolLayout == null) {
            this.mToolLayout = this.getCollapsingToolbarLayout(abl);
        }
        if (this.mOffset == null) {
            this.getField();
        }
        return super.onLayoutChild(parent, abl, layoutDirection);
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, AppBarLayout child, View target, float velocityX, float velocityY) {
        return this.getTopAndBottomOffset() > 0 || super.onNestedPreFling(coordinatorLayout, (View)child, target, velocityX, velocityY);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, AppBarLayout header, int newOffset, int minOffset, int maxOffset) {
        header.setClipChildren(newOffset <= 0);
        int oldTop = this.getTopAndBottomOffset();
        if (oldTop > 0 || newOffset >= 0) {
            return this.overScroll(coordinatorLayout, header, newOffset, this.getMaxRange(header));
        }
        int scale = super.setHeaderTopBottomOffset(coordinatorLayout, header, newOffset, minOffset, maxOffset);
        if (scale == 0 && newOffset > 0 && maxOffset == 0) {
            scale = this.overScroll(coordinatorLayout, header, newOffset, this.getMaxRange(header));
        } else {
            this.scaleContent(1.0f);
            header.setClipChildren(true);
        }
        return scale;
    }

    public boolean onTouchEvent(CoordinatorLayout parent, AppBarLayout child, MotionEvent ev) {
        boolean shouldInterrupt = MotionEventCompat.getActionMasked((MotionEvent)ev) == 1 && this.getTopAndBottomOffset() > 0;
        super.onTouchEvent(parent, (View)child, ev);
        if (shouldInterrupt) {
            if (this.mScroller != null) {
                this.mScroller.abortAnimation();
            }
            this.animateOffsetTo(parent, child, 0);
        }
        return true;
    }

    public boolean onStartNestedScroll(CoordinatorLayout parent, AppBarLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        boolean started = super.onStartNestedScroll(parent, child, directTargetChild, target, nestedScrollAxes);
        if (started && this.mAnimator != null) {
            this.mAnimator.cancel();
        }
        return started;
    }

    public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, AppBarLayout abl, View target) {
        if (this.getTopAndBottomOffset() > 0) {
            this.animateOffsetTo(coordinatorLayout, abl, 0);
        } else {
            super.onStopNestedScroll(coordinatorLayout, abl, target);
        }
    }

    private int getMaxRange(AppBarLayout layout) {
        return layout != null ? layout.getHeight() / 2 : 0;
    }

    private int overScroll(CoordinatorLayout coordinatorLayout, AppBarLayout header, int newOffset, int maxOffset) {
        if (newOffset > maxOffset || this.mTopHelper == null) {
            return 0;
        }
        int c = super.setHeaderTopBottomOffset(coordinatorLayout, header, newOffset, Integer.MIN_VALUE, maxOffset);
        if (c != 0) {
            int top = this.getTopAndBottomOffset();
            this.layoutAppbar(this.mToolLayout, -top);
            float scale = newOffset == 0 ? 1.0f : (float)(this.mContent.getHeight() + newOffset * 2 + 2) / (float)this.mContent.getHeight();
            this.scaleContent(scale);
            if (this.mOffset != null) {
                try {
                    this.mOffset.set(this.mToolLayout, top);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }

    private void scaleContent(float value) {
        value = Math.max(1.0f, value);
        ViewCompat.setScaleY((View)this.mContent, (float)value);
        ViewCompat.setScaleX((View)this.mContent, (float)value);
    }

    public int getTopAndBottomOffset() {
        StackTraceElement stackTrace = Thread.currentThread().getStackTrace()[3];
        if (stackTrace.getMethodName().equals("dispatchOffsetUpdates")) {
            return Math.min(0, super.getTopAndBottomOffset());
        }
        return super.getTopAndBottomOffset();
    }

    private View getParallaxView(AppBarLayout appBarLayout) {
        View view;
        if (appBarLayout.getChildCount() > 0 && (view = appBarLayout.getChildAt(0)) instanceof CollapsingToolbarLayout) {
            int count = ((CollapsingToolbarLayout)view).getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = ((CollapsingToolbarLayout)view).getChildAt(i);
                CollapsingToolbarLayout.LayoutParams params = (CollapsingToolbarLayout.LayoutParams)child.getLayoutParams();
                if (params.getCollapseMode() != 2) continue;
                return child;
            }
        }
        return appBarLayout.findViewById(R.id.image);
    }

    private void layoutAppbar(CollapsingToolbarLayout appBarLayout, int offset) {
        if (appBarLayout == null) {
            return;
        }
        int count = appBarLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = appBarLayout.getChildAt(i);
            CollapsingToolbarLayout.LayoutParams params = (CollapsingToolbarLayout.LayoutParams)view.getLayoutParams();
            if (params.getCollapseMode() != 1) continue;
            ViewOffsetHelper offsetHelper = ParallaxScaleBehavior.getViewOffsetHelper(view);
            offsetHelper.setTopAndBottomOffset(offset);
        }
        Drawable drawable = appBarLayout.getContentScrim();
        if (drawable != null) {
            drawable.getBounds().top = offset > 0 ? 0 : offset;
        }
    }

    private void clipChild(CoordinatorLayout layout, View content) {
        for (ViewGroup viewGroup = (ViewGroup)content.getParent(); viewGroup != layout; viewGroup = (ViewGroup)viewGroup.getParent()) {
            viewGroup.setClipChildren(false);
        }
        layout.setClipChildren(false);
    }

    private static ViewOffsetHelper getViewOffsetHelper(View view) {
        ViewOffsetHelper offsetHelper = (ViewOffsetHelper)view.getTag(R.id.view_offset_helper);
        if (offsetHelper == null) {
            offsetHelper = new ViewOffsetHelper(view);
            view.setTag(R.id.view_offset_helper, (Object)offsetHelper);
        }
        return offsetHelper;
    }

    private CollapsingToolbarLayout getCollapsingToolbarLayout(AppBarLayout appBarLayout) {
        int count = appBarLayout.getChildCount();
        for (int i = 0; i < count; ++i) {
            View c = appBarLayout.getChildAt(i);
            if (!(c instanceof CollapsingToolbarLayout)) continue;
            return (CollapsingToolbarLayout)c;
        }
        return null;
    }

    private void animateOffsetTo(final CoordinatorLayout coordinatorLayout, final AppBarLayout child, int offset) {
        int currentOffset = this.getTopBottomOffsetForScrollingSibling();
        if (currentOffset == offset) {
            if (this.mAnimator != null && this.mAnimator.isRunning()) {
                this.mAnimator.cancel();
            }
            return;
        }
        if (this.mAnimator == null) {
            this.mAnimator = ViewUtils.createAnimator();
            this.mAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
            this.mAnimator.addUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimatorCompat animation) {
                    ParallaxScaleBehavior.this.overScroll(coordinatorLayout, child, animation.getAnimatedIntValue(), ParallaxScaleBehavior.this.getMaxRange(child));
                }
            });
        } else {
            this.mAnimator.cancel();
        }
        float distanceDp = (float)Math.abs(currentOffset - offset) / coordinatorLayout.getResources().getDisplayMetrics().density;
        this.mAnimator.setDuration((long)Math.round(distanceDp * 1000.0f / 300.0f));
        this.mAnimator.setIntValues(currentOffset, offset);
        this.mAnimator.start();
    }

    private void getField() {
        try {
            Field personNameField = CollapsingToolbarLayout.class.getDeclaredField("mCurrentOffset");
            personNameField.setAccessible(true);
            this.mOffset = personNameField;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

