/*
 * Decompiled with CFR 0.152.
 */
package antonkozyriatskyi.circularprogressindicator;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import antonkozyriatskyi.circularprogressindicator.DefaultAnimatorListener;
import antonkozyriatskyi.circularprogressindicator.DefaultProgressTextAdapter;
import antonkozyriatskyi.circularprogressindicator.PatternProgressTextAdapter;
import antonkozyriatskyi.circularprogressindicator.R;

public class CircularProgressIndicator
extends View {
    public static final int DIRECTION_CLOCKWISE = 0;
    public static final int DIRECTION_COUNTERCLOCKWISE = 1;
    public static final int CAP_ROUND = 0;
    public static final int CAP_BUTT = 1;
    private static final int DEFAULT_PROGRESS_START_ANGLE = 270;
    private static final int ANGLE_START_PROGRESS_BACKGROUND = 0;
    private static final int ANGLE_END_PROGRESS_BACKGROUND = 360;
    private static final int DESIRED_WIDTH_DP = 150;
    private static final String DEFAULT_PROGRESS_COLOR = "#3F51B5";
    private static final int DEFAULT_TEXT_SIZE_SP = 24;
    private static final int DEFAULT_STROKE_WIDTH_DP = 8;
    private static final String DEFAULT_PROGRESS_BACKGROUND_COLOR = "#e0e0e0";
    private static final int DEFAULT_ANIMATION_DURATION = 1000;
    private static final String PROPERTY_ANGLE = "angle";
    private Paint progressPaint;
    private Paint progressBackgroundPaint;
    private Paint dotPaint;
    private Paint textPaint;
    private int startAngle = 270;
    private int sweepAngle = 0;
    private RectF circleBounds;
    private String progressText;
    private float textX;
    private float textY;
    private float radius;
    private boolean shouldDrawDot;
    private double maxProgressValue = 100.0;
    private double progressValue = 0.0;
    private boolean isAnimationEnabled;
    @Direction
    private int direction = 1;
    private ValueAnimator progressAnimator;
    @NonNull
    private ProgressTextAdapter progressTextAdapter;
    @Nullable
    private OnProgressChangeListener onProgressChangeListener;

    public CircularProgressIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        int progressColor = Color.parseColor((String)DEFAULT_PROGRESS_COLOR);
        int progressBackgroundColor = Color.parseColor((String)DEFAULT_PROGRESS_BACKGROUND_COLOR);
        int progressStrokeWidth = this.dp2px(8.0f);
        int textColor = progressColor;
        int textSize = this.sp2px(24.0f);
        this.shouldDrawDot = true;
        int dotColor = progressColor;
        int dotWidth = progressStrokeWidth;
        Paint.Cap progressStrokeCap = Paint.Cap.ROUND;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularProgressIndicator);
            progressColor = a.getColor(R.styleable.CircularProgressIndicator_progressColor, progressColor);
            progressBackgroundColor = a.getColor(R.styleable.CircularProgressIndicator_progressBackgroundColor, progressBackgroundColor);
            progressStrokeWidth = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_progressStrokeWidth, progressStrokeWidth);
            textColor = a.getColor(R.styleable.CircularProgressIndicator_textColor, progressColor);
            textSize = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_textSize, textSize);
            this.shouldDrawDot = a.getBoolean(R.styleable.CircularProgressIndicator_drawDot, true);
            dotColor = a.getColor(R.styleable.CircularProgressIndicator_dotColor, progressColor);
            dotWidth = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_dotWidth, progressStrokeWidth);
            this.startAngle = a.getInt(R.styleable.CircularProgressIndicator_startAngle, 270);
            if (this.startAngle < 0 || this.startAngle > 360) {
                this.startAngle = 270;
            }
            this.isAnimationEnabled = a.getBoolean(R.styleable.CircularProgressIndicator_enableProgressAnimation, true);
            this.direction = a.getInt(R.styleable.CircularProgressIndicator_direction, 1);
            int cap = a.getInt(R.styleable.CircularProgressIndicator_progressCap, 0);
            progressStrokeCap = cap == 0 ? Paint.Cap.ROUND : Paint.Cap.BUTT;
            String formattingPattern = a.getString(R.styleable.CircularProgressIndicator_formattingPattern);
            this.progressTextAdapter = formattingPattern != null ? new PatternProgressTextAdapter(formattingPattern) : new DefaultProgressTextAdapter();
            this.reformatProgressText();
            a.recycle();
        }
        this.progressPaint = new Paint();
        this.progressPaint.setStrokeCap(progressStrokeCap);
        this.progressPaint.setStrokeWidth((float)progressStrokeWidth);
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.progressPaint.setColor(progressColor);
        this.progressPaint.setAntiAlias(true);
        this.progressBackgroundPaint = new Paint();
        this.progressBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.progressBackgroundPaint.setStrokeWidth((float)progressStrokeWidth);
        this.progressBackgroundPaint.setColor(progressBackgroundColor);
        this.progressBackgroundPaint.setAntiAlias(true);
        this.dotPaint = new Paint();
        this.dotPaint.setStrokeCap(Paint.Cap.ROUND);
        this.dotPaint.setStrokeWidth((float)dotWidth);
        this.dotPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.dotPaint.setColor(dotColor);
        this.dotPaint.setAntiAlias(true);
        this.textPaint = new TextPaint();
        this.textPaint.setStrokeCap(Paint.Cap.ROUND);
        this.textPaint.setColor(textColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize((float)textSize);
        this.circleBounds = new RectF();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int finalHeight;
        int finalWidth;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        Rect textBoundsRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textBoundsRect);
        float strokeSizeOffset = this.shouldDrawDot ? Math.max(this.dotPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth()) : this.progressPaint.getStrokeWidth();
        int desiredSize = (int)strokeSizeOffset + this.dp2px(150.0f) + Math.max(paddingBottom + paddingTop, paddingLeft + paddingRight);
        desiredSize = (int)((float)desiredSize + ((float)Math.max(textBoundsRect.width(), textBoundsRect.height()) + (float)desiredSize * 0.1f));
        switch (widthMode) {
            case 0x40000000: {
                finalWidth = measuredWidth;
                break;
            }
            case -2147483648: {
                finalWidth = Math.min(desiredSize, measuredWidth);
                break;
            }
            default: {
                finalWidth = desiredSize;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                finalHeight = measuredHeight;
                break;
            }
            case -2147483648: {
                finalHeight = Math.min(desiredSize, measuredHeight);
                break;
            }
            default: {
                finalHeight = desiredSize;
            }
        }
        int widthWithoutPadding = finalWidth - paddingLeft - paddingRight;
        int heightWithoutPadding = finalHeight - paddingTop - paddingBottom;
        int smallestSide = Math.min(heightWithoutPadding, widthWithoutPadding);
        this.setMeasuredDimension(smallestSide, smallestSide);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.calculateBounds(w, h);
    }

    private void calculateBounds(int w, int h) {
        float halfOffset;
        this.radius = (float)w / 2.0f;
        float strokeSizeOffset = this.shouldDrawDot ? Math.max(this.dotPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth()) : this.progressPaint.getStrokeWidth();
        this.circleBounds.left = halfOffset = strokeSizeOffset / 2.0f;
        this.circleBounds.top = halfOffset;
        this.circleBounds.right = (float)w - halfOffset;
        this.circleBounds.bottom = (float)h - halfOffset;
        this.radius = this.circleBounds.width() / 2.0f;
        this.calculateTextBounds();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        this.drawProgressBackground(canvas);
        this.drawProgress(canvas);
        if (this.shouldDrawDot) {
            this.drawDot(canvas);
        }
        this.drawText(canvas);
    }

    private void drawProgressBackground(Canvas canvas) {
        canvas.drawArc(this.circleBounds, 0.0f, 360.0f, false, this.progressBackgroundPaint);
    }

    private void drawProgress(Canvas canvas) {
        canvas.drawArc(this.circleBounds, (float)this.startAngle, (float)this.sweepAngle, false, this.progressPaint);
    }

    private void drawDot(Canvas canvas) {
        double angleRadians = Math.toRadians(this.startAngle + this.sweepAngle + 180);
        float cos = (float)Math.cos(angleRadians);
        float sin = (float)Math.sin(angleRadians);
        float x = this.circleBounds.centerX() - this.radius * cos;
        float y = this.circleBounds.centerY() - this.radius * sin;
        canvas.drawPoint(x, y, this.dotPaint);
    }

    private void drawText(Canvas canvas) {
        canvas.drawText(this.progressText, this.textX, this.textY, this.textPaint);
    }

    public void setMaxProgress(double maxProgress) {
        this.maxProgressValue = maxProgress;
        if (this.maxProgressValue < this.progressValue) {
            this.setCurrentProgress(maxProgress);
        }
        this.invalidate();
    }

    public void setCurrentProgress(double currentProgress) {
        if (currentProgress > this.maxProgressValue) {
            this.maxProgressValue = currentProgress;
        }
        this.setProgress(currentProgress, this.maxProgressValue);
    }

    public void setProgress(double current, double max) {
        double finalAngle = this.direction == 1 ? -(current / max * 360.0) : current / max * 360.0;
        double oldCurrentProgress = this.progressValue;
        this.maxProgressValue = max;
        this.progressValue = Math.min(current, max);
        if (this.onProgressChangeListener != null) {
            this.onProgressChangeListener.onProgressChanged(this.progressValue, this.maxProgressValue);
        }
        this.reformatProgressText();
        this.calculateTextBounds();
        this.stopProgressAnimation();
        if (this.isAnimationEnabled) {
            this.startProgressAnimation(oldCurrentProgress, finalAngle);
        } else {
            this.sweepAngle = (int)finalAngle;
            this.invalidate();
        }
    }

    private void startProgressAnimation(double oldCurrentProgress, final double finalAngle) {
        PropertyValuesHolder angleProperty = PropertyValuesHolder.ofInt((String)PROPERTY_ANGLE, (int[])new int[]{this.sweepAngle, (int)finalAngle});
        this.progressAnimator = ValueAnimator.ofObject((TypeEvaluator)new TypeEvaluator<Double>(){

            public Double evaluate(float fraction, Double startValue, Double endValue) {
                return startValue + (endValue - startValue) * (double)fraction;
            }
        }, (Object[])new Object[]{oldCurrentProgress, this.progressValue});
        this.progressAnimator.setDuration(1000L);
        this.progressAnimator.setValues(new PropertyValuesHolder[]{angleProperty});
        this.progressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressIndicator.this.sweepAngle = (Integer)animation.getAnimatedValue(CircularProgressIndicator.PROPERTY_ANGLE);
                CircularProgressIndicator.this.invalidate();
            }
        });
        this.progressAnimator.addListener((Animator.AnimatorListener)new DefaultAnimatorListener(){

            @Override
            public void onAnimationCancel(Animator animation) {
                CircularProgressIndicator.this.sweepAngle = (int)finalAngle;
                CircularProgressIndicator.this.invalidate();
                CircularProgressIndicator.this.progressAnimator = null;
            }
        });
        this.progressAnimator.start();
    }

    private void stopProgressAnimation() {
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
        }
    }

    private void reformatProgressText() {
        this.progressText = this.progressTextAdapter.formatText(this.progressValue);
    }

    private Rect calculateTextBounds() {
        Rect textRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textRect);
        this.textX = this.circleBounds.centerX() - (float)textRect.width() / 2.0f;
        this.textY = this.circleBounds.centerY() + (float)textRect.height() / 2.0f;
        return textRect;
    }

    private int dp2px(float dp) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }

    private int sp2px(float sp) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    private void invalidateEverything() {
        this.calculateBounds(this.getWidth(), this.getHeight());
        this.requestLayout();
        this.invalidate();
    }

    public void setProgressColor(@ColorInt int color) {
        this.progressPaint.setColor(color);
        this.invalidate();
    }

    public void setProgressBackgroundColor(@ColorInt int color) {
        this.progressBackgroundPaint.setColor(color);
        this.invalidate();
    }

    public void setProgressStrokeWidthDp(@Dimension int strokeWidth) {
        this.setProgressStrokeWidthPx(this.dp2px(strokeWidth));
    }

    public void setProgressStrokeWidthPx(@Dimension int strokeWidth) {
        this.progressPaint.setStrokeWidth((float)strokeWidth);
        this.progressBackgroundPaint.setStrokeWidth((float)strokeWidth);
        this.invalidateEverything();
    }

    public void setTextColor(@ColorInt int color) {
        this.textPaint.setColor(color);
        Rect textRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textRect);
        this.invalidate(textRect);
    }

    public void setTextSizeSp(@Dimension int size) {
        this.setTextSizePx(this.sp2px(size));
    }

    public void setTextSizePx(@Dimension int size) {
        float currentSize = this.textPaint.getTextSize();
        float factor = this.textPaint.measureText(this.progressText) / currentSize;
        float offset = this.shouldDrawDot ? Math.max(this.dotPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth()) : this.progressPaint.getStrokeWidth();
        float maximumAvailableTextWidth = this.circleBounds.width() - offset;
        if ((float)size * factor >= maximumAvailableTextWidth) {
            size = (int)(maximumAvailableTextWidth / factor);
        }
        this.textPaint.setTextSize((float)size);
        Rect textBounds = this.calculateTextBounds();
        this.invalidate(textBounds);
    }

    public void setShouldDrawDot(boolean shouldDrawDot) {
        this.shouldDrawDot = shouldDrawDot;
        if (this.dotPaint.getStrokeWidth() > this.progressPaint.getStrokeWidth()) {
            this.requestLayout();
            return;
        }
        this.invalidate();
    }

    public void setDotColor(@ColorInt int color) {
        this.dotPaint.setColor(color);
        this.invalidate();
    }

    public void setDotWidthDp(@Dimension int width) {
        this.setDotWidthPx(this.dp2px(width));
    }

    public void setDotWidthPx(@Dimension int width) {
        this.dotPaint.setStrokeWidth((float)width);
        this.invalidateEverything();
    }

    public void setProgressTextAdapter(@Nullable ProgressTextAdapter progressTextAdapter) {
        this.progressTextAdapter = progressTextAdapter != null ? progressTextAdapter : new DefaultProgressTextAdapter();
        this.reformatProgressText();
        this.invalidateEverything();
    }

    @NonNull
    public ProgressTextAdapter getProgressTextAdapter() {
        return this.progressTextAdapter;
    }

    @ColorInt
    public int getProgressColor() {
        return this.progressPaint.getColor();
    }

    @ColorInt
    public int getProgressBackgroundColor() {
        return this.progressBackgroundPaint.getColor();
    }

    public float getProgressStrokeWidth() {
        return this.progressPaint.getStrokeWidth();
    }

    @ColorInt
    public int getTextColor() {
        return this.textPaint.getColor();
    }

    public float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public boolean isDotEnabled() {
        return this.shouldDrawDot;
    }

    @ColorInt
    public int getDotColor() {
        return this.dotPaint.getColor();
    }

    public float getDotWidth() {
        return this.dotPaint.getStrokeWidth();
    }

    public double getProgress() {
        return this.progressValue;
    }

    public double getMaxProgress() {
        return this.maxProgressValue;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(@IntRange(from=0L, to=360L) int startAngle) {
        this.startAngle = startAngle;
        this.invalidate();
    }

    @Direction
    public int getDirection() {
        return this.direction;
    }

    public void setDirection(@Direction int direction) {
        this.direction = direction;
        this.invalidate();
    }

    @Cap
    public int getProgressStrokeCap() {
        return this.progressPaint.getStrokeCap() == Paint.Cap.ROUND ? 0 : 1;
    }

    public void setProgressStrokeCap(@Cap int cap) {
        Paint.Cap paintCap;
        Paint.Cap cap2 = paintCap = cap == 0 ? Paint.Cap.ROUND : Paint.Cap.BUTT;
        if (this.progressPaint.getStrokeCap() != paintCap) {
            this.progressPaint.setStrokeCap(paintCap);
            this.invalidate();
        }
    }

    public void setOnProgressChangeListener(@Nullable OnProgressChangeListener onProgressChangeListener) {
        this.onProgressChangeListener = onProgressChangeListener;
    }

    @Nullable
    public OnProgressChangeListener getOnProgressChangeListener() {
        return this.onProgressChangeListener;
    }

    public void setAnimationEnabled(boolean enableAnimation) {
        this.isAnimationEnabled = enableAnimation;
        if (!enableAnimation) {
            this.stopProgressAnimation();
        }
    }

    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public static interface OnProgressChangeListener {
        public void onProgressChanged(double var1, double var3);
    }

    public static interface ProgressTextAdapter {
        @NonNull
        public String formatText(double var1);
    }

    public static @interface Cap {
    }

    public static @interface Direction {
    }
}

