/*
 * Decompiled with CFR 0.152.
 */
package antonkozyriatskyi.circularprogressindicator;

import android.animation.Animator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import antonkozyriatskyi.circularprogressindicator.DefaultAnimatorListener;
import antonkozyriatskyi.circularprogressindicator.R;

public class CircularProgressIndicator
extends View {
    private static int ANGLE_START_PROGRESS = 270;
    private static int ANGLE_START_PROGRESS_BACKGROUND = 0;
    private static int ANGLE_END_PROGRESS_BACKGROUND = 360;
    private static int DESIRED_WIDTH_DP = 150;
    private static String DEFAULT_PROGRESS_COLOR = "#3F51B5";
    private static int DEFAULT_TEXT_SIZE_SP = 24;
    private static int DEFAULT_STROKE_WIDTH_DP = 8;
    private static String DEFAULT_PROGRESS_BACKGROUND_COLOR = "#e0e0e0";
    private static int DEFAULT_ANIMATION_DURATION = 1000;
    private static String DEFAULT_PROGRESS_TEXT_DELIMITER = ",";
    private static String PROPERTY_ANGLE = "angle";
    private static String PROPERTY_PROGRESS_TEXT = "progress_text";
    private Paint progressPaint;
    private Paint progressBackgroundPaint;
    private Paint dotPaint;
    private Paint textPaint;
    private int sweepAngle = 0;
    private RectF circleBounds;
    private String progressText = "0";
    private String progressTextDelimiter;
    private float textX;
    private float textY;
    private float radius;
    private float drawingCenterX;
    private float drawingCenterY;
    private boolean shouldDrawDot = true;
    private boolean shouldUseDelimiter = true;
    private int maxProgressValue = 100;
    private int progressValue = 0;
    private ValueAnimator progressAnimator;

    public CircularProgressIndicator(Context context) {
        super(context);
        this.init(context, null);
    }

    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CircularProgressIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        int progressColor = Color.parseColor((String)DEFAULT_PROGRESS_COLOR);
        int progressBackgroundColor = Color.parseColor((String)DEFAULT_PROGRESS_BACKGROUND_COLOR);
        int progressStrokeWidth = this.dp2px(DEFAULT_STROKE_WIDTH_DP);
        int textColor = progressColor;
        int textSize = this.sp2px(DEFAULT_TEXT_SIZE_SP);
        this.shouldDrawDot = true;
        int dotColor = progressColor;
        int dotWidth = progressStrokeWidth;
        this.shouldUseDelimiter = true;
        this.progressTextDelimiter = DEFAULT_PROGRESS_TEXT_DELIMITER;
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularProgressIndicator);
            progressColor = a.getColor(R.styleable.CircularProgressIndicator_progressColor, progressColor);
            progressBackgroundColor = a.getColor(R.styleable.CircularProgressIndicator_progressBackgroundColor, progressBackgroundColor);
            progressStrokeWidth = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_progressStrokeWidth, progressStrokeWidth);
            textColor = a.getColor(R.styleable.CircularProgressIndicator_textColor, progressColor);
            textSize = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_textSize, textSize);
            this.shouldDrawDot = a.getBoolean(R.styleable.CircularProgressIndicator_drawDot, this.shouldDrawDot);
            dotColor = a.getColor(R.styleable.CircularProgressIndicator_dotColor, progressColor);
            dotWidth = a.getDimensionPixelSize(R.styleable.CircularProgressIndicator_dotWidth, progressStrokeWidth);
            this.shouldUseDelimiter = a.getBoolean(R.styleable.CircularProgressIndicator_useProgressTextDelimiter, this.shouldUseDelimiter);
            this.progressTextDelimiter = a.getNonResourceString(R.styleable.CircularProgressIndicator_progressTextDelimiter);
            if (this.progressTextDelimiter == null) {
                this.progressTextDelimiter = DEFAULT_PROGRESS_TEXT_DELIMITER;
            }
            a.recycle();
        }
        this.progressPaint = new Paint();
        this.progressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.progressPaint.setStrokeWidth((float)progressStrokeWidth);
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.progressPaint.setColor(progressColor);
        this.progressPaint.setAntiAlias(true);
        this.progressBackgroundPaint = new Paint();
        this.progressBackgroundPaint.setStyle(Paint.Style.STROKE);
        this.progressBackgroundPaint.setStrokeWidth((float)progressStrokeWidth);
        this.progressBackgroundPaint.setColor(progressBackgroundColor);
        this.progressBackgroundPaint.setAntiAlias(true);
        this.dotPaint = new Paint();
        this.dotPaint.setStrokeCap(Paint.Cap.ROUND);
        this.dotPaint.setStrokeWidth((float)dotWidth);
        this.dotPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.dotPaint.setColor(dotColor);
        this.dotPaint.setAntiAlias(true);
        this.textPaint = new TextPaint();
        this.textPaint.setStrokeCap(Paint.Cap.ROUND);
        this.textPaint.setColor(textColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize((float)textSize);
        this.circleBounds = new RectF();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int finalHeight;
        int finalWidth;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        Rect textRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textRect);
        float strokeOffset = this.shouldDrawDot ? Math.max(this.dotPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth()) : this.progressPaint.getStrokeWidth();
        int desiredSize = (int)strokeOffset + this.dp2px(DESIRED_WIDTH_DP) + Math.max(paddingBottom + paddingTop, paddingLeft + paddingRight);
        desiredSize = (int)((float)desiredSize + ((float)Math.max(textRect.width(), textRect.height()) + (float)desiredSize * 0.1f));
        switch (widthMode) {
            case 0x40000000: {
                finalWidth = measuredWidth;
                break;
            }
            case -2147483648: {
                finalWidth = Math.min(desiredSize, measuredWidth);
                break;
            }
            default: {
                finalWidth = desiredSize;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                finalHeight = measuredHeight;
                break;
            }
            case -2147483648: {
                finalHeight = Math.min(desiredSize, measuredHeight);
                break;
            }
            default: {
                finalHeight = desiredSize;
            }
        }
        int widthWithoutPadding = finalWidth - paddingLeft - paddingRight;
        int heightWithoutPadding = finalHeight - paddingTop - paddingBottom;
        int circleDiameter = Math.min(heightWithoutPadding, widthWithoutPadding);
        this.radius = circleDiameter / 2;
        this.drawingCenterX = (float)paddingLeft + (float)widthWithoutPadding / 2.0f;
        this.drawingCenterY = (float)paddingTop + (float)heightWithoutPadding / 2.0f;
        float halfOffset = strokeOffset / 2.0f;
        this.circleBounds.left = this.drawingCenterX - this.radius + halfOffset;
        this.circleBounds.top = this.drawingCenterY - this.radius + halfOffset;
        this.circleBounds.right = this.drawingCenterX + this.radius - halfOffset;
        this.circleBounds.bottom = this.drawingCenterY + this.radius - halfOffset;
        this.radius = this.circleBounds.width() / 2.0f;
        this.calculateTextBounds();
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        this.drawProgressBackground(canvas);
        this.drawProgress(canvas);
        if (this.shouldDrawDot) {
            this.drawPoint(canvas);
        }
        this.drawText(canvas);
    }

    private void drawProgressBackground(Canvas canvas) {
        canvas.drawArc(this.circleBounds, (float)ANGLE_START_PROGRESS_BACKGROUND, (float)ANGLE_END_PROGRESS_BACKGROUND, false, this.progressBackgroundPaint);
    }

    private void drawProgress(Canvas canvas) {
        canvas.drawArc(this.circleBounds, (float)ANGLE_START_PROGRESS, (float)this.sweepAngle, false, this.progressPaint);
    }

    private void drawPoint(Canvas canvas) {
        double angleRadians = Math.toRadians(-this.sweepAngle);
        float cos = (float)Math.cos(angleRadians);
        float sin = (float)Math.sin(angleRadians);
        float x = this.circleBounds.centerX() - this.radius * sin;
        float y = this.circleBounds.centerY() - this.radius * cos;
        canvas.drawPoint(x, y, this.dotPaint);
    }

    private void drawText(Canvas canvas) {
        canvas.drawText(this.progressText, this.textX, this.textY, this.textPaint);
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgressValue = maxProgress;
        if (this.maxProgressValue < this.progressValue) {
            this.setCurrentProgress(maxProgress);
        }
        this.invalidate();
    }

    public void setCurrentProgress(int progress) {
        if (progress > this.maxProgressValue) {
            this.maxProgressValue = progress;
        }
        this.setProgress(progress, this.maxProgressValue);
    }

    public void setProgress(int current, int max) {
        final float finalAngle = (float)current / (float)max * 360.0f;
        PropertyValuesHolder progressText = PropertyValuesHolder.ofInt((String)PROPERTY_PROGRESS_TEXT, (int[])new int[]{this.progressValue, current});
        PropertyValuesHolder angle = PropertyValuesHolder.ofInt((String)PROPERTY_ANGLE, (int[])new int[]{-this.sweepAngle, (int)finalAngle});
        this.progressText = this.formatProgressText(current);
        this.maxProgressValue = max;
        this.progressValue = current;
        this.calculateTextBounds();
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
        }
        this.progressAnimator = ValueAnimator.ofInt((int[])new int[]{this.progressValue, current});
        this.progressAnimator.setDuration((long)DEFAULT_ANIMATION_DURATION);
        this.progressAnimator.setValues(new PropertyValuesHolder[]{progressText, angle});
        this.progressAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressIndicator.this.sweepAngle = -((Integer)animation.getAnimatedValue(PROPERTY_ANGLE)).intValue();
                CircularProgressIndicator.this.invalidate();
            }
        });
        this.progressAnimator.addListener((Animator.AnimatorListener)new DefaultAnimatorListener(){

            @Override
            public void onAnimationCancel(Animator animation) {
                CircularProgressIndicator.this.sweepAngle = (int)(-finalAngle);
                CircularProgressIndicator.this.progressAnimator = null;
            }
        });
        this.progressAnimator.start();
    }

    private String formatProgressText(int currentProgress) {
        if (!this.shouldUseDelimiter) {
            return String.valueOf(currentProgress);
        }
        char[] chars = String.valueOf(Math.abs(currentProgress)).toCharArray();
        char[] charsReversed = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            charsReversed[i] = chars[chars.length - 1 - i];
        }
        StringBuilder sb = new StringBuilder();
        sb.append(charsReversed[0]);
        for (int i = 1; i < charsReversed.length; ++i) {
            if (i % 3 == 0) {
                sb.append(this.progressTextDelimiter);
            }
            sb.append(charsReversed[i]);
        }
        if (currentProgress < 0) {
            sb.append("-");
        }
        String progress = sb.reverse().toString();
        return progress;
    }

    private Rect calculateTextBounds() {
        Rect textRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textRect);
        this.textX = this.circleBounds.centerX() - (float)textRect.width() / 2.0f;
        this.textY = this.circleBounds.centerY() + (float)textRect.height() / 2.0f;
        return textRect;
    }

    private int dp2px(float dp) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }

    private int sp2px(float dp) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)2, (float)dp, (DisplayMetrics)metrics);
    }

    public void setProgressColor(@ColorInt int color) {
        this.progressPaint.setColor(color);
        this.invalidate();
    }

    public void setProgressBackgroundColor(@ColorInt int color) {
        this.progressBackgroundPaint.setColor(color);
        this.invalidate();
    }

    public void setProgressStrokeWidthDp(@Dimension int strokeWidth) {
        this.setProgressStrokeWidthPx(this.dp2px(strokeWidth));
    }

    public void setProgressStrokeWidthPx(@Dimension int strokeWidth) {
        this.progressPaint.setStrokeWidth((float)strokeWidth);
        this.progressBackgroundPaint.setStrokeWidth((float)strokeWidth);
        this.requestLayout();
        this.invalidate();
    }

    public void setTextColor(@ColorInt int color) {
        this.textPaint.setColor(color);
        Rect textRect = new Rect();
        this.textPaint.getTextBounds(this.progressText, 0, this.progressText.length(), textRect);
        this.invalidate(textRect);
    }

    public void setTextSizeSp(@Dimension int size) {
        this.setTextSizePx(this.sp2px(size));
    }

    public void setTextSizePx(@Dimension int size) {
        float currentSize = this.textPaint.getTextSize();
        float factor = this.textPaint.measureText(this.progressText) / currentSize;
        float offset = this.shouldDrawDot ? Math.max(this.dotPaint.getStrokeWidth(), this.progressPaint.getStrokeWidth()) : this.progressPaint.getStrokeWidth();
        float maximumAvailableTextWidth = this.circleBounds.width() - offset;
        if ((float)size * factor >= maximumAvailableTextWidth) {
            size = (int)(maximumAvailableTextWidth / factor);
        }
        this.textPaint.setTextSize((float)size);
        Rect textBounds = this.calculateTextBounds();
        this.invalidate(textBounds);
    }

    public void setShouldDrawDot(boolean shouldDrawDot) {
        this.shouldDrawDot = shouldDrawDot;
        if (this.dotPaint.getStrokeWidth() > this.progressPaint.getStrokeWidth()) {
            this.requestLayout();
            return;
        }
        this.invalidate();
    }

    public void setDotColor(@ColorInt int color) {
        this.dotPaint.setColor(color);
        this.invalidate();
    }

    public void setDotWidthDp(@Dimension int width) {
        this.setDotWidthPx(this.dp2px(width));
    }

    public void setDotWidthPx(@Dimension int width) {
        this.dotPaint.setStrokeWidth((float)width);
        this.requestLayout();
        this.invalidate();
    }

    public void setShouldUseDelimiter(boolean shouldUseDelimiter) {
        this.shouldUseDelimiter = shouldUseDelimiter;
        if (!shouldUseDelimiter) {
            this.progressTextDelimiter = null;
        }
        this.calculateTextBounds();
        this.requestLayout();
        this.invalidate();
    }

    public void setProgressTextDelimiter(@Nullable String delimiter) {
        this.progressTextDelimiter = delimiter;
        this.progressText = this.formatProgressText(this.progressValue);
        Rect textBounds = this.calculateTextBounds();
        this.invalidate(textBounds);
    }

    @ColorInt
    public int getProgressColor() {
        return this.progressPaint.getColor();
    }

    @ColorInt
    public int getProgressBackgroundColor() {
        return this.progressBackgroundPaint.getColor();
    }

    public float getProgressStrokeWidth() {
        return this.progressPaint.getStrokeWidth();
    }

    @ColorInt
    public int getTextColor() {
        return this.textPaint.getColor();
    }

    public float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public boolean isTextDelimiterEnabled() {
        return this.shouldUseDelimiter;
    }

    public String getProgressTextDelimiter() {
        return this.progressTextDelimiter;
    }

    public boolean isDotEnabled() {
        return this.shouldDrawDot;
    }

    @ColorInt
    public int getDotColor() {
        return this.dotPaint.getColor();
    }

    public float getDotWidth() {
        return this.dotPaint.getStrokeWidth();
    }

    public int getProgress() {
        return this.progressValue;
    }

    public int getMaxProgress() {
        return this.maxProgressValue;
    }
}

