/*
 * Decompiled with CFR 0.152.
 */
package com.anthonynsimon.url;

import com.anthonynsimon.url.URLPart;
import com.anthonynsimon.url.exceptions.InvalidHexException;
import com.anthonynsimon.url.exceptions.MalformedURLException;
import java.nio.charset.StandardCharsets;

final class PercentEncoder {
    private static final char[] reservedChars = new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', ':', '[', ']', '<', '>', '\"'};
    private static final char[] unreservedChars = new char[]{'-', '_', '.', '~'};
    private static final short[] utf8Masks = new short[]{0, 192, 224, 240};
    private static final String hexSet = "0123456789ABCDEF";

    private PercentEncoder() {
    }

    private static boolean shouldEscapeChar(char c, URLPart zone) {
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') {
            return false;
        }
        if (zone == URLPart.HOST || zone == URLPart.PATH) {
            if (c == '%') {
                return true;
            }
            for (char reserved : reservedChars) {
                if (reserved != c) continue;
                return false;
            }
        }
        for (char unreserved : unreservedChars) {
            if (unreserved != c) continue;
            return false;
        }
        for (char reserved : new char[]{'$', '&', '+', ',', '/', ':', ';', '=', '?', '@'}) {
            if (reserved != c) continue;
            switch (zone) {
                case PATH: {
                    return c == '?';
                }
                case CREDENTIALS: {
                    return c == '@' || c == '/' || c == '?' || c == ':';
                }
                case QUERY: {
                    return true;
                }
                case FRAGMENT: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private static boolean needsEscaping(String str, URLPart zone) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (!PercentEncoder.shouldEscapeChar(c, zone)) continue;
            return true;
        }
        return false;
    }

    private static boolean needsUnescaping(String str) {
        return str.indexOf(37) >= 0;
    }

    public static String encode(String str, URLPart zone) {
        if (!PercentEncoder.needsEscaping(str, zone)) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        int i = 0;
        String result = "";
        while (i < bytes.length) {
            int readBytes = 0;
            for (short mask : utf8Masks) {
                if ((bytes[i] & mask) != mask) break;
                ++readBytes;
            }
            for (int j = 0; j < readBytes; ++j) {
                char c = (char)bytes[i];
                result = PercentEncoder.shouldEscapeChar(c, zone) ? result + "%" + hexSet.charAt((bytes[i] & 0xFF) >> 4) + hexSet.charAt(bytes[i] & 0xFF & 0xF) : result + c;
                ++i;
            }
        }
        return result;
    }

    public static String decode(String str) throws MalformedURLException {
        if (!PercentEncoder.needsUnescaping(str)) {
            return str;
        }
        char[] chars = str.toCharArray();
        String result = "";
        int len = str.length();
        int i = 0;
        while (i < chars.length) {
            byte code;
            char c = chars[i];
            if (c != '%') {
                result = result + c;
                ++i;
                continue;
            }
            if (i + 2 >= len) {
                throw new MalformedURLException("invalid escape sequence");
            }
            try {
                code = PercentEncoder.unhex(str.substring(i + 1, i + 3).toCharArray());
            }
            catch (InvalidHexException e) {
                throw new MalformedURLException(e.getMessage());
            }
            int readBytes = 0;
            for (short mask : utf8Masks) {
                if ((code & mask) != mask) break;
                ++readBytes;
            }
            byte[] buffer = new byte[readBytes];
            for (int j = 0; j < readBytes; ++j) {
                if (str.charAt(i) != '%') {
                    byte[] currentBuffer = new byte[j];
                    for (int h = 0; h < j; ++h) {
                        currentBuffer[h] = buffer[h];
                    }
                    buffer = currentBuffer;
                    break;
                }
                if (i + 3 > len) {
                    buffer = "\ufffd".getBytes();
                    break;
                }
                try {
                    buffer[j] = PercentEncoder.unhex(str.substring(i + 1, i + 3).toCharArray());
                }
                catch (InvalidHexException e) {
                    throw new MalformedURLException(e.getMessage());
                }
                i += 3;
            }
            result = result + new String(buffer);
        }
        return result;
    }

    private static byte unhex(char[] hex) throws InvalidHexException {
        int result = 0;
        for (int i = 0; i < hex.length; ++i) {
            char c = hex[hex.length - i - 1];
            int index = -1;
            if ('0' <= c && c <= '9') {
                index = c - 48;
            } else if ('a' <= c && c <= 'f') {
                index = c - 97 + 10;
            } else if ('A' <= c && c <= 'F') {
                index = c - 65 + 10;
            }
            if (index < 0 || index >= 16) {
                throw new InvalidHexException("not a valid hex char: " + c);
            }
            result += index * PercentEncoder.pow(16, i);
        }
        return (byte)result;
    }

    private static int pow(int base, int exp) {
        int result = 1;
        for (int expRemaining = exp; expRemaining > 0; --expRemaining) {
            result *= base;
        }
        return result;
    }
}

