/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.github.ansell.csv.stream.CSVStream;
import com.github.ansell.csv.sum.CSVSummariser;
import com.github.ansell.shp.SHPUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.io.output.NullWriter;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.jooq.lambda.Unchecked;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class SHPDump {
    public static void main(String ... args) throws Exception {
        Path outputMappingPath;
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec input = parser.accepts("input").withRequiredArg().ofType(File.class).required().describedAs("The input SHP file");
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class).required().describedAs("The output directory to use for debugging files");
        ArgumentAcceptingOptionSpec outputPrefix = parser.accepts("prefix").withRequiredArg().ofType(String.class).defaultsTo((Object)"shp-debug", (Object[])new String[0]).describedAs("The output prefix to use for debugging files");
        ArgumentAcceptingOptionSpec outputMappingTemplate = parser.accepts("output-mapping").withRequiredArg().ofType(File.class).describedAs("The output mapping template file if it needs to be generated.");
        ArgumentAcceptingOptionSpec resolution = parser.accepts("resolution").withRequiredArg().ofType(Integer.class).defaultsTo((Object)2048, (Object[])new Integer[0]).describedAs("The output image file resolution");
        ArgumentAcceptingOptionSpec format = parser.accepts("format").withRequiredArg().ofType(String.class).defaultsTo((Object)"png", (Object[])new String[0]).describedAs("The output image format");
        ArgumentAcceptingOptionSpec removeIfEmpty = parser.accepts("remove-if-empty").withRequiredArg().ofType(String.class).describedAs("The name of an attribute to remove if its value is empty before outputting the resulting shapefile. Use multiple times to specify multiple fields to check");
        ArgumentAcceptingOptionSpec samplesToShow = parser.accepts("samples").withRequiredArg().ofType(Integer.class).defaultsTo((Object)20, (Object[])new Integer[0]).describedAs("The maximum number of sample values for each field to include in the output, or -1 to dump all sample values for each field.");
        ArgumentAcceptingOptionSpec showSampleCounts = parser.accepts("show-sample-counts").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.FALSE, (Object[])new Boolean[0]).describedAs("Set to true to add counts for each of the samples shown after the sample display value.");
        ArgumentAcceptingOptionSpec overrideShapefileChecks = parser.accepts("override-shapefile-checks").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.FALSE, (Object[])new Boolean[0]).describedAs("Set to true to make the shapefile field name length and field count checks non-fatal.");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e2) {
            System.out.println(e2.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e2;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path inputPath = ((File)input.value(options)).toPath();
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find input SHP file: " + inputPath.toString());
        }
        Path outputPath = ((File)output.value(options)).toPath();
        if (!Files.exists(outputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Output directory does not exist: " + outputPath.toString());
        }
        Path path = outputMappingPath = options.has((OptionSpec)outputMappingTemplate) ? ((File)outputMappingTemplate.value(options)).toPath() : null;
        if (options.has((OptionSpec)outputMappingTemplate) && Files.exists(outputMappingPath, new LinkOption[0])) {
            throw new FileNotFoundException("Output mapping template file already exists: " + outputMappingPath.toString());
        }
        ConcurrentHashMap.KeySetView filterFields = ConcurrentHashMap.newKeySet();
        if (options.has((OptionSpec)removeIfEmpty)) {
            for (String nextFilterField : removeIfEmpty.values(options)) {
                System.out.println("Will filter field if empty value found: " + nextFilterField);
                filterFields.add(nextFilterField);
            }
        }
        if (!filterFields.isEmpty()) {
            System.out.println("Full set of filter fields: " + filterFields);
        }
        String prefix = (String)outputPrefix.value(options);
        boolean showSampleCountsBoolean = (Boolean)showSampleCounts.value(options);
        boolean overrideShapefileChecksBoolean = (Boolean)overrideShapefileChecks.value(options);
        int samplesToShowInt = (Integer)samplesToShow.value(options);
        FileDataStore store = FileDataStoreFinder.getDataStore((File)inputPath.toFile());
        if (store == null) {
            throw new RuntimeException("Could not read the given input as an ESRI Shapefile: " + inputPath.toAbsolutePath().toString());
        }
        for (String typeName : new LinkedHashSet<String>(Arrays.asList(store.getTypeNames()))) {
            Serializable nextLine2;
            Throwable throwable;
            Throwable throwable2;
            String message;
            System.out.println("");
            System.out.println("Type: " + typeName);
            SimpleFeatureSource featureSource = store.getFeatureSource(typeName);
            SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
            NameImpl outputSchemaName = new NameImpl(schema.getName().getNamespaceURI(), schema.getName().getLocalPart().replace(" ", "").replace("%20", ""));
            System.out.println("Replacing name on schema: " + schema.getName() + " with " + outputSchemaName);
            SimpleFeatureTypeImpl outputSchema = SHPUtils.changeSchemaName(schema, (Name)outputSchemaName);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                System.out.println("Attribute: " + attribute.getName().toString());
                attributeList.add(attribute.getName().toString());
            }
            List longFieldsList = attributeList.stream().filter(nextAtt -> nextAtt.length() > 10).collect(Collectors.toList());
            if (!longFieldsList.isEmpty()) {
                message = "Shapefile contained field names longer than 10 characters, and is hence invalid: " + longFieldsList.toString();
                if (overrideShapefileChecksBoolean) {
                    System.err.println(message);
                } else {
                    throw new RuntimeException(message);
                }
            }
            if (attributeList.size() > 255) {
                message = "Shapefile contained more than 255 fields and hence is invalid and possibly corrupted: " + attributeList.size();
                if (overrideShapefileChecksBoolean) {
                    System.err.println(message);
                } else {
                    throw new RuntimeException(message);
                }
            }
            CsvSchema csvSchema = CSVStream.buildSchema(attributeList);
            SimpleFeatureCollection collection = featureSource.getFeatures();
            int featureCount = 0;
            Path nextCSVFile = outputPath.resolve(prefix + ".csv");
            Path nextSummaryCSVFile = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-Summary.csv");
            CopyOnWriteArrayList<SimpleFeature> outputFeatureList = new CopyOnWriteArrayList<SimpleFeature>();
            try (SimpleFeatureIterator iterator = collection.features();){
                throwable2 = null;
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(nextCSVFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                    throwable = null;
                    try (SequenceWriter csv = CSVStream.newCSVWriter((Writer)bufferedWriter, (CsvSchema)csvSchema);){
                        nextLine2 = new ArrayList<String>();
                        while (iterator.hasNext()) {
                            SimpleFeature feature = (SimpleFeature)iterator.next();
                            if (++featureCount <= 2) {
                                System.out.println("");
                                System.out.println(feature.getIdentifier());
                            } else if (featureCount % 100 == 0) {
                                System.out.print(".");
                            }
                            boolean filterThisFeature = false;
                            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                                String featureString = Optional.ofNullable(feature.getAttribute(attribute.getName())).orElse("").toString();
                                nextLine2.add(featureString);
                                if (filterFields.contains(attribute.getName().toString()) && featureString.trim().isEmpty()) {
                                    filterThisFeature = true;
                                }
                                if (featureString.length() > 100) {
                                    featureString = featureString.substring(0, 100) + "...";
                                }
                                if (featureCount > 2) continue;
                                System.out.print(attribute.getName() + "=");
                                System.out.println(featureString);
                            }
                            if (!filterThisFeature) {
                                outputFeatureList.add(SHPUtils.changeSchemaName(feature, (SimpleFeatureType)outputSchema));
                                csv.write(nextLine2);
                            }
                            nextLine2.clear();
                        }
                    }
                    catch (Throwable nextLine2) {
                        throwable = nextLine2;
                        throw nextLine2;
                    }
                }
                catch (Throwable csv) {
                    throwable2 = csv;
                    throw csv;
                }
            }
            var38_40 = null;
            try (BufferedReader csvReader = Files.newBufferedReader(nextCSVFile, StandardCharsets.UTF_8);){
                throwable2 = null;
                try (BufferedWriter summaryOutput = Files.newBufferedWriter(nextSummaryCSVFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                    throwable = null;
                    try (NullWriter mappingWriter = options.has((OptionSpec)outputMappingTemplate) ? Files.newBufferedWriter(outputMappingPath, StandardCharsets.UTF_8, new OpenOption[0]) : NullWriter.NULL_WRITER;){
                        CSVSummariser.runSummarise((Reader)csvReader, (Writer)summaryOutput, (Writer)mappingWriter, (int)samplesToShowInt, (boolean)showSampleCountsBoolean, (boolean)false, null, (int)1);
                    }
                    catch (Throwable nextLine2) {
                        throwable = nextLine2;
                        throw nextLine2;
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable summaryOutput) {
                var38_40 = summaryOutput;
                throw summaryOutput;
            }
            if (featureCount > 100) {
                System.out.println("");
            }
            System.out.println("");
            System.out.println("Feature count: " + featureCount);
            ListFeatureCollection outputCollection = new ListFeatureCollection((SimpleFeatureType)outputSchema, outputFeatureList);
            Path outputShapefilePath = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-dump");
            if (!Files.exists(outputShapefilePath, new LinkOption[0])) {
                Files.createDirectory(outputShapefilePath, new FileAttribute[0]);
            }
            SHPUtils.writeShapefile((SimpleFeatureCollection)outputCollection, outputShapefilePath);
            Path outputShapefileZipPath = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-dump.zip");
            try (OutputStream out = Files.newOutputStream(outputShapefileZipPath, StandardOpenOption.CREATE_NEW);){
                ZipOutputStream zip = new ZipOutputStream(out, StandardCharsets.UTF_8);
                nextLine2 = null;
                try {
                    Files.list(outputShapefilePath).forEachOrdered(Unchecked.consumer(e -> {
                        zip.putNextEntry(new ZipEntry(e.getFileName().toString()));
                        Files.copy(e, zip);
                        zip.closeEntry();
                    }));
                }
                catch (Throwable feature) {
                    nextLine2 = feature;
                    throw feature;
                }
                finally {
                    if (zip != null) {
                        if (nextLine2 != null) {
                            try {
                                zip.close();
                            }
                            catch (Throwable feature) {
                                ((Throwable)nextLine2).addSuppressed(feature);
                            }
                        } else {
                            zip.close();
                        }
                    }
                }
            }
            OutputStream outputStream = Files.newOutputStream(outputPath.resolve(prefix + "." + (String)format.value(options)), StandardOpenOption.CREATE_NEW);
            var41_47 = null;
            try {
                MapContent map = new MapContent();
                map.setTitle(prefix + "-" + outputSchema.getTypeName());
                Style style = SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
                FeatureLayer layer = new FeatureLayer((FeatureSource)new CollectionFeatureSource((SimpleFeatureCollection)outputCollection), style);
                map.addLayer((Layer)layer);
                SHPUtils.renderImage(map, outputStream, (Integer)resolution.value(options), (String)format.value(options));
            }
            catch (Throwable throwable4) {
                var41_47 = throwable4;
                throw throwable4;
            }
            finally {
                if (outputStream == null) continue;
                if (var41_47 != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable5) {
                        var41_47.addSuppressed(throwable5);
                    }
                    continue;
                }
                outputStream.close();
            }
        }
    }
}

