/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.lands.api.integration;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.angeschossen.lands.api.exceptions.FlagConflictException;
import me.angeschossen.lands.api.flags.Flag;
import me.angeschossen.lands.api.flags.FlagRegistry;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.Land;
import me.angeschossen.lands.api.land.LandArea;
import me.angeschossen.lands.api.land.LandWorld;
import me.angeschossen.lands.api.land.enums.SortMode;
import me.angeschossen.lands.api.levels.LevelsHandler;
import me.angeschossen.lands.api.nation.Nation;
import me.angeschossen.lands.api.player.LandPlayer;
import me.angeschossen.lands.api.player.OfflinePlayer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LandsIntegrator {
    @NotNull
    public LevelsHandler getLevelsHandler();

    public void onLoad(@NotNull Runnable var1);

    @NotNull
    public FlagRegistry getFlagRegistry();

    public void registerFlag(@NotNull Flag var1) throws FlagConflictException, IllegalArgumentException;

    @Nullable
    public LandPlayer getLandPlayer(@NotNull UUID var1);

    @Nullable
    public LandWorld getLandWorld(@NotNull World var1);

    public boolean isClaimed(@NotNull Location var1);

    @Deprecated
    public CompletableFuture<Boolean> isClaimed(@NotNull String var1, int var2, int var3);

    public boolean isClaimed(@NotNull World var1, int var2, int var3);

    @Deprecated
    public Land getLand(@NotNull String var1, @NotNull String var2);

    @NotNull
    public CompletableFuture<OfflinePlayer> getOfflineLandPlayer(@NotNull UUID var1);

    @Deprecated
    public LandWorld getLandWorld(@NotNull String var1);

    public Land getLand(int var1);

    @Nullable
    public Nation getNation(int var1);

    @Nullable
    public Nation getNation(@NotNull String var1);

    public void wild(@NotNull LandPlayer var1, @NotNull World var2);

    public Land getLand(@NotNull String var1);

    @Nullable
    public Land getLand(@NotNull Location var1);

    @Nullable
    public Land getLand(@NotNull World var1, int var2, int var3);

    @NotNull
    public Collection<Land> getLands();

    @Deprecated
    @Nullable
    public LandArea getArea(@NotNull Location var1);

    @Nullable
    public Area getArea(@NotNull World var1, int var2, int var3, int var4);

    @Nullable
    public Area getAreaByLoc(@NotNull Location var1);

    @NotNull
    public List<Land> getTopLands(SortMode var1);

    @NotNull
    public List<Land> getTopLands(@NotNull SortMode var1, int var2);

    @NotNull
    public Land getTopLand(@NotNull SortMode var1, int var2);

    @NotNull
    public List<String> printTopLands(SortMode var1, int var2);

    @Nullable
    public Plugin getPlugin();

    @NotNull
    public String getName();

    @Deprecated
    public void disable();

    @Deprecated
    public void disable(@Nullable String var1);

    @Deprecated
    @NotNull
    public String initialize();

    @Deprecated
    public boolean isEnabled();

    @Deprecated
    public boolean getAccess(@NotNull String var1);

    @Deprecated
    public boolean isPublic();

    @NotNull
    public SortMode getDefaultTopSortMode();

    public boolean canPvP(@NotNull Player var1, @NotNull Player var2, @NotNull Location var3, boolean var4, boolean var5);
}

