/*
 * Decompiled with CFR 0.152.
 */
package com.angcyo.drawable.base;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.angcyo.drawable.base.AbsDslDrawable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 o2\u00020\u0001:\u0001oB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0014H\u0016J\n\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010?\u001a\u0002092\u0006\u0010@\u001a\u00020\u0004H\u0016J\b\u0010A\u001a\u00020\u0014H\u0016J\b\u0010B\u001a\u00020\u0014H\u0016J\b\u0010C\u001a\u00020\u0014H\u0016J\b\u0010D\u001a\u00020\u0014H\u0016J\b\u0010E\u001a\u00020\u0014H\u0016J\u001c\u0010F\u001a\u0002092\u0006\u0010G\u001a\u00020H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010JH\u0016J\b\u0010K\u001a\u00020\u001aH\u0016J\b\u0010L\u001a\u00020\u0001H\u0016J\u0012\u0010M\u001a\u0002092\b\u0010N\u001a\u0004\u0018\u00010\u0004H\u0014J\u0010\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u0014H\u0014J\u0012\u0010Q\u001a\u00020\u001a2\b\u0010R\u001a\u0004\u0018\u00010SH\u0014J\u0010\u0010T\u001a\u0002092\u0006\u0010U\u001a\u00020\u0014H\u0016J\u0010\u0010V\u001a\u0002092\u0006\u0010N\u001a\u00020\u0004H\u0016J(\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020\u00142\u0006\u0010X\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u0014H\u0016J\u0012\u0010[\u001a\u0002092\b\u0010\\\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010]\u001a\u0002092\u0006\u0010^\u001a\u00020\u001aH\u0016J\u0010\u0010_\u001a\u0002092\u0006\u0010`\u001a\u00020\u001aH\u0016J\u0018\u0010a\u001a\u0002092\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020cH\u0016J(\u0010e\u001a\u0002092\u0006\u0010W\u001a\u00020\u00142\u0006\u0010X\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u0014H\u0016J\u0012\u0010f\u001a\u0002092\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u0012\u0010i\u001a\u0002092\b\u0010j\u001a\u0004\u0018\u00010kH\u0016J\u0012\u0010l\u001a\u0002092\b\u0010m\u001a\u0004\u0018\u00010nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001bR\u0011\u0010\"\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0016R\u0011\u0010$\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0016R\u0011\u0010&\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0016R\u0011\u0010(\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R\u001b\u0010*\u001a\u00020+8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b,\u0010-R\u0011\u00100\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0016R\u0011\u00102\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0016R\u0011\u00104\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0016R\u0011\u00106\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016\u00a8\u0006p"}, d2={"Lcom/angcyo/drawable/base/AbsDslDrawable;", "Landroid/graphics/drawable/Drawable;", "()V", "_lastBounds", "Landroid/graphics/Rect;", "get_lastBounds", "()Landroid/graphics/Rect;", "set_lastBounds", "(Landroid/graphics/Rect;)V", "attachView", "Landroid/view/View;", "getAttachView", "()Landroid/view/View;", "drawRect", "getDrawRect", "drawRectF", "Landroid/graphics/RectF;", "getDrawRectF", "()Landroid/graphics/RectF;", "drawType", "", "getDrawType", "()I", "setDrawType", "(I)V", "isInEditMode", "", "()Z", "isTranslucent", "()Ljava/lang/Boolean;", "setTranslucent", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isViewRtl", "paddingBottom", "getPaddingBottom", "paddingLeft", "getPaddingLeft", "paddingRight", "getPaddingRight", "paddingTop", "getPaddingTop", "textPaint", "Landroid/text/TextPaint;", "getTextPaint", "()Landroid/text/TextPaint;", "textPaint$delegate", "Lkotlin/Lazy;", "viewDrawHeight", "getViewDrawHeight", "viewDrawWidth", "getViewDrawWidth", "viewHeight", "getViewHeight", "viewWidth", "getViewWidth", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "getColorFilter", "Landroid/graphics/ColorFilter;", "getHotspotBounds", "outRect", "getIntrinsicHeight", "getIntrinsicWidth", "getMinimumHeight", "getMinimumWidth", "getOpacity", "initAttribute", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "isFilterBitmap", "mutate", "onBoundsChange", "bounds", "onLevelChange", "level", "onStateChange", "state", "", "setAlpha", "alpha", "setBounds", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "setDither", "dither", "setFilterBitmap", "filter", "setHotspot", "x", "", "y", "setHotspotBounds", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "Companion", "button_release"})
public abstract class AbsDslDrawable
extends Drawable {
    @NotNull
    private final Lazy textPaint$delegate = LazyKt.lazy((Function0)textPaint.2.INSTANCE);
    @NotNull
    private final Rect drawRect = new Rect();
    @NotNull
    private final RectF drawRectF = new RectF();
    private int drawType = 4;
    @Nullable
    private Boolean isTranslucent;
    @Nullable
    private Rect _lastBounds;
    public static final int DRAW_TYPE_DRAW_NONE = 0;
    public static final int DRAW_TYPE_DRAW_AFTER = 1;
    public static final int DRAW_TYPE_DRAW_BEFORE = 2;
    public static final int DRAW_TYPE_ON_DRAW_AFTER = 4;
    public static final int DRAW_TYPE_ON_DRAW_BEFORE = 8;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TextPaint getTextPaint() {
        Lazy lazy = this.textPaint$delegate;
        AbsDslDrawable absDslDrawable = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TextPaint)lazy.getValue();
    }

    @NotNull
    public final Rect getDrawRect() {
        return this.drawRect;
    }

    @NotNull
    public final RectF getDrawRectF() {
        return this.drawRectF;
    }

    public final int getDrawType() {
        return this.drawType;
    }

    public final void setDrawType(int n) {
        this.drawType = n;
    }

    public void initAttribute(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    public static /* synthetic */ void initAttribute$default(AbsDslDrawable absDslDrawable, Context context, AttributeSet attributeSet, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initAttribute");
        }
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        absDslDrawable.initAttribute(context, attributeSet);
    }

    @Nullable
    public final Boolean isTranslucent() {
        return this.isTranslucent;
    }

    public final void setTranslucent(@Nullable Boolean bl) {
        this.isTranslucent = bl;
    }

    @Nullable
    public final View getAttachView() {
        View view;
        if (this.getCallback() instanceof View) {
            Drawable.Callback callback = this.getCallback();
            if (!(callback instanceof View)) {
                callback = null;
            }
            view = (View)callback;
        } else {
            view = null;
        }
        return view;
    }

    public final boolean isInEditMode() {
        View view = this.getAttachView();
        return view != null ? view.isInEditMode() : false;
    }

    public final int getPaddingLeft() {
        View view = this.getAttachView();
        return view != null ? view.getPaddingLeft() : 0;
    }

    public final int getPaddingRight() {
        View view = this.getAttachView();
        return view != null ? view.getPaddingRight() : 0;
    }

    public final int getPaddingTop() {
        View view = this.getAttachView();
        return view != null ? view.getPaddingTop() : 0;
    }

    public final int getPaddingBottom() {
        View view = this.getAttachView();
        return view != null ? view.getPaddingBottom() : 0;
    }

    public final int getViewHeight() {
        View view = this.getAttachView();
        return view != null ? view.getMeasuredHeight() : 0;
    }

    public final int getViewWidth() {
        View view = this.getAttachView();
        return view != null ? view.getMeasuredWidth() : 0;
    }

    public final int getViewDrawHeight() {
        return this.getViewHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public final int getViewDrawWidth() {
        return this.getViewWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isViewRtl() {
        if (this.getAttachView() == null) return false;
        View view = this.getAttachView();
        if (view == null) {
            Intrinsics.throwNpe();
        }
        if (ViewCompat.getLayoutDirection((View)view) != 1) return false;
        return true;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
    }

    public int getIntrinsicWidth() {
        return super.getIntrinsicWidth();
    }

    public int getMinimumWidth() {
        return super.getMinimumWidth();
    }

    public int getIntrinsicHeight() {
        return super.getIntrinsicHeight();
    }

    public int getMinimumHeight() {
        return super.getMinimumHeight();
    }

    public void setAlpha(int alpha) {
        if (this.getTextPaint().getAlpha() != alpha) {
            this.getTextPaint().setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.getTextPaint().getAlpha();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.drawRect.set(left, top, right, bottom);
        this.drawRectF.set((float)left, (float)top, (float)right, (float)bottom);
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        super.setBounds(bounds);
    }

    public int getOpacity() {
        Boolean translucent = this.isTranslucent;
        return translucent == null ? (this.getAlpha() < 255 ? -3 : -1) : (translucent != false ? -3 : -1);
    }

    @Nullable
    public ColorFilter getColorFilter() {
        return this.getTextPaint().getColorFilter();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.getTextPaint().setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @NotNull
    public Drawable mutate() {
        Drawable drawable = super.mutate();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"super.mutate()");
        return drawable;
    }

    public void setDither(boolean dither) {
        this.getTextPaint().setDither(dither);
        this.invalidateSelf();
    }

    public void setFilterBitmap(boolean filter) {
        this.getTextPaint().setFilterBitmap(filter);
        this.invalidateSelf();
    }

    public boolean isFilterBitmap() {
        return this.getTextPaint().isFilterBitmap();
    }

    @Nullable
    public final Rect get_lastBounds() {
        return this._lastBounds;
    }

    public final void set_lastBounds(@Nullable Rect rect) {
        this._lastBounds = rect;
    }

    protected void onBoundsChange(@Nullable Rect bounds) {
        super.onBoundsChange(bounds);
        View view = this.getAttachView();
        if (view == null || !view.isInEditMode()) {
            if (Intrinsics.areEqual((Object)this._lastBounds, (Object)bounds) ^ true) {
                this._lastBounds = bounds;
            }
        }
    }

    protected boolean onLevelChange(int level) {
        return super.onLevelChange(level);
    }

    protected boolean onStateChange(@Nullable int[] state) {
        return super.onStateChange(state);
    }

    public void setTintList(@Nullable ColorStateList tint) {
        super.setTintList(tint);
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        super.setTintMode(tintMode);
    }

    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        super.setTintBlendMode(blendMode);
    }

    public void setHotspot(float x, float y) {
        super.setHotspot(x, y);
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        super.setHotspotBounds(left, top, right, bottom);
    }

    public void getHotspotBounds(@NotNull Rect outRect) {
        Intrinsics.checkParameterIsNotNull((Object)outRect, (String)"outRect");
        super.getHotspotBounds(outRect);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/angcyo/drawable/base/AbsDslDrawable$Companion;", "", "()V", "DRAW_TYPE_DRAW_AFTER", "", "DRAW_TYPE_DRAW_BEFORE", "DRAW_TYPE_DRAW_NONE", "DRAW_TYPE_ON_DRAW_AFTER", "DRAW_TYPE_ON_DRAW_BEFORE", "button_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

