/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.renderscript;

import android.graphics.Bitmap;
import com.google.android.renderscript.Range2d;
import com.google.android.renderscript.ToolkitKt$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a,\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"externalName", "", "createCompatibleBitmap", "Landroid/graphics/Bitmap;", "kotlin.jvm.PlatformType", "inputBitmap", "paddedSize", "", "vectorSize", "validateBitmap", "", "function", "alphaAllowed", "", "validateHistogramDotCoefficients", "coefficients", "", "validateRestriction", "tag", "bitmap", "restriction", "Lcom/google/android/renderscript/Range2d;", "sizeX", "sizeY", "renderscript-toolkit_release"})
public final class ToolkitKt {
    private static final String externalName = "RenderScript Toolkit";

    public static final void validateBitmap(@NotNull String function, @NotNull Bitmap inputBitmap, boolean alphaAllowed) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        if (alphaAllowed) {
            bl3 = inputBitmap.getConfig() == Bitmap.Config.ARGB_8888 || inputBitmap.getConfig() == Bitmap.Config.ALPHA_8;
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl4 = false;
                String string = "RenderScript Toolkit. " + function + " supports only ARGB_8888 and ALPHA_8 bitmaps. " + inputBitmap.getConfig() + " provided.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        } else {
            bl3 = inputBitmap.getConfig() == Bitmap.Config.ARGB_8888;
            bl2 = false;
            bl = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "RenderScript Toolkit. " + function + " supports only ARGB_8888. " + inputBitmap.getConfig() + " provided.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        bl3 = inputBitmap.getWidth() * ToolkitKt.vectorSize(inputBitmap) == inputBitmap.getRowBytes();
        bl2 = false;
        bl = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "RenderScript Toolkit " + function + ". Only bitmaps with rowSize equal to the width * vectorSize are " + "currently supported. Provided were rowBytes=" + inputBitmap.getRowBytes() + ", " + "width={" + inputBitmap.getWidth() + ", and vectorSize=" + ToolkitKt.vectorSize(inputBitmap) + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void validateBitmap$default(String string, Bitmap bitmap, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ToolkitKt.validateBitmap(string, bitmap, bl);
    }

    public static final Bitmap createCompatibleBitmap(@NotNull Bitmap inputBitmap) {
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        return Bitmap.createBitmap((int)inputBitmap.getWidth(), (int)inputBitmap.getHeight(), (Bitmap.Config)inputBitmap.getConfig());
    }

    /*
     * WARNING - void declaration
     */
    public static final void validateHistogramDotCoefficients(@Nullable float[] coefficients, int vectorSize) {
        boolean bl = coefficients == null || coefficients.length == vectorSize;
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "RenderScript Toolkit histogramDot. The coefficients should be null or have " + vectorSize + " values.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (coefficients != null) {
            boolean bl3;
            float sum = 0.0f;
            n = 0;
            n2 = vectorSize;
            while (n < n2) {
                void i;
                bl3 = coefficients[i] >= 0.0f;
                boolean bl4 = false;
                boolean bl5 = false;
                if (!bl3) {
                    boolean bl6 = false;
                    String string = "RenderScript Toolkit histogramDot. Coefficients should not be negative. " + "Coefficient " + (int)i + " was " + coefficients[i] + '.';
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                sum += coefficients[i];
                ++i;
            }
            n = sum <= 1.0f ? 1 : 0;
            n2 = 0;
            bl3 = false;
            if (n == 0) {
                boolean bl7 = false;
                String string = "RenderScript Toolkit histogramDot. Coefficients should add to 1 or less. Their sum is " + sum + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public static final void validateRestriction(@NotNull String tag, @NotNull Bitmap bitmap, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        ToolkitKt.validateRestriction(tag, bitmap.getWidth(), bitmap.getHeight(), restriction);
    }

    public static /* synthetic */ void validateRestriction$default(String string, Bitmap bitmap, Range2d range2d, int n, Object object) {
        if ((n & 4) != 0) {
            range2d = null;
        }
        ToolkitKt.validateRestriction(string, bitmap, range2d);
    }

    public static final void validateRestriction(@NotNull String tag, int sizeX, int sizeY, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (restriction == null) {
            return;
        }
        boolean bl = restriction.getStartX() < sizeX && restriction.getEndX() <= sizeX;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit " + tag + ". sizeX should be greater than restriction.startX and greater " + "or equal to restriction.endX. " + sizeX + ", " + restriction.getStartX() + ", " + "and " + restriction.getEndX() + " were provided respectively.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = restriction.getStartY() < sizeY && restriction.getEndY() <= sizeY;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit " + tag + ". sizeY should be greater than restriction.startY and greater " + "or equal to restriction.endY. " + sizeY + ", " + restriction.getStartY() + ", " + "and " + restriction.getEndY() + " were provided respectively.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = restriction.getStartX() < restriction.getEndX();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "RenderScript Toolkit " + tag + ". Restriction startX should be less than endX. " + restriction.getStartX() + " and " + restriction.getEndX() + " were provided respectively.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = restriction.getStartY() < restriction.getEndY();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "RenderScript Toolkit " + tag + ". Restriction startY should be less than endY. " + restriction.getStartY() + " and " + restriction.getEndY() + " were provided respectively.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void validateRestriction$default(String string, int n, int n2, Range2d range2d, int n3, Object object) {
        if ((n3 & 8) != 0) {
            range2d = null;
        }
        ToolkitKt.validateRestriction(string, n, n2, range2d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final int vectorSize(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Bitmap.Config config = bitmap.getConfig();
        if (config == null) throw (Throwable)new IllegalArgumentException("RenderScript Toolkit. Only ARGB_8888 and ALPHA_8 Bitmap are supported.");
        switch (ToolkitKt$WhenMappings.$EnumSwitchMapping$0[config.ordinal()]) {
            case 1: {
                return 4;
            }
            case 2: {
                return 1;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("RenderScript Toolkit. Only ARGB_8888 and ALPHA_8 Bitmap are supported.");
            }
        }
    }

    public static final int paddedSize(int vectorSize) {
        return vectorSize == 3 ? 4 : vectorSize;
    }
}

