/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.renderscript;

import android.graphics.Bitmap;
import com.google.android.renderscript.BlendingMode;
import com.google.android.renderscript.LookupTable;
import com.google.android.renderscript.Range2d;
import com.google.android.renderscript.Rgba3dArray;
import com.google.android.renderscript.ToolkitKt;
import com.google.android.renderscript.YuvFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J<\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J&\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\b\b\u0002\u0010 \u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J>\u0010\u001e\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\b\u0002\u0010 \u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J.\u0010#\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007JN\u0010#\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J$\u0010(\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J<\u0010(\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\t\u0010*\u001a\u00020\nH\u0082 J\u0011\u0010+\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0082 J\u001c\u0010,\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J4\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J(\u0010.\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u00142\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J@\u0010.\u001a\u00020-2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J$\u0010/\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u00100\u001a\u0002012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J4\u0010/\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J$\u00102\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u00103\u001a\u0002042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J4\u00102\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00103\u001a\u0002042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007JC\u00105\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J3\u00106\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JK\u00107\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J3\u00109\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J[\u0010;\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J;\u0010<\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JK\u0010=\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J3\u0010>\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JC\u0010?\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00108\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J+\u0010@\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u00108\u001a\u00020-2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JK\u0010A\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00108\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J3\u0010B\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u00108\u001a\u00020-2\u0006\u0010)\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J[\u0010C\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J[\u0010H\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JK\u0010L\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\u001c2\u0006\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JK\u0010M\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u00192\u0006\u0010G\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 JS\u0010N\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J+\u0010S\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0082 J9\u0010T\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u00108\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020\u001cH\u0082 J9\u0010V\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u00142\u0006\u0010W\u001a\u00020\u001cH\u0082 J,\u0010X\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007JD\u0010X\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020\u001c2\u0006\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020\u001c2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\u0006\u0010Y\u001a\u00020\u0010J&\u0010Z\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020[J&\u0010\\\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010U\u001a\u00020[R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006]"}, d2={"Lcom/google/android/renderscript/Toolkit;", "", "()V", "greyScaleColorMatrix", "", "getGreyScaleColorMatrix", "()[F", "identityMatrix", "getIdentityMatrix", "nativeHandle", "", "rgbToYuvMatrix", "getRgbToYuvMatrix", "yuvToRgbMatrix", "getYuvToRgbMatrix", "blend", "", "mode", "Lcom/google/android/renderscript/BlendingMode;", "sourceBitmap", "Landroid/graphics/Bitmap;", "destBitmap", "restriction", "Lcom/google/android/renderscript/Range2d;", "sourceArray", "", "destArray", "sizeX", "", "sizeY", "blur", "inputBitmap", "radius", "inputArray", "vectorSize", "colorMatrix", "matrix", "addVector", "inputVectorSize", "outputVectorSize", "convolve", "coefficients", "createNative", "destroyNative", "histogram", "", "histogramDot", "lut", "table", "Lcom/google/android/renderscript/LookupTable;", "lut3d", "cube", "Lcom/google/android/renderscript/Rgba3dArray;", "nativeBlend", "nativeBlendBitmap", "nativeBlur", "outputArray", "nativeBlurBitmap", "outputBitmap", "nativeColorMatrix", "nativeColorMatrixBitmap", "nativeConvolve", "nativeConvolveBitmap", "nativeHistogram", "nativeHistogramBitmap", "nativeHistogramDot", "nativeHistogramDotBitmap", "nativeLut", "red", "green", "blue", "alpha", "nativeLut3d", "cubeSizeX", "cubeSizeY", "cubeSizeZ", "nativeLut3dBitmap", "nativeLutBitmap", "nativeResize", "inputSizeX", "inputSizeY", "outputSizeX", "outputSizeY", "nativeResizeBitmap", "nativeYuvToRgb", "format", "nativeYuvToRgbBitmap", "value", "resize", "shutdown", "yuvToRgb", "Lcom/google/android/renderscript/YuvFormat;", "yuvToRgbBitmap", "renderscript-toolkit_release"})
public final class Toolkit {
    private static long nativeHandle;
    @NotNull
    public static final Toolkit INSTANCE;

    @JvmOverloads
    public final void blend(@NotNull BlendingMode mode, @NotNull byte[] sourceArray, @NotNull byte[] destArray, int sizeX, int sizeY, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)sourceArray, (String)"sourceArray");
        Intrinsics.checkNotNullParameter((Object)destArray, (String)"destArray");
        boolean bl = sourceArray.length >= sizeX * sizeY * 4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit blend. sourceArray is too small for the given dimensions. " + sizeX + '*' + sizeY + "*4 < " + sourceArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = destArray.length >= sizeX * sizeY * 4;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit blend. sourceArray is too small for the given dimensions. " + sizeX + '*' + sizeY + "*4 < " + sourceArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("blend", sizeX, sizeY, restriction);
        this.nativeBlend(nativeHandle, mode.getValue(), sourceArray, destArray, sizeX, sizeY, restriction);
    }

    public static /* synthetic */ void blend$default(Toolkit toolkit, BlendingMode blendingMode, byte[] byArray, byte[] byArray2, int n, int n2, Range2d range2d, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            range2d = null;
        }
        toolkit.blend(blendingMode, byArray, byArray2, n, n2, range2d);
    }

    @JvmOverloads
    public final void blend(@NotNull BlendingMode mode, @NotNull byte[] sourceArray, @NotNull byte[] destArray, int sizeX, int sizeY) {
        Toolkit.blend$default(this, mode, sourceArray, destArray, sizeX, sizeY, null, 32, null);
    }

    @JvmOverloads
    public final void blend(@NotNull BlendingMode mode, @NotNull Bitmap sourceBitmap, @NotNull Bitmap destBitmap, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)sourceBitmap, (String)"sourceBitmap");
        Intrinsics.checkNotNullParameter((Object)destBitmap, (String)"destBitmap");
        ToolkitKt.validateBitmap$default("blend", sourceBitmap, false, 4, null);
        ToolkitKt.validateBitmap$default("blend", destBitmap, false, 4, null);
        boolean bl = sourceBitmap.getWidth() == destBitmap.getWidth() && sourceBitmap.getHeight() == destBitmap.getHeight();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit blend. Source and destination bitmaps should be the same size. " + sourceBitmap.getWidth() + 'x' + sourceBitmap.getHeight() + " and " + destBitmap.getWidth() + 'x' + destBitmap.getHeight() + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = sourceBitmap.getConfig() == destBitmap.getConfig();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit blend. Source and destination bitmaps should have the same " + "config. " + sourceBitmap.getConfig() + " and " + destBitmap.getConfig() + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("blend", sourceBitmap.getWidth(), sourceBitmap.getHeight(), restriction);
        this.nativeBlendBitmap(nativeHandle, mode.getValue(), sourceBitmap, destBitmap, restriction);
    }

    public static /* synthetic */ void blend$default(Toolkit toolkit, BlendingMode blendingMode, Bitmap bitmap, Bitmap bitmap2, Range2d range2d, int n, Object object) {
        if ((n & 8) != 0) {
            range2d = null;
        }
        toolkit.blend(blendingMode, bitmap, bitmap2, range2d);
    }

    @JvmOverloads
    public final void blend(@NotNull BlendingMode mode, @NotNull Bitmap sourceBitmap, @NotNull Bitmap destBitmap) {
        Toolkit.blend$default(this, mode, sourceBitmap, destBitmap, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] blur(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, int radius, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        int n = vectorSize == 1 || vectorSize == 4 ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit blur. The vectorSize should be 1 or 4. " + vectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= sizeX * sizeY * vectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit blur. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + '*' + vectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = radius;
        n = 1 <= n && 25 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit blur. The radius should be between 1 and 25. " + radius + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("blur", sizeX, sizeY, restriction);
        byte[] outputArray = new byte[inputArray.length];
        this.nativeBlur(nativeHandle, inputArray, vectorSize, sizeX, sizeY, radius, outputArray, restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] blur$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, int n4, Range2d range2d, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            n4 = 5;
        }
        if ((n5 & 0x20) != 0) {
            range2d = null;
        }
        return toolkit.blur(byArray, n, n2, n3, n4, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] blur(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, int radius) {
        return Toolkit.blur$default(this, inputArray, vectorSize, sizeX, sizeY, radius, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] blur(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY) {
        return Toolkit.blur$default(this, inputArray, vectorSize, sizeX, sizeY, 0, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap blur(@NotNull Bitmap inputBitmap, int radius, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        ToolkitKt.validateBitmap$default("blur", inputBitmap, false, 4, null);
        int n = radius;
        n = 1 <= n && 25 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit blur. The radius should be between 1 and 25. " + radius + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("blur", inputBitmap.getWidth(), inputBitmap.getHeight(), restriction);
        Bitmap bitmap = outputBitmap = ToolkitKt.createCompatibleBitmap(inputBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeBlurBitmap(nativeHandle, inputBitmap, bitmap, radius, restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap blur$default(Toolkit toolkit, Bitmap bitmap, int n, Range2d range2d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 5;
        }
        if ((n2 & 4) != 0) {
            range2d = null;
        }
        return toolkit.blur(bitmap, n, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap blur(@NotNull Bitmap inputBitmap, int radius) {
        return Toolkit.blur$default(this, inputBitmap, radius, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap blur(@NotNull Bitmap inputBitmap) {
        return Toolkit.blur$default(this, inputBitmap, 0, null, 6, null);
    }

    @NotNull
    public final float[] getIdentityMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @NotNull
    public final float[] getGreyScaleColorMatrix() {
        return new float[]{0.299f, 0.299f, 0.299f, 0.0f, 0.587f, 0.587f, 0.587f, 0.0f, 0.114f, 0.114f, 0.114f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @NotNull
    public final float[] getRgbToYuvMatrix() {
        return new float[]{0.299f, -0.14713f, 0.615f, 0.0f, 0.587f, -0.28886f, -0.51499f, 0.0f, 0.114f, 0.436f, -0.10001f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @NotNull
    public final float[] getYuvToRgbMatrix() {
        return new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, -0.39465f, 2.03211f, 0.0f, 1.13983f, -0.5806f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    @JvmOverloads
    @NotNull
    public final byte[] colorMatrix(@NotNull byte[] inputArray, int inputVectorSize, int sizeX, int sizeY, int outputVectorSize, @NotNull float[] matrix, @NotNull float[] addVector, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)addVector, (String)"addVector");
        int n = inputVectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit colorMatrix. The inputVectorSize should be between 1 and 4. " + inputVectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = outputVectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit colorMatrix. The outputVectorSize should be between 1 and 4. " + outputVectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= sizeX * sizeY * inputVectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit colorMatrix. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + '*' + inputVectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = matrix.length == 16 ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl6 = false;
            String string = "RenderScript Toolkit colorMatrix. matrix should have 16 entries. " + matrix.length + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = addVector.length == 4 ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl7 = false;
            String string = "RenderScript Toolkit colorMatrix. addVector should have 4 entries. " + addVector.length + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("colorMatrix", sizeX, sizeY, restriction);
        byte[] outputArray = new byte[sizeX * sizeY * ToolkitKt.paddedSize(outputVectorSize)];
        this.nativeColorMatrix(nativeHandle, inputArray, inputVectorSize, sizeX, sizeY, outputArray, outputVectorSize, matrix, addVector, restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] colorMatrix$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, int n4, float[] fArray, float[] fArray2, Range2d range2d, int n5, Object object) {
        if ((n5 & 0x40) != 0) {
            fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }
        if ((n5 & 0x80) != 0) {
            range2d = null;
        }
        return toolkit.colorMatrix(byArray, n, n2, n3, n4, fArray, fArray2, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] colorMatrix(@NotNull byte[] inputArray, int inputVectorSize, int sizeX, int sizeY, int outputVectorSize, @NotNull float[] matrix, @NotNull float[] addVector) {
        return Toolkit.colorMatrix$default(this, inputArray, inputVectorSize, sizeX, sizeY, outputVectorSize, matrix, addVector, null, 128, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] colorMatrix(@NotNull byte[] inputArray, int inputVectorSize, int sizeX, int sizeY, int outputVectorSize, @NotNull float[] matrix) {
        return Toolkit.colorMatrix$default(this, inputArray, inputVectorSize, sizeX, sizeY, outputVectorSize, matrix, null, null, 192, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap colorMatrix(@NotNull Bitmap inputBitmap, @NotNull float[] matrix, @NotNull float[] addVector, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)addVector, (String)"addVector");
        ToolkitKt.validateBitmap$default("colorMatrix", inputBitmap, false, 4, null);
        boolean bl = matrix.length == 16;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit colorMatrix. matrix should have 16 entries. " + matrix.length + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = addVector.length == 4;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit colorMatrix. addVector should have 4 entries.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("colorMatrix", inputBitmap.getWidth(), inputBitmap.getHeight(), restriction);
        Bitmap bitmap = outputBitmap = ToolkitKt.createCompatibleBitmap(inputBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeColorMatrixBitmap(nativeHandle, inputBitmap, bitmap, matrix, addVector, restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap colorMatrix$default(Toolkit toolkit, Bitmap bitmap, float[] fArray, float[] fArray2, Range2d range2d, int n, Object object) {
        if ((n & 4) != 0) {
            fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }
        if ((n & 8) != 0) {
            range2d = null;
        }
        return toolkit.colorMatrix(bitmap, fArray, fArray2, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap colorMatrix(@NotNull Bitmap inputBitmap, @NotNull float[] matrix, @NotNull float[] addVector) {
        return Toolkit.colorMatrix$default(this, inputBitmap, matrix, addVector, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap colorMatrix(@NotNull Bitmap inputBitmap, @NotNull float[] matrix) {
        return Toolkit.colorMatrix$default(this, inputBitmap, matrix, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] convolve(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, @NotNull float[] coefficients, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        int n = vectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit convolve. The vectorSize should be between 1 and 4. " + vectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= sizeX * sizeY * vectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit convolve. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + '*' + vectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = coefficients.length == 9 || coefficients.length == 25 ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit convolve. Only 3x3 or 5x5 convolutions are supported. " + coefficients.length + " coefficients provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("convolve", sizeX, sizeY, restriction);
        byte[] outputArray = new byte[inputArray.length];
        this.nativeConvolve(nativeHandle, inputArray, vectorSize, sizeX, sizeY, outputArray, coefficients, restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] convolve$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, float[] fArray, Range2d range2d, int n4, Object object) {
        if ((n4 & 0x20) != 0) {
            range2d = null;
        }
        return toolkit.convolve(byArray, n, n2, n3, fArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] convolve(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, @NotNull float[] coefficients) {
        return Toolkit.convolve$default(this, inputArray, vectorSize, sizeX, sizeY, coefficients, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap convolve(@NotNull Bitmap inputBitmap, @NotNull float[] coefficients, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkNotNullParameter((Object)coefficients, (String)"coefficients");
        ToolkitKt.validateBitmap$default("convolve", inputBitmap, false, 4, null);
        boolean bl = coefficients.length == 9 || coefficients.length == 25;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit convolve. Only 3x3 or 5x5 convolutions are supported. " + coefficients.length + " coefficients provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("convolve", inputBitmap, restriction);
        Bitmap bitmap = outputBitmap = ToolkitKt.createCompatibleBitmap(inputBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeConvolveBitmap(nativeHandle, inputBitmap, bitmap, coefficients, restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap convolve$default(Toolkit toolkit, Bitmap bitmap, float[] fArray, Range2d range2d, int n, Object object) {
        if ((n & 4) != 0) {
            range2d = null;
        }
        return toolkit.convolve(bitmap, fArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap convolve(@NotNull Bitmap inputBitmap, @NotNull float[] coefficients) {
        return Toolkit.convolve$default(this, inputBitmap, coefficients, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogram(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        int n = vectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit histogram. The vectorSize should be between 1 and 4. " + vectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= sizeX * sizeY * vectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit histogram. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + '*' + vectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("histogram", sizeX, sizeY, restriction);
        int[] outputArray = new int[256 * ToolkitKt.paddedSize(vectorSize)];
        this.nativeHistogram(nativeHandle, inputArray, vectorSize, sizeX, sizeY, outputArray, restriction);
        return outputArray;
    }

    public static /* synthetic */ int[] histogram$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, Range2d range2d, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            range2d = null;
        }
        return toolkit.histogram(byArray, n, n2, n3, range2d);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogram(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY) {
        return Toolkit.histogram$default(this, inputArray, vectorSize, sizeX, sizeY, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogram(@NotNull Bitmap inputBitmap, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        ToolkitKt.validateBitmap$default("histogram", inputBitmap, false, 4, null);
        ToolkitKt.validateRestriction("histogram", inputBitmap, restriction);
        int[] outputArray = new int[256 * ToolkitKt.vectorSize(inputBitmap)];
        this.nativeHistogramBitmap(nativeHandle, inputBitmap, outputArray, restriction);
        return outputArray;
    }

    public static /* synthetic */ int[] histogram$default(Toolkit toolkit, Bitmap bitmap, Range2d range2d, int n, Object object) {
        if ((n & 2) != 0) {
            range2d = null;
        }
        return toolkit.histogram(bitmap, range2d);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogram(@NotNull Bitmap inputBitmap) {
        return Toolkit.histogram$default(this, inputBitmap, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, @Nullable float[] coefficients, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        int n = vectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit histogramDot. The vectorSize should be between 1 and 4. " + vectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= sizeX * sizeY * vectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit histogramDot. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + '*' + vectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateHistogramDotCoefficients(coefficients, vectorSize);
        ToolkitKt.validateRestriction("histogramDot", sizeX, sizeY, restriction);
        int[] outputArray = new int[256];
        float[] fArray = coefficients;
        if (coefficients == null) {
            float[] fArray2 = new float[4];
            fArray2[0] = 0.299f;
            fArray2[1] = 0.587f;
            fArray2[2] = 0.114f;
            fArray = fArray2;
            fArray2[3] = 0.0f;
        }
        float[] actualCoefficients = fArray;
        this.nativeHistogramDot(nativeHandle, inputArray, vectorSize, sizeX, sizeY, outputArray, actualCoefficients, restriction);
        return outputArray;
    }

    public static /* synthetic */ int[] histogramDot$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, float[] fArray, Range2d range2d, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            fArray = null;
        }
        if ((n4 & 0x20) != 0) {
            range2d = null;
        }
        return toolkit.histogramDot(byArray, n, n2, n3, fArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY, @Nullable float[] coefficients) {
        return Toolkit.histogramDot$default(this, inputArray, vectorSize, sizeX, sizeY, coefficients, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull byte[] inputArray, int vectorSize, int sizeX, int sizeY) {
        return Toolkit.histogramDot$default(this, inputArray, vectorSize, sizeX, sizeY, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull Bitmap inputBitmap, @Nullable float[] coefficients, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        ToolkitKt.validateBitmap$default("histogramDot", inputBitmap, false, 4, null);
        ToolkitKt.validateHistogramDotCoefficients(coefficients, ToolkitKt.vectorSize(inputBitmap));
        ToolkitKt.validateRestriction("histogramDot", inputBitmap, restriction);
        int[] outputArray = new int[256];
        float[] fArray = coefficients;
        if (coefficients == null) {
            float[] fArray2 = new float[4];
            fArray2[0] = 0.299f;
            fArray2[1] = 0.587f;
            fArray2[2] = 0.114f;
            fArray = fArray2;
            fArray2[3] = 0.0f;
        }
        float[] actualCoefficients = fArray;
        this.nativeHistogramDotBitmap(nativeHandle, inputBitmap, outputArray, actualCoefficients, restriction);
        return outputArray;
    }

    public static /* synthetic */ int[] histogramDot$default(Toolkit toolkit, Bitmap bitmap, float[] fArray, Range2d range2d, int n, Object object) {
        if ((n & 2) != 0) {
            fArray = null;
        }
        if ((n & 4) != 0) {
            range2d = null;
        }
        return toolkit.histogramDot(bitmap, fArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull Bitmap inputBitmap, @Nullable float[] coefficients) {
        return Toolkit.histogramDot$default(this, inputBitmap, coefficients, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final int[] histogramDot(@NotNull Bitmap inputBitmap) {
        return Toolkit.histogramDot$default(this, inputBitmap, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] lut(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull LookupTable table, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        boolean bl = inputArray.length >= sizeX * sizeY * 4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit lut. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + "*4 < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("lut", sizeX, sizeY, restriction);
        byte[] outputArray = new byte[inputArray.length];
        this.nativeLut(nativeHandle, inputArray, outputArray, sizeX, sizeY, table.getRed(), table.getGreen(), table.getBlue(), table.getAlpha(), restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] lut$default(Toolkit toolkit, byte[] byArray, int n, int n2, LookupTable lookupTable, Range2d range2d, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            range2d = null;
        }
        return toolkit.lut(byArray, n, n2, lookupTable, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] lut(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull LookupTable table) {
        return Toolkit.lut$default(this, inputArray, sizeX, sizeY, table, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap lut(@NotNull Bitmap inputBitmap, @NotNull LookupTable table, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        ToolkitKt.validateBitmap$default("lut", inputBitmap, false, 4, null);
        ToolkitKt.validateRestriction("lut", inputBitmap, restriction);
        Bitmap bitmap = outputBitmap = ToolkitKt.createCompatibleBitmap(inputBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeLutBitmap(nativeHandle, inputBitmap, bitmap, table.getRed(), table.getGreen(), table.getBlue(), table.getAlpha(), restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap lut$default(Toolkit toolkit, Bitmap bitmap, LookupTable lookupTable, Range2d range2d, int n, Object object) {
        if ((n & 4) != 0) {
            range2d = null;
        }
        return toolkit.lut(bitmap, lookupTable, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap lut(@NotNull Bitmap inputBitmap, @NotNull LookupTable table) {
        return Toolkit.lut$default(this, inputBitmap, table, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] lut3d(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull Rgba3dArray cube, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        boolean bl = inputArray.length >= sizeX * sizeY * 4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit lut3d. inputArray is too small for the given dimensions. " + sizeX + '*' + sizeY + "*4 < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = cube.getSizeX() >= 2 && cube.getSizeY() >= 2 && cube.getSizeZ() >= 2 && cube.getSizeX() <= 256 && cube.getSizeY() <= 256 && cube.getSizeZ() <= 256;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "RenderScript Toolkit lut3d. The dimensions of the cube should be between 2 and 256. " + '(' + cube.getSizeX() + ", " + cube.getSizeY() + ", " + cube.getSizeZ() + ") provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("lut3d", sizeX, sizeY, restriction);
        byte[] outputArray = new byte[inputArray.length];
        this.nativeLut3d(nativeHandle, inputArray, outputArray, sizeX, sizeY, cube.getValues(), cube.getSizeX(), cube.getSizeY(), cube.getSizeZ(), restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] lut3d$default(Toolkit toolkit, byte[] byArray, int n, int n2, Rgba3dArray rgba3dArray, Range2d range2d, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            range2d = null;
        }
        return toolkit.lut3d(byArray, n, n2, rgba3dArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] lut3d(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull Rgba3dArray cube) {
        return Toolkit.lut3d$default(this, inputArray, sizeX, sizeY, cube, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap lut3d(@NotNull Bitmap inputBitmap, @NotNull Rgba3dArray cube, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkNotNullParameter((Object)cube, (String)"cube");
        ToolkitKt.validateBitmap$default("lut3d", inputBitmap, false, 4, null);
        ToolkitKt.validateRestriction("lut3d", inputBitmap, restriction);
        Bitmap bitmap = outputBitmap = ToolkitKt.createCompatibleBitmap(inputBitmap);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeLut3dBitmap(nativeHandle, inputBitmap, bitmap, cube.getValues(), cube.getSizeX(), cube.getSizeY(), cube.getSizeZ(), restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap lut3d$default(Toolkit toolkit, Bitmap bitmap, Rgba3dArray rgba3dArray, Range2d range2d, int n, Object object) {
        if ((n & 4) != 0) {
            range2d = null;
        }
        return toolkit.lut3d(bitmap, rgba3dArray, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap lut3d(@NotNull Bitmap inputBitmap, @NotNull Rgba3dArray cube) {
        return Toolkit.lut3d$default(this, inputBitmap, cube, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] resize(@NotNull byte[] inputArray, int vectorSize, int inputSizeX, int inputSizeY, int outputSizeX, int outputSizeY, @Nullable Range2d restriction) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        int n = vectorSize;
        n = 1 <= n && 4 >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "RenderScript Toolkit resize. The vectorSize should be between 1 and 4. " + vectorSize + " provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = inputArray.length >= inputSizeX * inputSizeY * vectorSize ? 1 : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit resize. inputArray is too small for the given dimensions. " + inputSizeX + '*' + inputSizeY + '*' + vectorSize + " < " + inputArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ToolkitKt.validateRestriction("resize", outputSizeX, outputSizeY, restriction);
        byte[] outputArray = new byte[outputSizeX * outputSizeY * ToolkitKt.paddedSize(vectorSize)];
        this.nativeResize(nativeHandle, inputArray, vectorSize, inputSizeX, inputSizeY, outputArray, outputSizeX, outputSizeY, restriction);
        return outputArray;
    }

    public static /* synthetic */ byte[] resize$default(Toolkit toolkit, byte[] byArray, int n, int n2, int n3, int n4, int n5, Range2d range2d, int n6, Object object) {
        if ((n6 & 0x40) != 0) {
            range2d = null;
        }
        return toolkit.resize(byArray, n, n2, n3, n4, n5, range2d);
    }

    @JvmOverloads
    @NotNull
    public final byte[] resize(@NotNull byte[] inputArray, int vectorSize, int inputSizeX, int inputSizeY, int outputSizeX, int outputSizeY) {
        return Toolkit.resize$default(this, inputArray, vectorSize, inputSizeX, inputSizeY, outputSizeX, outputSizeY, null, 64, null);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap resize(@NotNull Bitmap inputBitmap, int outputSizeX, int outputSizeY, @Nullable Range2d restriction) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputBitmap, (String)"inputBitmap");
        ToolkitKt.validateBitmap$default("resize", inputBitmap, false, 4, null);
        ToolkitKt.validateRestriction("resize", outputSizeX, outputSizeY, restriction);
        Bitmap bitmap = outputBitmap = Bitmap.createBitmap((int)outputSizeX, (int)outputSizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeResizeBitmap(nativeHandle, inputBitmap, bitmap, restriction);
        return outputBitmap;
    }

    public static /* synthetic */ Bitmap resize$default(Toolkit toolkit, Bitmap bitmap, int n, int n2, Range2d range2d, int n3, Object object) {
        if ((n3 & 8) != 0) {
            range2d = null;
        }
        return toolkit.resize(bitmap, n, n2, range2d);
    }

    @JvmOverloads
    @NotNull
    public final Bitmap resize(@NotNull Bitmap inputBitmap, int outputSizeX, int outputSizeY) {
        return Toolkit.resize$default(this, inputBitmap, outputSizeX, outputSizeY, null, 8, null);
    }

    @NotNull
    public final byte[] yuvToRgb(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull YuvFormat format) {
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        boolean bl = sizeX % 2 == 0 && sizeY % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit yuvToRgb. Non-even dimensions are not supported. " + sizeX + " and " + sizeY + " were provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] outputArray = new byte[sizeX * sizeY * 4];
        this.nativeYuvToRgb(nativeHandle, inputArray, outputArray, sizeX, sizeY, format.getValue());
        return outputArray;
    }

    @NotNull
    public final Bitmap yuvToRgbBitmap(@NotNull byte[] inputArray, int sizeX, int sizeY, @NotNull YuvFormat format) {
        Bitmap outputBitmap;
        Intrinsics.checkNotNullParameter((Object)inputArray, (String)"inputArray");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        boolean bl = sizeX % 2 == 0 && sizeY % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "RenderScript Toolkit yuvToRgbBitmap. Non-even dimensions are not supported. " + sizeX + " and " + sizeY + " were provided.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Bitmap bitmap = outputBitmap = Bitmap.createBitmap((int)sizeX, (int)sizeY, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"outputBitmap");
        this.nativeYuvToRgbBitmap(nativeHandle, inputArray, sizeX, sizeY, bitmap, format.getValue());
        return outputBitmap;
    }

    public final void shutdown() {
        this.destroyNative(nativeHandle);
        nativeHandle = 0L;
    }

    private final native long createNative();

    private final native void destroyNative(long var1);

    private final native void nativeBlend(long var1, int var3, byte[] var4, byte[] var5, int var6, int var7, Range2d var8);

    private final native void nativeBlendBitmap(long var1, int var3, Bitmap var4, Bitmap var5, Range2d var6);

    private final native void nativeBlur(long var1, byte[] var3, int var4, int var5, int var6, int var7, byte[] var8, Range2d var9);

    private final native void nativeBlurBitmap(long var1, Bitmap var3, Bitmap var4, int var5, Range2d var6);

    private final native void nativeColorMatrix(long var1, byte[] var3, int var4, int var5, int var6, byte[] var7, int var8, float[] var9, float[] var10, Range2d var11);

    private final native void nativeColorMatrixBitmap(long var1, Bitmap var3, Bitmap var4, float[] var5, float[] var6, Range2d var7);

    private final native void nativeConvolve(long var1, byte[] var3, int var4, int var5, int var6, byte[] var7, float[] var8, Range2d var9);

    private final native void nativeConvolveBitmap(long var1, Bitmap var3, Bitmap var4, float[] var5, Range2d var6);

    private final native void nativeHistogram(long var1, byte[] var3, int var4, int var5, int var6, int[] var7, Range2d var8);

    private final native void nativeHistogramBitmap(long var1, Bitmap var3, int[] var4, Range2d var5);

    private final native void nativeHistogramDot(long var1, byte[] var3, int var4, int var5, int var6, int[] var7, float[] var8, Range2d var9);

    private final native void nativeHistogramDotBitmap(long var1, Bitmap var3, int[] var4, float[] var5, Range2d var6);

    private final native void nativeLut(long var1, byte[] var3, byte[] var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10, Range2d var11);

    private final native void nativeLutBitmap(long var1, Bitmap var3, Bitmap var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, Range2d var9);

    private final native void nativeLut3d(long var1, byte[] var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9, int var10, Range2d var11);

    private final native void nativeLut3dBitmap(long var1, Bitmap var3, Bitmap var4, byte[] var5, int var6, int var7, int var8, Range2d var9);

    private final native void nativeResize(long var1, byte[] var3, int var4, int var5, int var6, byte[] var7, int var8, int var9, Range2d var10);

    private final native void nativeResizeBitmap(long var1, Bitmap var3, Bitmap var4, Range2d var5);

    private final native void nativeYuvToRgb(long var1, byte[] var3, byte[] var4, int var5, int var6, int var7);

    private final native void nativeYuvToRgbBitmap(long var1, byte[] var3, int var4, int var5, Bitmap var6, int var7);

    private Toolkit() {
    }

    static {
        Toolkit toolkit;
        INSTANCE = toolkit = new Toolkit();
        System.loadLibrary("renderscript-toolkit");
        nativeHandle = toolkit.createNative();
    }
}

