/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins.png;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import org.apache.harmony.x.imageio.plugins.ImageType;
import org.apache.harmony.x.imageio.plugins.png.PNGImageReaderSpi;
import org.apache.harmony.x.imageio.plugins.png.PNGImageWriter;

public class PNGImageWriterSpi
extends ImageWriterSpi {
    public PNGImageWriterSpi() {
        super("Apache Harmony", "1.0", ImageType.PNG.getNames(), ImageType.PNG.getSuffixes(), ImageType.PNG.getMimeTypes(), PNGImageWriter.class.getName(), STANDARD_OUTPUT_TYPE, new String[]{PNGImageReaderSpi.class.getName()}, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        boolean canEncode = true;
        int numBands = type.getSampleModel().getNumBands();
        ColorModel colorModel = type.getColorModel();
        int bitDepth = colorModel.getPixelSize() / numBands;
        if (colorModel instanceof IndexColorModel) {
            if (bitDepth != 1 && bitDepth != 2 && bitDepth != 4 && bitDepth != 8) {
                canEncode = false;
            }
            if (numBands != 1) {
                canEncode = false;
            }
        } else if (numBands == 1) {
            if (bitDepth != 1 && bitDepth != 2 && bitDepth != 4 && bitDepth != 8 && bitDepth != 16) {
                canEncode = false;
            }
        } else if (numBands == 2) {
            if (bitDepth != 8 && bitDepth != 16) {
                canEncode = false;
            }
        } else if (numBands == 3) {
            if (bitDepth != 8 && bitDepth != 16) {
                canEncode = false;
            }
        } else if (numBands == 4 && bitDepth != 8 && bitDepth != 16) {
            canEncode = false;
        }
        return canEncode;
    }

    @Override
    public ImageWriter createWriterInstance(Object arg0) throws IOException {
        return new PNGImageWriter(this);
    }

    @Override
    public String getDescription(Locale arg0) {
        return "PNG image encoder";
    }
}

