/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.metadata;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class IIOMetadataUtils {
    private IIOMetadataUtils() {
    }

    public static IIOMetadataFormat instantiateMetadataFormat(String formatName, boolean standardFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        Class<?> cls;
        if (formatName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.89"));
        }
        if (formatName.equals("javax_imageio_1.0") && standardFormatSupported) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        String className = null;
        if (formatName.equals(nativeMetadataFormatName)) {
            className = nativeMetadataFormatClassName;
        } else if (extraMetadataFormatNames != null) {
            for (int i = 0; i < extraMetadataFormatNames.length; ++i) {
                if (!formatName.equals(extraMetadataFormatNames[i])) continue;
                className = extraMetadataFormatClassNames[i];
                break;
            }
        }
        if (className == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.8A"));
        }
        ClassLoader contextClassloader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            cls = Class.forName(className, true, contextClassloader);
        }
        catch (ClassNotFoundException e) {
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                throw new IllegalStateException(Messages.getString("imageio.8B"));
            }
        }
        try {
            Method getInstance = cls.getMethod("getInstance", new Class[0]);
            return (IIOMetadataFormat)getInstance.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            IllegalStateException e1 = new IllegalStateException(Messages.getString("imageio.8B"));
            e1.initCause(e);
            throw e1;
        }
    }
}

