/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.render;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.MultiRectArea;
import org.apache.harmony.awt.gl.Surface;
import org.apache.harmony.awt.gl.XORComposite;
import org.apache.harmony.awt.gl.render.Blitter;
import org.apache.harmony.awt.internal.nls.Messages;

public class JavaBlitter
implements Blitter {
    static byte[][] mulLUT;
    static byte[][] divLUT;
    static final int AlphaCompositeMode = 1;
    static final int XORMode = 2;
    static final JavaBlitter inst;

    public static JavaBlitter getInstance() {
        return inst;
    }

    @Override
    public void blit(int srcX, int srcY, Surface srcSurf, int dstX, int dstY, Surface dstSurf, int width, int height, AffineTransform sysxform, AffineTransform xform, Composite comp, Color bgcolor, MultiRectArea clip) {
        if (xform == null) {
            this.blit(srcX, srcY, srcSurf, dstX, dstY, dstSurf, width, height, sysxform, comp, bgcolor, clip);
        } else {
            double scaleX = xform.getScaleX();
            double scaleY = xform.getScaleY();
            double scaledX = (double)dstX / scaleX;
            double scaledY = (double)dstY / scaleY;
            AffineTransform at = new AffineTransform();
            at.setToTranslation(scaledX, scaledY);
            xform.concatenate(at);
            sysxform.concatenate(xform);
            this.blit(srcX, srcY, srcSurf, 0, 0, dstSurf, width, height, sysxform, comp, bgcolor, clip);
        }
    }

    @Override
    public void blit(int srcX, int srcY, Surface srcSurf, int dstX, int dstY, Surface dstSurf, int width, int height, AffineTransform sysxform, Composite comp, Color bgcolor, MultiRectArea clip) {
        if (sysxform == null) {
            sysxform = new AffineTransform();
        }
        int type = sysxform.getType();
        switch (type) {
            case 1: {
                dstX = (int)((double)dstX + sysxform.getTranslateX());
                dstY = (int)((double)dstY + sysxform.getTranslateY());
            }
            case 0: {
                this.blit(srcX, srcY, srcSurf, dstX, dstY, dstSurf, width, height, comp, bgcolor, clip);
                break;
            }
            default: {
                int srcW = srcSurf.getWidth();
                int srcH = srcSurf.getHeight();
                int w = srcX + width < srcW ? width : srcW - srcX;
                int h = srcY + height < srcH ? height : srcH - srcY;
                ColorModel srcCM = srcSurf.getColorModel();
                Raster srcR = srcSurf.getRaster().createChild(srcX, srcY, w, h, 0, 0, null);
                ColorModel dstCM = dstSurf.getColorModel();
                WritableRaster dstR = dstSurf.getRaster();
                this.transformedBlit(srcCM, srcR, 0, 0, dstCM, dstR, dstX, dstY, w, h, sysxform, comp, bgcolor, clip);
                Rectangle dirtyReg = JavaBlitter.getBounds2D(sysxform, new Rectangle(dstX, dstY, w, h)).getBounds();
                Rectangle bounds = new Rectangle(dstSurf.getWidth(), dstSurf.getHeight()).getBounds();
                dstSurf.addDirtyRegion(bounds.intersection(dirtyReg));
            }
        }
    }

    @Override
    public void blit(int srcX, int srcY, Surface srcSurf, int dstX, int dstY, Surface dstSurf, int width, int height, Composite comp, Color bgcolor, MultiRectArea clip) {
        this.javaBlt(srcX, srcY, srcSurf.getWidth(), srcSurf.getHeight(), srcSurf.getColorModel(), srcSurf.getRaster(), dstX, dstY, dstSurf.getWidth(), dstSurf.getHeight(), dstSurf.getColorModel(), dstSurf.getRaster(), width, height, comp, bgcolor, clip);
        dstSurf.addDirtyRegion(new Rectangle(dstX, dstY, width, height));
    }

    public void javaBlt(int srcX, int srcY, int srcW, int srcH, ColorModel srcCM, Raster srcRast, int dstX, int dstY, int dstW, int dstH, ColorModel dstCM, WritableRaster dstRast, int width, int height, Composite comp, Color bgcolor, MultiRectArea clip) {
        int srcX2 = srcW - 1;
        int srcY2 = srcH - 1;
        int dstX2 = dstW - 1;
        int dstY2 = dstH - 1;
        if (srcX < 0) {
            width += srcX;
            srcX = 0;
        }
        if (srcY < 0) {
            height += srcY;
            srcY = 0;
        }
        if (dstX < 0) {
            width += dstX;
            srcX -= dstX;
            dstX = 0;
        }
        if (dstY < 0) {
            height += dstY;
            srcY -= dstY;
            dstY = 0;
        }
        if (srcX > srcX2 || srcY > srcY2) {
            return;
        }
        if (dstX > dstX2 || dstY > dstY2) {
            return;
        }
        if (srcX + width > srcX2) {
            width = srcX2 - srcX + 1;
        }
        if (srcY + height > srcY2) {
            height = srcY2 - srcY + 1;
        }
        if (dstX + width > dstX2) {
            width = dstX2 - dstX + 1;
        }
        if (dstY + height > dstY2) {
            height = dstY2 - dstY + 1;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int[] clipRects = clip != null ? clip.rect : new int[]{5, 0, 0, dstW - 1, dstH - 1};
        boolean isAlphaComp = false;
        int rule = 0;
        float alpha = 0.0f;
        boolean isXORComp = false;
        Color xorcolor = null;
        CompositeContext cont = null;
        if (comp instanceof AlphaComposite) {
            isAlphaComp = true;
            AlphaComposite ac = (AlphaComposite)comp;
            rule = ac.getRule();
            alpha = ac.getAlpha();
        } else if (comp instanceof XORComposite) {
            isXORComp = true;
            XORComposite xcomp = (XORComposite)comp;
            xorcolor = xcomp.getXORColor();
        } else {
            cont = comp.createContext(srcCM, dstCM, null);
        }
        for (int i = 1; i < clipRects[0]; i += 4) {
            int _sx = srcX;
            int _sy = srcY;
            int _dx = dstX;
            int _dy = dstY;
            int _w = width;
            int _h = height;
            int cx = clipRects[i];
            int cy = clipRects[i + 1];
            int cx2 = clipRects[i + 2];
            int cy2 = clipRects[i + 3];
            if (_dx > cx2 || _dy > cy2 || dstX2 < cx || dstY2 < cy) continue;
            if (cx > _dx) {
                int shx = cx - _dx;
                _w -= shx;
                _dx = cx;
                _sx += shx;
            }
            if (cy > _dy) {
                int shy = cy - _dy;
                _h -= shy;
                _dy = cy;
                _sy += shy;
            }
            if (_dx + _w > cx2 + 1) {
                _w = cx2 - _dx + 1;
            }
            if (_dy + _h > cy2 + 1) {
                _h = cy2 - _dy + 1;
            }
            if (_sx > srcX2 || _sy > srcY2) continue;
            if (isAlphaComp) {
                this.alphaCompose(_sx, _sy, srcCM, srcRast, _dx, _dy, dstCM, dstRast, _w, _h, rule, alpha, bgcolor);
                continue;
            }
            if (isXORComp) {
                this.xorCompose(_sx, _sy, srcCM, srcRast, _dx, _dy, dstCM, dstRast, _w, _h, xorcolor);
                continue;
            }
            Raster sr = srcRast.createChild(_sx, _sy, _w, _h, 0, 0, null);
            WritableRaster dr = dstRast.createWritableChild(_dx, _dy, _w, _h, 0, 0, null);
            cont.compose(sr, dr, dr);
        }
    }

    void alphaCompose(int srcX, int srcY, ColorModel srcCM, Raster srcRast, int dstX, int dstY, ColorModel dstCM, WritableRaster dstRast, int width, int height, int rule, float alpha, Color bgcolor) {
        int srcConstAllpha = (int)(alpha * 255.0f + 0.5f);
        int dstRGB = 0;
        if (bgcolor != null) {
            dstRGB = bgcolor.getRGB();
        }
        int sy = srcY;
        int dy = dstY;
        int srcYMax = srcY + height;
        while (sy < srcYMax) {
            int sx = srcX;
            int dx = dstX;
            int srcXMax = srcX + width;
            while (sx < srcXMax) {
                Object dstPixel;
                Object srcPixel = srcRast.getDataElements(sx, sy, null);
                int srcRGB = srcCM.getRGB(srcPixel);
                if (bgcolor == null) {
                    dstPixel = dstRast.getDataElements(dx, dy, null);
                    dstRGB = dstCM.getRGB(dstPixel);
                }
                dstRGB = this.compose(srcRGB, srcCM.isAlphaPremultiplied(), dstRGB, dstCM.hasAlpha(), dstCM.isAlphaPremultiplied(), rule, srcConstAllpha);
                dstPixel = dstCM.getDataElements(dstRGB, null);
                dstRast.setDataElements(dx, dy, dstPixel);
                ++sx;
                ++dx;
            }
            ++sy;
            ++dy;
        }
    }

    void xorCompose(int srcX, int srcY, ColorModel srcCM, Raster srcRast, int dstX, int dstY, ColorModel dstCM, WritableRaster dstRast, int width, int height, Color xorcolor) {
        int xorRGB = xorcolor.getRGB();
        int sy = srcY;
        int dy = dstY;
        int srcYMax = srcY + height;
        while (sy < srcYMax) {
            int sx = srcX;
            int dx = dstX;
            int srcXMax = srcX + width;
            while (sx < srcXMax) {
                Object srcPixel = srcRast.getDataElements(sx, sy, null);
                Object dstPixel = dstRast.getDataElements(dx, dy, null);
                int srcRGB = srcCM.getRGB(srcPixel);
                int dstRGB = dstCM.getRGB(dstPixel);
                dstRGB = srcRGB ^ xorRGB ^ dstRGB;
                dstRGB = 0xFF000000 | dstRGB;
                dstPixel = dstCM.getDataElements(dstRGB, dstPixel);
                dstRast.setDataElements(dx, dy, dstPixel);
                ++sx;
                ++dx;
            }
            ++sy;
            ++dy;
        }
    }

    private void transformedBlit(ColorModel srcCM, Raster srcR, int srcX, int srcY, ColorModel dstCM, WritableRaster dstR, int dstX, int dstY, int width, int height, AffineTransform at, Composite comp, Color bgcolor, MultiRectArea clip) {
        Rectangle srcBounds = new Rectangle(srcX, srcY, width, height);
        Rectangle dstBlitBounds = new Rectangle(dstX, dstY, width, height);
        Rectangle transSrcBounds = JavaBlitter.getBounds2D(at, srcBounds).getBounds();
        Rectangle transDstBlitBounds = JavaBlitter.getBounds2D(at, dstBlitBounds).getBounds();
        int translateX = transDstBlitBounds.x - transSrcBounds.x;
        int translateY = transDstBlitBounds.y - transSrcBounds.y;
        AffineTransform inv = null;
        try {
            inv = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        double[] m = new double[6];
        inv.getMatrix(m);
        int[] clipRects = clip != null ? clip.rect : new int[]{5, 0, 0, dstR.getWidth(), dstR.getHeight()};
        int compType = 0;
        int srcConstAlpha = 0;
        int rule = 0;
        int bgRGB = bgcolor == null ? 0 : bgcolor.getRGB();
        int srcRGB = 0;
        int dstRGB = 0;
        Object srcVal = null;
        Object dstVal = null;
        if (comp instanceof AlphaComposite) {
            compType = 1;
            AlphaComposite ac = (AlphaComposite)comp;
            rule = ac.getRule();
            srcConstAlpha = (int)(ac.getAlpha() * 255.0f + 0.5f);
        } else if (comp instanceof XORComposite) {
            compType = 2;
            XORComposite xor = (XORComposite)comp;
            bgRGB = xor.getXORColor().getRGB();
        }
        for (int i = 1; i < clipRects[0]; i += 4) {
            Rectangle dstBounds = new Rectangle(clipRects[i], clipRects[i + 1], 0, 0);
            dstBounds.add(clipRects[i + 2] + 1, clipRects[i + 1]);
            dstBounds.add(clipRects[i + 2] + 1, clipRects[i + 3] + 1);
            dstBounds.add(clipRects[i], clipRects[i + 3] + 1);
            Rectangle bounds = dstBounds.intersection(transDstBlitBounds);
            int minSrcX = srcBounds.x;
            int minSrcY = srcBounds.y;
            int maxSrcX = minSrcX + srcBounds.width;
            int maxSrcY = minSrcY + srcBounds.height;
            int minX = bounds.x;
            int minY = bounds.y;
            int maxX = minX + bounds.width;
            int maxY = minY + bounds.height;
            int hx = (int)(m[0] * 256.0 + 0.5);
            int hy = (int)(m[1] * 256.0 + 0.5);
            int vx = (int)(m[2] * 256.0 + 0.5);
            int vy = (int)(m[3] * 256.0 + 0.5);
            int sx = (int)((m[4] + m[0] * (double)(bounds.x - translateX) + m[2] * (double)(bounds.y - translateY)) * 256.0 + 0.5);
            int sy = (int)((m[5] + m[1] * (double)(bounds.x - translateX) + m[3] * (double)(bounds.y - translateY)) * 256.0 + 0.5);
            vx -= hx * bounds.width;
            vy -= hy * bounds.width;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    int px = sx >> 8;
                    int py = sy >> 8;
                    if (px >= minSrcX && py >= minSrcY && px < maxSrcX && py < maxSrcY) {
                        switch (compType) {
                            case 1: {
                                srcVal = srcR.getDataElements(px, py, null);
                                srcRGB = srcCM.getRGB(srcVal);
                                if (bgcolor != null) {
                                    dstRGB = bgRGB;
                                } else {
                                    dstVal = dstR.getDataElements(x, y, null);
                                    dstRGB = dstCM.getRGB(dstVal);
                                }
                                dstRGB = this.compose(srcRGB, srcCM.isAlphaPremultiplied(), dstRGB, dstCM.hasAlpha(), dstCM.isAlphaPremultiplied(), rule, srcConstAlpha);
                                dstVal = dstCM.getDataElements(dstRGB, null);
                                dstR.setDataElements(x, y, dstVal);
                                break;
                            }
                            case 2: {
                                srcVal = srcR.getDataElements(px, py, null);
                                srcRGB = srcCM.getRGB(srcVal);
                                dstVal = dstR.getDataElements(x, y, null);
                                dstRGB = dstCM.getRGB(dstVal);
                                dstRGB = srcRGB ^ bgRGB;
                                dstRGB = 0xFF000000 | dstRGB;
                                dstVal = dstCM.getDataElements(dstRGB, null);
                                dstR.setDataElements(x, y, dstVal);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(Messages.getString("awt.37", comp.getClass()));
                            }
                        }
                    }
                    sx += hx;
                    sy += hy;
                }
                sx += vx;
                sy += vy;
            }
        }
    }

    public static Rectangle2D getBounds2D(AffineTransform at, Rectangle r) {
        int x = r.x;
        int y = r.y;
        int width = r.width;
        int height = r.height;
        float[] corners = new float[]{x, y, x + width + 1, y, x + width + 1, y + height + 1, x, y + height + 1};
        at.transform(corners, 0, corners, 0, 4);
        Rectangle2D.Float bounds = new Rectangle2D.Float(corners[0], corners[1], 0.0f, 0.0f);
        bounds.add(corners[2], corners[3]);
        bounds.add(corners[4], corners[5]);
        bounds.add(corners[6], corners[7]);
        return bounds;
    }

    private int compose(int srcRGB, boolean isSrcAlphaPre, int dstRGB, boolean dstHasAlpha, boolean isDstAlphaPre, int rule, int srcConstAlpha) {
        int sa = srcRGB >> 24 & 0xFF;
        int sr = srcRGB >> 16 & 0xFF;
        int sg = srcRGB >> 8 & 0xFF;
        int sb = srcRGB & 0xFF;
        if (isSrcAlphaPre) {
            sa = mulLUT[srcConstAlpha][sa] & 0xFF;
            sr = mulLUT[srcConstAlpha][sr] & 0xFF;
            sg = mulLUT[srcConstAlpha][sg] & 0xFF;
            sb = mulLUT[srcConstAlpha][sb] & 0xFF;
        } else {
            sa = mulLUT[srcConstAlpha][sa] & 0xFF;
            sr = mulLUT[sa][sr] & 0xFF;
            sg = mulLUT[sa][sg] & 0xFF;
            sb = mulLUT[sa][sb] & 0xFF;
        }
        int da = dstRGB >> 24 & 0xFF;
        int dr = dstRGB >> 16 & 0xFF;
        int dg = dstRGB >> 8 & 0xFF;
        int db = dstRGB & 0xFF;
        if (!isDstAlphaPre) {
            dr = mulLUT[da][dr] & 0xFF;
            dg = mulLUT[da][dg] & 0xFF;
            db = mulLUT[da][db] & 0xFF;
        }
        int Fs = 0;
        int Fd = 0;
        switch (rule) {
            case 1: {
                break;
            }
            case 9: {
                Fd = 255;
                break;
            }
            case 11: {
                Fs = 255 - da;
                Fd = sa;
                break;
            }
            case 6: {
                Fd = sa;
                break;
            }
            case 8: {
                Fd = 255 - sa;
                break;
            }
            case 4: {
                Fs = 255 - da;
                Fd = 255;
                break;
            }
            case 2: {
                Fs = 255;
                break;
            }
            case 10: {
                Fs = da;
                Fd = 255 - sa;
                break;
            }
            case 5: {
                Fs = da;
                break;
            }
            case 7: {
                Fs = 255 - da;
                break;
            }
            case 3: {
                Fs = 255;
                Fd = 255 - sa;
                break;
            }
            case 12: {
                Fs = 255 - da;
                Fd = 255 - sa;
            }
        }
        dr = (mulLUT[sr][Fs] & 0xFF) + (mulLUT[dr][Fd] & 0xFF);
        dg = (mulLUT[sg][Fs] & 0xFF) + (mulLUT[dg][Fd] & 0xFF);
        db = (mulLUT[sb][Fs] & 0xFF) + (mulLUT[db][Fd] & 0xFF);
        da = (mulLUT[sa][Fs] & 0xFF) + (mulLUT[da][Fd] & 0xFF);
        if (!isDstAlphaPre && da != 255) {
            dr = divLUT[da][dr] & 0xFF;
            dg = divLUT[da][dg] & 0xFF;
            db = divLUT[da][db] & 0xFF;
        }
        if (!dstHasAlpha) {
            da = 255;
        }
        dstRGB = da << 24 | dr << 16 | dg << 8 | db;
        return dstRGB;
    }

    static {
        int j;
        int i;
        mulLUT = new byte[256][256];
        for (i = 0; i < 256; ++i) {
            for (j = 0; j < 256; ++j) {
                JavaBlitter.mulLUT[i][j] = (byte)((float)(i * j) / 255.0f + 0.5f);
            }
        }
        divLUT = new byte[256][256];
        for (i = 1; i < 256; ++i) {
            for (j = 0; j < i; ++j) {
                JavaBlitter.divLUT[i][j] = (byte)((float)j / 255.0f / ((float)i / 255.0f) * 255.0f + 0.5f);
            }
            for (j = i; j < 256; ++j) {
                JavaBlitter.divLUT[i][j] = -1;
            }
        }
        inst = new JavaBlitter();
    }
}

