/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.render;

import org.apache.harmony.awt.gl.MultiRectArea;

public class JavaArcRasterizer {
    static void addX0LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int x1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x2 = line[i];
            int y = cy + (b - i);
            if (x1 <= finish && x2 >= start) {
                mra.addRect(cx + Math.max(x1, start), y, cx + Math.min(x2, finish), y);
            }
            x1 = x2 + 1;
        }
    }

    static void addX1LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int x1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x2 = line[i];
            int y = cy - (b - i);
            if (x1 <= finish && x2 >= start) {
                mra.addRect(cx + Math.max(x1, start), y, cx + Math.min(x2, finish), y);
            }
            x1 = x2 + 1;
        }
    }

    static void addX2LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int x1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x2 = line[i];
            int y = cy - (b - i);
            if (x1 <= finish && x2 >= start) {
                mra.addRect(cx - Math.min(x2, finish), y, cx - Math.max(x1, start), y);
            }
            x1 = x2 + 1;
        }
    }

    static void addX3LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int x1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x2 = line[i];
            int y = cy + (b - i);
            if (x1 <= finish && x2 >= start) {
                mra.addRect(cx - Math.min(x2, finish), y, cx - Math.max(x1, start), y);
            }
            x1 = x2 + 1;
        }
    }

    static void addY0LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int y1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x = cx + (b - i);
            int y2 = line[i];
            if (y1 <= finish && y2 >= start) {
                mra.addRect(x, cy + Math.max(y1, start), x, cy + Math.min(y2, finish));
            }
            y1 = y2 + 1;
        }
    }

    static void addY1LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int y1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x = cx - (b - i);
            int y2 = line[i];
            if (y1 <= finish && y2 >= start) {
                mra.addRect(x, cy + Math.max(y1, start), x, cy + Math.min(y2, finish));
            }
            y1 = y2 + 1;
        }
    }

    static void addY2LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int y1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x = cx - (b - i);
            int y2 = line[i];
            if (y1 <= finish && y2 >= start) {
                mra.addRect(x, cy - Math.min(y2, finish), x, cy - Math.max(y1, start));
            }
            y1 = y2 + 1;
        }
    }

    static void addY3LineSeg(MultiRectArea mra, int[] line, int cx, int cy, int b, int start, int finish) {
        int y1 = 0;
        for (int i = 0; i < line.length; ++i) {
            int x = cx + (b - i);
            int y2 = line[i];
            if (y1 <= finish && y2 >= start) {
                mra.addRect(x, cy - Math.min(y2, finish), x, cy - Math.max(y1, start));
            }
            y1 = y2 + 1;
        }
    }

    static void addX0Line(MultiRectArea mra, int[] line, int cx, int cy, int b) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx + prev, cy + (b - i), cx + line[i], cy + (b - i));
            prev = line[i] + 1;
        }
    }

    static void addX1Line(MultiRectArea mra, int[] line, int cx, int cy, int b) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx + prev, cy - (b - i), cx + line[i], cy - (b - i));
            prev = line[i] + 1;
        }
    }

    static void addX2Line(MultiRectArea mra, int[] line, int cx, int cy, int b) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx - line[i], cy - (b - i), cx - prev, cy - (b - i));
            prev = line[i] + 1;
        }
    }

    static void addX3Line(MultiRectArea mra, int[] line, int cx, int cy, int b) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx - line[i], cy + (b - i), cx - prev, cy + (b - i));
            prev = line[i] + 1;
        }
    }

    static void addY0Line(MultiRectArea mra, int[] line, int cx, int cy, int a) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx + (a - i), cy + prev, cx + (a - i), cy + line[i]);
            prev = line[i] + 1;
        }
    }

    static void addY1Line(MultiRectArea mra, int[] line, int cx, int cy, int a) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx - (a - i), cy + prev, cx - (a - i), cy + line[i]);
            prev = line[i] + 1;
        }
    }

    static void addY2Line(MultiRectArea mra, int[] line, int cx, int cy, int a) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx - (a - i), cy - line[i], cx - (a - i), cy - prev);
            prev = line[i] + 1;
        }
    }

    static void addY3Line(MultiRectArea mra, int[] line, int cx, int cy, int a) {
        int prev = 0;
        for (int i = 0; i < line.length; ++i) {
            mra.addRect(cx + (a - i), cy - line[i], cx + (a - i), cy - prev);
            prev = line[i] + 1;
        }
    }

    static double getNormAngle(double angle) {
        if ((angle -= Math.floor(angle / 360.0) * 360.0) < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    static int[] createLine(int a, int b, int xcount, int ycount) {
        int[] buf = new int[b - ycount + 1];
        int d = a * a + 2 * b * b - 2 * a * a * b;
        int x = 0;
        int y = b;
        while (y >= ycount) {
            if (d < 0) {
                d += b * b * (4 * x + 6);
            } else {
                buf[b - y] = x;
                d = d + b * b * (4 * x + 6) + 4 * a * a * (1 - y);
                --y;
            }
            ++x;
        }
        return buf;
    }

    static void addSeg(MultiRectArea mra, int cx1, int cy1, int cx2, int cy2, int a, int b, int[] xline, int[] yline, int[] bounds) {
        switch (bounds[0]) {
            case 0: {
                JavaArcRasterizer.addY3LineSeg(mra, yline, cx2, cy1, a, bounds[1], bounds[2]);
                break;
            }
            case 1: {
                JavaArcRasterizer.addX1LineSeg(mra, xline, cx2, cy1, b, bounds[1], bounds[2]);
                break;
            }
            case 2: {
                JavaArcRasterizer.addX2LineSeg(mra, xline, cx1, cy1, b, bounds[1], bounds[2]);
                break;
            }
            case 3: {
                JavaArcRasterizer.addY2LineSeg(mra, yline, cx1, cy1, a, bounds[1], bounds[2]);
                break;
            }
            case 4: {
                JavaArcRasterizer.addY1LineSeg(mra, yline, cx1, cy2, a, bounds[1], bounds[2]);
                break;
            }
            case 5: {
                JavaArcRasterizer.addX3LineSeg(mra, xline, cx1, cy2, b, bounds[1], bounds[2]);
                break;
            }
            case 6: {
                JavaArcRasterizer.addX0LineSeg(mra, xline, cx2, cy2, b, bounds[1], bounds[2]);
                break;
            }
            case 7: {
                JavaArcRasterizer.addY0LineSeg(mra, yline, cx2, cy2, a, bounds[1], bounds[2]);
            }
        }
    }

    static int[] getSegment1(double angle, int ax, int ay, int xcount, int ycount) {
        int[] bounds = new int[3];
        switch ((int)(angle / 90.0)) {
            case 0: {
                if (xcount < ax) {
                    bounds[0] = 0;
                    bounds[1] = -ay;
                    bounds[2] = ycount;
                    break;
                }
                bounds[0] = 1;
                bounds[1] = 0;
                bounds[2] = ax;
                break;
            }
            case 1: {
                if (xcount > -ax) {
                    bounds[0] = 2;
                    bounds[1] = -ax;
                    bounds[2] = xcount;
                    break;
                }
                bounds[0] = 3;
                bounds[1] = 0;
                bounds[2] = -ay;
                break;
            }
            case 2: {
                if (xcount < -ax) {
                    bounds[0] = 4;
                    bounds[1] = ay;
                    bounds[2] = ycount;
                    break;
                }
                bounds[0] = 5;
                bounds[1] = 0;
                bounds[2] = -ax;
                break;
            }
            case 3: {
                if (xcount > ax) {
                    bounds[0] = 6;
                    bounds[1] = ax;
                    bounds[2] = xcount;
                    break;
                }
                bounds[0] = 7;
                bounds[1] = 0;
                bounds[2] = ay;
            }
        }
        return bounds;
    }

    static int[] getSegment2(double angle, int ax, int ay, int xcount, int ycount) {
        int[] bounds = new int[3];
        switch ((int)(angle / 90.0)) {
            case 0: {
                if (xcount < ax) {
                    bounds[0] = 0;
                    bounds[1] = 0;
                    bounds[2] = -ay;
                    break;
                }
                bounds[0] = 1;
                bounds[1] = ax;
                bounds[2] = xcount;
                break;
            }
            case 1: {
                if (xcount > -ax) {
                    bounds[0] = 2;
                    bounds[1] = 0;
                    bounds[2] = -ax;
                    break;
                }
                bounds[0] = 3;
                bounds[1] = -ay;
                bounds[2] = ycount;
                break;
            }
            case 2: {
                if (xcount < -ax) {
                    bounds[0] = 4;
                    bounds[1] = 0;
                    bounds[2] = ay;
                    break;
                }
                bounds[0] = 5;
                bounds[1] = -ax;
                bounds[2] = xcount;
                break;
            }
            case 3: {
                if (xcount > ax) {
                    bounds[0] = 6;
                    bounds[1] = 0;
                    bounds[2] = ax;
                    break;
                }
                bounds[0] = 7;
                bounds[1] = ay;
                bounds[2] = ycount;
            }
        }
        return bounds;
    }

    public static MultiRectArea rasterize(int x, int y, int width, int height, double angleStart, double angleExtent, MultiRectArea clip) {
        int ycount;
        int xcount;
        int cy2;
        MultiRectArea mra = new MultiRectArea(false);
        int cx2 = x + width / 2;
        int cx1 = cx2--;
        int cy1 = cy2 = y + height / 2;
        if (width % 2 == 0) {
            // empty if block
        }
        if (height % 2 == 0) {
            --cy2;
        }
        int a = width / 2;
        int b = height / 2;
        double c = Math.sqrt(a * a + b * b);
        if (a < b) {
            xcount = (int)Math.ceil((double)(a * a) / c);
            ycount = (int)Math.floor((double)(b * b) / c);
        } else {
            xcount = (int)Math.floor((double)(a * a) / c);
            ycount = (int)Math.ceil((double)(b * b) / c);
        }
        int[] xline = JavaArcRasterizer.createLine(a, b, xcount, ycount);
        int[] yline = JavaArcRasterizer.createLine(b, a, ycount, xcount);
        int i = xline.length;
        while (xline[--i] > xcount) {
            xline[i] = xcount;
        }
        i = yline.length;
        while (yline[--i] > ycount) {
            yline[i] = ycount;
        }
        if (Math.abs(angleExtent) >= 360.0) {
            JavaArcRasterizer.addX0Line(mra, xline, cx2, cy2, b);
            JavaArcRasterizer.addX1Line(mra, xline, cx2, cy1, b);
            JavaArcRasterizer.addX2Line(mra, xline, cx1, cy1, b);
            JavaArcRasterizer.addX3Line(mra, xline, cx1, cy2, b);
            JavaArcRasterizer.addY0Line(mra, yline, cx2, cy2, a);
            JavaArcRasterizer.addY1Line(mra, yline, cx1, cy2, a);
            JavaArcRasterizer.addY2Line(mra, yline, cx1, cy1, a);
            JavaArcRasterizer.addY3Line(mra, yline, cx2, cy1, a);
        } else {
            angleStart = JavaArcRasterizer.getNormAngle(angleStart);
            double angleFinish = JavaArcRasterizer.getNormAngle(angleStart + angleExtent);
            if (angleExtent < 0.0) {
                double tmp = angleStart;
                angleStart = angleFinish;
                angleFinish = tmp;
            }
            double radStart = -Math.toRadians(angleStart);
            double radFinish = -Math.toRadians(angleFinish);
            int ax1 = (int)((double)a * Math.cos(radStart));
            int ay1 = (int)((double)b * Math.sin(radStart));
            int ax2 = (int)((double)a * Math.cos(radFinish));
            int ay2 = (int)((double)b * Math.sin(radFinish));
            int[] seg1 = JavaArcRasterizer.getSegment1(angleStart, ax1, ay1, xcount, ycount);
            int[] seg2 = JavaArcRasterizer.getSegment2(angleFinish, ax2, ay2, xcount, ycount);
            if (angleStart < angleFinish && seg1[0] == seg2[0]) {
                if (seg1[0] % 2 == 0) {
                    seg1[2] = seg2[2];
                } else {
                    seg1[1] = seg2[1];
                }
                JavaArcRasterizer.addSeg(mra, cx1, cy1, cx2, cy2, a, b, xline, yline, seg1);
                return mra;
            }
            JavaArcRasterizer.addSeg(mra, cx1, cy1, cx2, cy2, a, b, xline, yline, seg1);
            JavaArcRasterizer.addSeg(mra, cx1, cy1, cx2, cy2, a, b, xline, yline, seg2);
            int startSeg = (seg1[0] + 1) % 8;
            int finishSeg = seg2[0];
            while (startSeg != finishSeg) {
                switch (startSeg) {
                    case 0: {
                        JavaArcRasterizer.addY3Line(mra, yline, cx2, cy1, a);
                        break;
                    }
                    case 1: {
                        JavaArcRasterizer.addX1Line(mra, xline, cx2, cy1, b);
                        break;
                    }
                    case 2: {
                        JavaArcRasterizer.addX2Line(mra, xline, cx1, cy1, b);
                        break;
                    }
                    case 3: {
                        JavaArcRasterizer.addY2Line(mra, yline, cx1, cy1, a);
                        break;
                    }
                    case 4: {
                        JavaArcRasterizer.addY1Line(mra, yline, cx1, cy2, a);
                        break;
                    }
                    case 5: {
                        JavaArcRasterizer.addX3Line(mra, xline, cx1, cy2, b);
                        break;
                    }
                    case 6: {
                        JavaArcRasterizer.addX0Line(mra, xline, cx2, cy2, b);
                        break;
                    }
                    case 7: {
                        JavaArcRasterizer.addY0Line(mra, yline, cx2, cy2, a);
                    }
                }
                startSeg = (startSeg + 1) % 8;
            }
        }
        if (clip != null) {
            mra.intersect(clip);
        }
        return mra;
    }
}

