/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.harmony.awt.gl.image.DecodingImageSource;

public class FileDecodingImageSource
extends DecodingImageSource {
    String filename;

    public FileDecodingImageSource(String file) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(file);
        }
        this.filename = file;
    }

    @Override
    protected boolean checkConnection() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkRead(this.filename);
            }
            catch (SecurityException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.filename));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

