/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.font.LineMetrics;
import org.apache.harmony.awt.internal.nls.Messages;

public class LineMetricsImpl
extends LineMetrics
implements Cloneable {
    float[] baselineOffsets;
    int numChars;
    int baseLineIndex;
    float underlineThickness;
    float underlineOffset;
    float strikethroughThickness;
    float strikethroughOffset;
    float leading;
    float height;
    float ascent;
    float descent;
    float maxCharWidth;
    int lUnderlineThickness;
    int lUnderlineOffset;
    int lStrikethroughThickness;
    int lStrikethroughOffset;
    int lLeading;
    int lHeight;
    int lAscent;
    int lDescent;
    int lMaxCharWidth;
    int units_per_EM = 0;

    public LineMetricsImpl(int len, float[] metrics, float[] _baselineData) {
        if (metrics.length < 16) {
            throw new IllegalArgumentException(Messages.getString("awt.40"));
        }
        this.numChars = len;
        this.ascent = metrics[0];
        this.descent = metrics[1];
        this.leading = metrics[2];
        if (_baselineData == null) {
            this.baseLineIndex = 0;
            this.baselineOffsets = new float[]{0.0f, (-this.ascent + this.descent) / 2.0f, -this.ascent};
        } else {
            this.baseLineIndex = (int)_baselineData[3];
            this.baselineOffsets = new float[3];
            System.arraycopy(_baselineData, 0, this.baselineOffsets, 0, 3);
        }
        this.height = metrics[0] + metrics[1] + metrics[2];
        this.underlineThickness = metrics[3];
        this.underlineOffset = -metrics[4];
        this.strikethroughThickness = metrics[5];
        this.strikethroughOffset = -metrics[6];
        this.maxCharWidth = metrics[7];
        this.lAscent = (int)metrics[8];
        this.lDescent = (int)metrics[9];
        this.lLeading = (int)metrics[10];
        this.lHeight = this.lAscent + this.lDescent + this.lLeading;
        this.lUnderlineThickness = (int)metrics[11];
        this.lUnderlineOffset = -((int)metrics[12]);
        this.lStrikethroughThickness = (int)metrics[13];
        this.lStrikethroughOffset = -((int)metrics[14]);
        this.lMaxCharWidth = (int)metrics[15];
    }

    public LineMetricsImpl(int _numChars, int _baseLineIndex, float[] _baselineOffsets, float _underlineThickness, float _underlineOffset, float _strikethroughThickness, float _strikethroughOffset, float _leading, float _height, float _ascent, float _descent, float _maxCharWidth) {
        this.numChars = _numChars;
        this.baseLineIndex = _baseLineIndex;
        this.underlineThickness = _underlineThickness;
        this.underlineOffset = _underlineOffset;
        this.strikethroughThickness = _strikethroughThickness;
        this.strikethroughOffset = _strikethroughOffset;
        this.leading = _leading;
        this.height = _height;
        this.ascent = _ascent;
        this.descent = _descent;
        this.baselineOffsets = _baselineOffsets;
        this.lUnderlineThickness = (int)this.underlineThickness;
        this.lUnderlineOffset = (int)this.underlineOffset;
        this.lStrikethroughThickness = (int)this.strikethroughThickness;
        this.lStrikethroughOffset = (int)this.strikethroughOffset;
        this.lLeading = (int)this.leading;
        this.lHeight = (int)this.height;
        this.lAscent = (int)this.ascent;
        this.lDescent = (int)this.descent;
        this.maxCharWidth = _maxCharWidth;
    }

    public LineMetricsImpl() {
    }

    public void scale(float scaleX, float scaleY) {
        float absScaleX = Math.abs(scaleX);
        float absScaleY = Math.abs(scaleY);
        this.underlineThickness *= absScaleY;
        this.underlineOffset *= scaleY;
        this.strikethroughThickness *= absScaleY;
        this.strikethroughOffset *= scaleY;
        this.leading *= absScaleY;
        this.height *= absScaleY;
        this.ascent *= absScaleY;
        this.descent *= absScaleY;
        if (this.baselineOffsets == null) {
            this.getBaselineOffsets();
        }
        int i = 0;
        while (i < this.baselineOffsets.length) {
            int n = i++;
            this.baselineOffsets[n] = this.baselineOffsets[n] * scaleY;
        }
        this.lUnderlineThickness = (int)((float)this.lUnderlineThickness * absScaleY);
        this.lUnderlineOffset = (int)((float)this.lUnderlineOffset * scaleY);
        this.lStrikethroughThickness = (int)((float)this.lStrikethroughThickness * absScaleY);
        this.lStrikethroughOffset = (int)((float)this.lStrikethroughOffset * scaleY);
        this.lLeading = (int)((float)this.lLeading * absScaleY);
        this.lHeight = (int)((float)this.lHeight * absScaleY);
        this.lAscent = (int)((float)this.lAscent * absScaleY);
        this.lDescent = (int)((float)this.lDescent * absScaleY);
        this.maxCharWidth *= absScaleX;
    }

    @Override
    public float[] getBaselineOffsets() {
        return this.baselineOffsets;
    }

    @Override
    public int getNumChars() {
        return this.numChars;
    }

    @Override
    public int getBaselineIndex() {
        return this.baseLineIndex;
    }

    @Override
    public float getUnderlineThickness() {
        return this.underlineThickness;
    }

    @Override
    public float getUnderlineOffset() {
        return this.underlineOffset;
    }

    @Override
    public float getStrikethroughThickness() {
        return this.strikethroughThickness;
    }

    @Override
    public float getStrikethroughOffset() {
        return this.strikethroughOffset;
    }

    @Override
    public float getLeading() {
        return this.leading;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getDescent() {
        return this.descent;
    }

    @Override
    public float getAscent() {
        return this.ascent;
    }

    public int getLogicalUnderlineThickness() {
        return this.lUnderlineThickness;
    }

    public int getLogicalUnderlineOffset() {
        return this.lUnderlineOffset;
    }

    public int getLogicalStrikethroughThickness() {
        return this.lStrikethroughThickness;
    }

    public int getLogicalStrikethroughOffset() {
        return this.lStrikethroughOffset;
    }

    public int getLogicalLeading() {
        return this.lLeading;
    }

    public int getLogicalHeight() {
        return this.lHeight;
    }

    public int getLogicalDescent() {
        return this.lDescent;
    }

    public int getLogicalAscent() {
        return this.lAscent;
    }

    public int getLogicalMaxCharWidth() {
        return this.lMaxCharWidth;
    }

    public float getMaxCharWidth() {
        return this.maxCharWidth;
    }

    public void setNumChars(int num) {
        this.numChars = num;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

