/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.AffineTransform;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.LineMetricsImpl;

public class FontMetricsImpl
extends FontMetrics {
    private static final long serialVersionUID = 844695615201925138L;
    private int ascent;
    private int descent;
    private int leading;
    private int maxAscent;
    private int maxDescent;
    private int maxAdvance;
    private int[] widths = new int[256];
    private transient FontPeerImpl peer = this.getFontPeer();
    private float scaleX = 1.0f;

    public FontMetricsImpl(Font fnt) {
        super(fnt);
        AffineTransform at = fnt.getTransform();
        if (!at.isIdentity()) {
            this.scaleX = (float)at.getScaleX();
        }
        LineMetricsImpl lm = (LineMetricsImpl)this.peer.getLineMetrics("", null, at);
        this.ascent = lm.getLogicalAscent();
        this.descent = lm.getLogicalDescent();
        this.leading = lm.getLogicalLeading();
        this.maxAscent = this.ascent;
        this.maxDescent = this.descent;
        this.maxAdvance = lm.getLogicalMaxCharWidth();
    }

    @Override
    public int getAscent() {
        return this.ascent;
    }

    @Override
    public int getDescent() {
        return this.descent;
    }

    @Override
    public int getLeading() {
        return this.leading;
    }

    @Override
    public int charWidth(int ch) {
        return this.getFontPeer().charWidth((char)ch);
    }

    @Override
    public int charWidth(char ch) {
        return (int)((float)this.getFontPeer().charWidth(ch) * this.scaleX);
    }

    @Override
    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    @Override
    public int getMaxAscent() {
        return this.maxAscent;
    }

    @Override
    @Deprecated
    public int getMaxDecent() {
        return this.maxDescent;
    }

    @Override
    public int getMaxDescent() {
        return this.maxDescent;
    }

    @Override
    public int[] getWidths() {
        this.widths = new int[256];
        for (int chr = 0; chr < 256; ++chr) {
            this.widths[chr] = (int)((float)this.getFontPeer().charWidth((char)chr) * this.scaleX);
        }
        return this.widths;
    }

    @Override
    public int stringWidth(String str) {
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            char chr = str.charAt(i);
            width += this.charWidth(chr);
        }
        return width;
    }

    public FontPeerImpl getFontPeer() {
        if (this.peer == null) {
            this.peer = (FontPeerImpl)this.font.getPeer();
        }
        return this.peer;
    }
}

