/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.Glyph;
import org.apache.harmony.awt.gl.font.LineMetricsImpl;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.luni.util.NotImplementedException;

public class CommonGlyphVector
extends GlyphVector {
    protected AffineTransform[] glsTransforms;
    public char[] charVector;
    public Glyph[] vector;
    float[] defaultPositions;
    float[] logicalPositions;
    public float[] visualPositions;
    protected FontRenderContext vectorFRC;
    protected int layoutFlags = 0;
    protected Shape[] gvShapes;
    FontPeerImpl peer;
    Font font;
    float ascent;
    float height;
    float leading;
    float descent;
    AffineTransform transform;

    public CommonGlyphVector(char[] chars, FontRenderContext frc, Font fnt, int flags) {
        int len = chars.length;
        this.font = fnt;
        this.transform = fnt.getTransform();
        this.peer = (FontPeerImpl)fnt.getPeer();
        this.gvShapes = new Shape[len];
        this.logicalPositions = new float[len + 1 << 1];
        this.visualPositions = new float[len + 1 << 1];
        this.defaultPositions = new float[len + 1 << 1];
        this.charVector = chars;
        this.vectorFRC = frc;
        LineMetricsImpl lmImpl = (LineMetricsImpl)this.peer.getLineMetrics();
        this.ascent = lmImpl.getAscent();
        this.height = lmImpl.getHeight();
        this.leading = lmImpl.getLeading();
        this.descent = lmImpl.getDescent();
        this.layoutFlags = flags;
        if ((flags & 1) != 0) {
            char[] vector = new char[len];
            for (int i = 0; i < len; ++i) {
                vector[i] = chars[len - i - 1];
            }
            this.vector = this.peer.getGlyphs(vector);
        } else {
            this.vector = this.peer.getGlyphs(chars);
        }
        this.glsTransforms = new AffineTransform[len];
        this.setDefaultPositions();
        this.performDefaultLayout();
    }

    public CommonGlyphVector(char[] chars, FontRenderContext frc, Font fnt) {
        this(chars, frc, fnt, 0);
    }

    public CommonGlyphVector(String str, FontRenderContext frc, Font fnt) {
        this(str.toCharArray(), frc, fnt, 0);
    }

    public CommonGlyphVector(String str, FontRenderContext frc, Font fnt, int flags) {
        this(str.toCharArray(), frc, fnt, flags);
    }

    void setDefaultPositions() {
        int len = this.getNumGlyphs();
        for (int i = 1; i <= len; ++i) {
            int idx = i << 1;
            float advanceX = this.vector[i - 1].getGlyphPointMetrics().getAdvanceX();
            float advanceY = this.vector[i - 1].getGlyphPointMetrics().getAdvanceY();
            this.defaultPositions[idx] = this.defaultPositions[idx - 2] + advanceX;
            this.defaultPositions[idx + 1] = this.defaultPositions[idx - 1] + advanceY;
        }
        this.transform.transform(this.defaultPositions, 0, this.logicalPositions, 0, this.getNumGlyphs() + 1);
    }

    @Override
    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            Rectangle glyphBounds = this.getGlyphPixelBounds(i, frc, 0.0f, 0.0f);
            double xm = glyphBounds.getMinX();
            double ym = glyphBounds.getMinY();
            double xM = glyphBounds.getMaxX();
            double yM = glyphBounds.getMaxY();
            if (i == 0) {
                minX = xm;
                minY = ym;
                maxX = xM;
                maxY = yM;
            }
            if (minX > xm) {
                minX = xm;
            }
            if (minY > ym) {
                minY = ym;
            }
            if (maxX < xM) {
                maxX = xM;
            }
            if (!(maxY < yM)) continue;
            maxY = yM;
        }
        return new Rectangle((int)(minX + (double)x), (int)(minY + (double)y), (int)(maxX - minX), (int)(maxY - minY));
    }

    @Override
    public Rectangle2D getVisualBounds() {
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        boolean firstIteration = true;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            Rectangle2D bounds = this.getGlyphVisualBounds(i).getBounds2D();
            if (bounds.getWidth() == 0.0) continue;
            float xm = (float)bounds.getX();
            float ym = (float)bounds.getY();
            float xM = (float)((double)xm + bounds.getWidth());
            float yM = ym + (float)bounds.getHeight();
            if (firstIteration) {
                minX = xm;
                minY = ym;
                maxX = xM;
                maxY = yM;
                firstIteration = false;
                continue;
            }
            if (minX > xm) {
                minX = xm;
            }
            if (minY > ym) {
                minY = ym;
            }
            if (maxX < xM) {
                maxX = xM;
            }
            if (!(maxY < yM)) continue;
            maxY = yM;
        }
        return this.getNumGlyphs() != 0 ? new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY) : null;
    }

    @Override
    public void setGlyphPosition(int glyphIndex, Point2D newPos) {
        if (glyphIndex > this.vector.length || glyphIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        float x = (float)newPos.getX();
        float y = (float)newPos.getY();
        int index = glyphIndex << 1;
        if (x != this.visualPositions[index] || y != this.visualPositions[index + 1]) {
            this.visualPositions[index] = x;
            this.visualPositions[index + 1] = y;
            this.layoutFlags |= 2;
        }
    }

    @Override
    public Point2D getGlyphPosition(int glyphIndex) {
        if (glyphIndex > this.vector.length || glyphIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        int index = glyphIndex << 1;
        Point2D.Float pos = new Point2D.Float(this.visualPositions[index], this.visualPositions[index + 1]);
        if (glyphIndex == this.vector.length) {
            return pos;
        }
        AffineTransform at = this.getGlyphTransform(glyphIndex);
        if (at == null || at.isIdentity()) {
            return pos;
        }
        ((Point2D)pos).setLocation(((Point2D)pos).getX() + at.getTranslateX(), ((Point2D)pos).getY() + at.getTranslateY());
        return pos;
    }

    @Override
    public void setGlyphTransform(int glyphIndex, AffineTransform trans) {
        if (glyphIndex >= this.vector.length || glyphIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        if (trans == null || trans.isIdentity()) {
            this.glsTransforms[glyphIndex] = null;
        } else {
            this.glsTransforms[glyphIndex] = new AffineTransform(trans);
            this.layoutFlags |= 1;
        }
    }

    @Override
    public AffineTransform getGlyphTransform(int glyphIndex) {
        if (glyphIndex >= this.vector.length || glyphIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        return this.glsTransforms[glyphIndex];
    }

    @Override
    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        return this.vector[glyphIndex].getGlyphMetrics();
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        throw new NotImplementedException();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.vectorFRC;
    }

    @Override
    public Shape getGlyphVisualBounds(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        int idx = glyphIndex << 1;
        AffineTransform fontTransform = this.transform;
        double xOffs = fontTransform.getTranslateX();
        double yOffs = fontTransform.getTranslateY();
        if (this.vector[glyphIndex].getWidth() == 0) {
            return new Rectangle2D.Float((float)xOffs, (float)yOffs, 0.0f, 0.0f);
        }
        AffineTransform at = AffineTransform.getTranslateInstance(xOffs, yOffs);
        AffineTransform glyphTransform = this.getGlyphTransform(glyphIndex);
        if (this.transform.isIdentity() && (glyphTransform == null || glyphTransform.isIdentity())) {
            Rectangle2D blackBox = this.vector[glyphIndex].getGlyphMetrics().getBounds2D();
            at.translate(this.visualPositions[idx], this.visualPositions[idx + 1]);
            return at.createTransformedShape(blackBox);
        }
        GeneralPath shape = (GeneralPath)this.getGlyphOutline(glyphIndex);
        shape.transform(at);
        return shape.getBounds2D();
    }

    @Override
    public Rectangle getGlyphPixelBounds(int glyphIndex, FontRenderContext frc, float x, float y) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        int idx = glyphIndex << 1;
        if (this.vector[glyphIndex].getWidth() == 0) {
            AffineTransform fontTransform = this.transform;
            double xOffs = (double)(x + this.visualPositions[idx]) + fontTransform.getTranslateX();
            double yOffs = (double)(y + this.visualPositions[idx + 1]) + fontTransform.getTranslateY();
            return new Rectangle((int)xOffs, (int)yOffs, 0, 0);
        }
        GeneralPath shape = (GeneralPath)this.getGlyphOutline(glyphIndex);
        AffineTransform at = AffineTransform.getTranslateInstance(x, y);
        if (frc != null) {
            at.concatenate(frc.getTransform());
        }
        shape.transform(at);
        Rectangle bounds = shape.getBounds();
        return new Rectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth() - 1, (int)bounds.getHeight() - 1);
    }

    @Override
    public Shape getGlyphOutline(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        if (this.gvShapes[glyphIndex] == null) {
            this.gvShapes[glyphIndex] = this.vector[glyphIndex].getShape();
        }
        GeneralPath gp = (GeneralPath)((GeneralPath)this.gvShapes[glyphIndex]).clone();
        AffineTransform at = (AffineTransform)this.transform.clone();
        AffineTransform glyphAT = this.getGlyphTransform(glyphIndex);
        if (glyphAT != null) {
            at.preConcatenate(glyphAT);
        }
        int idx = glyphIndex << 1;
        gp.transform(at);
        gp.transform(AffineTransform.getTranslateInstance(this.visualPositions[idx], this.visualPositions[idx + 1]));
        return gp;
    }

    @Override
    public Shape getOutline(float x, float y) {
        GeneralPath gp = new GeneralPath(0);
        for (int i = 0; i < this.vector.length; ++i) {
            GeneralPath outline = (GeneralPath)this.getGlyphOutline(i);
            outline.transform(AffineTransform.getTranslateInstance(x, y));
            gp.append(outline, false);
        }
        return gp;
    }

    @Override
    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    @Override
    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        if (beginGlyphIndex < 0 || numEntries + beginGlyphIndex > this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.44"));
        }
        if (numEntries < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.45"));
        }
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        for (int i = beginGlyphIndex; i < beginGlyphIndex + numEntries; ++i) {
            codeReturn[i - beginGlyphIndex] = this.vector[i].getGlyphCode();
        }
        return codeReturn;
    }

    @Override
    public int[] getGlyphCharIndices(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        if (beginGlyphIndex < 0 || beginGlyphIndex >= this.getNumGlyphs()) {
            throw new IllegalArgumentException(Messages.getString("awt.44"));
        }
        if (numEntries < 0 || numEntries + beginGlyphIndex > this.getNumGlyphs()) {
            throw new IllegalArgumentException(Messages.getString("awt.45"));
        }
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        for (int i = 0; i < numEntries; ++i) {
            codeReturn[i] = this.getGlyphCharIndex(i + beginGlyphIndex);
        }
        return codeReturn;
    }

    @Override
    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        int len = this.getNumGlyphs() + 1 << 1;
        if ((beginGlyphIndex *= 2) < 0 || (numEntries *= 2) + beginGlyphIndex > len) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.44"));
        }
        if (numEntries < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.45"));
        }
        if (positionReturn == null) {
            positionReturn = new float[numEntries];
        }
        System.arraycopy(this.visualPositions, beginGlyphIndex, positionReturn, 0, numEntries);
        return positionReturn;
    }

    public void setGlyphPositions(int beginGlyphIndex, int numEntries, float[] setPositions) {
        int len = this.getNumGlyphs() + 1 << 1;
        if ((beginGlyphIndex *= 2) < 0 || (numEntries *= 2) + beginGlyphIndex > len) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.44"));
        }
        if (numEntries < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.45"));
        }
        System.arraycopy(setPositions, 0, this.visualPositions, beginGlyphIndex, numEntries);
        this.layoutFlags &= 2;
    }

    public void setGlyphPositions(float[] setPositions) {
        int len = this.getNumGlyphs() + 1 << 1;
        if (len != setPositions.length) {
            throw new IllegalArgumentException(Messages.getString("awt.46"));
        }
        System.arraycopy(setPositions, 0, this.visualPositions, 0, len);
        this.layoutFlags &= 2;
    }

    @Override
    public int getGlyphCode(int glyphIndex) {
        if (glyphIndex >= this.vector.length || glyphIndex < 0) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        return this.vector[glyphIndex].getGlyphCode();
    }

    @Override
    public int getGlyphCharIndex(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IllegalArgumentException(Messages.getString("awt.43"));
        }
        if ((this.layoutFlags & 1) != 0) {
            return this.charVector.length - glyphIndex - 1;
        }
        return glyphIndex;
    }

    public char getGlyphChar(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IllegalArgumentException(Messages.getString("awt.43"));
        }
        return this.charVector[glyphIndex];
    }

    @Override
    public void performDefaultLayout() {
        System.arraycopy(this.logicalPositions, 0, this.visualPositions, 0, this.logicalPositions.length);
        this.clearLayoutFlags(2);
    }

    @Override
    public int getNumGlyphs() {
        return this.vector.length;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        float x = this.visualPositions[0];
        float width = this.visualPositions[this.visualPositions.length - 2];
        double scaleY = this.transform.getScaleY();
        Rectangle2D.Float bounds = new Rectangle2D.Float(x, (float)((double)(-this.ascent - this.leading) * scaleY), width, (float)((double)this.height * scaleY));
        return bounds;
    }

    @Override
    public boolean equals(GlyphVector glyphVector) {
        if (glyphVector == this) {
            return true;
        }
        if (glyphVector != null) {
            if (!glyphVector.getFontRenderContext().equals(this.vectorFRC) || !glyphVector.getFont().equals(this.font)) {
                return false;
            }
            try {
                boolean eq = true;
                for (int i = 0; i < this.getNumGlyphs(); ++i) {
                    int idx = i * 2;
                    boolean bl = eq = ((CommonGlyphVector)glyphVector).visualPositions[idx] == this.visualPositions[idx] && ((CommonGlyphVector)glyphVector).visualPositions[idx + 1] == this.visualPositions[idx + 1] && glyphVector.getGlyphCharIndex(i) == this.getGlyphCharIndex(i);
                    if (eq) {
                        AffineTransform trans = glyphVector.getGlyphTransform(i);
                        eq = trans == null ? this.glsTransforms[i] == null : this.glsTransforms[i].equals(trans);
                    }
                    if (eq) continue;
                    return false;
                }
                return eq;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int getLayoutFlags() {
        return this.layoutFlags;
    }

    public char getChar(int index) {
        return this.charVector[index];
    }

    private void clearLayoutFlags(int clearFlags) {
        this.layoutFlags &= ~clearFlags;
    }

    @Override
    public Shape getGlyphLogicalBounds(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex >= this.getNumGlyphs()) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.43"));
        }
        Glyph glyph = this.vector[glyphIndex];
        float x0 = this.visualPositions[glyphIndex * 2];
        float y0 = this.visualPositions[glyphIndex * 2 + 1];
        float advanceX = glyph.getGlyphPointMetrics().getAdvanceX();
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, -this.ascent - this.leading);
        gp.lineTo(advanceX, -this.ascent - this.leading);
        gp.lineTo(advanceX, this.descent);
        gp.lineTo(0.0f, this.descent);
        gp.lineTo(0.0f, -this.ascent - this.leading);
        gp.closePath();
        AffineTransform at = (AffineTransform)this.transform.clone();
        AffineTransform glyphTransform = this.getGlyphTransform(glyphIndex);
        if (glyphTransform != null) {
            at.concatenate(glyphTransform);
        }
        at.preConcatenate(AffineTransform.getTranslateInstance(x0, y0));
        gp.transform(at);
        return gp;
    }

    @Override
    public Font getFont() {
        return this.font;
    }
}

