/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.color;

import java.awt.color.ICC_Profile;
import org.apache.harmony.awt.gl.color.ICC_ProfileHelper;
import org.apache.harmony.awt.gl.color.NativeCMM;
import org.apache.harmony.awt.gl.color.NativeImageFormat;

public class ICC_Transform {
    private long transformHandle;
    private int numInputChannels;
    private int numOutputChannels;
    private ICC_Profile src;
    private ICC_Profile dst;

    public int getNumInputChannels() {
        return this.numInputChannels;
    }

    public int getNumOutputChannels() {
        return this.numOutputChannels;
    }

    public ICC_Profile getDst() {
        return this.dst;
    }

    public ICC_Profile getSrc() {
        return this.src;
    }

    public ICC_Transform(ICC_Profile[] profiles, int[] renderIntents) {
        int numProfiles = profiles.length;
        long[] profileHandles = new long[numProfiles];
        for (int i = 0; i < numProfiles; ++i) {
            profileHandles[i] = NativeCMM.getHandle(profiles[i]);
        }
        this.transformHandle = NativeCMM.cmmCreateMultiprofileTransform(profileHandles, renderIntents);
        this.src = profiles[0];
        this.dst = profiles[numProfiles - 1];
        this.numInputChannels = this.src.getNumComponents();
        this.numOutputChannels = this.dst.getNumComponents();
    }

    public ICC_Transform(ICC_Profile[] profiles) {
        int numProfiles = profiles.length;
        int[] renderingIntents = new int[numProfiles];
        int currRenderingIntent = 0;
        if (profiles[0].getProfileClass() == 2) {
            currRenderingIntent = 1;
        }
        for (int i = 0; i < numProfiles; ++i) {
            if (i != 0 && i != numProfiles - 1 && profiles[i].getProfileClass() == 5) {
                currRenderingIntent = 0;
            }
            renderingIntents[i] = currRenderingIntent;
            currRenderingIntent = ICC_ProfileHelper.getRenderingIntent(profiles[i]);
        }
        long[] profileHandles = new long[numProfiles];
        for (int i = 0; i < numProfiles; ++i) {
            profileHandles[i] = NativeCMM.getHandle(profiles[i]);
        }
        this.transformHandle = NativeCMM.cmmCreateMultiprofileTransform(profileHandles, renderingIntents);
        this.src = profiles[0];
        this.dst = profiles[numProfiles - 1];
        this.numInputChannels = this.src.getNumComponents();
        this.numOutputChannels = this.dst.getNumComponents();
    }

    protected void finalize() {
        if (this.transformHandle != 0L) {
            NativeCMM.cmmDeleteTransform(this.transformHandle);
        }
    }

    public void translateColors(NativeImageFormat src, NativeImageFormat dst) {
        NativeCMM.cmmTranslateColors(this.transformHandle, src, dst);
    }
}

