/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;
import org.apache.harmony.awt.gl.MultiRectArea;
import org.apache.harmony.awt.gl.color.LUTColorConverter;

public abstract class Surface
implements Transparency {
    public static final int sRGB_CS = 1;
    public static final int Linear_RGB_CS = 2;
    public static final int Linear_Gray_CS = 3;
    public static final int Custom_CS = 0;
    public static final int DCM = 1;
    public static final int ICM = 2;
    public static final int CCM = 3;
    public static final int SPPSM = 1;
    public static final int MPPSM = 2;
    public static final int CSM = 3;
    public static final int PISM = 4;
    public static final int BSM = 5;
    private static final int ALPHA_MASK = -16777216;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    private static final int RED_BGR_MASK = 255;
    private static final int GREEN_BGR_MASK = 65280;
    private static final int BLUE_BGR_MASK = 0xFF0000;
    private static final int RED_565_MASK = 63488;
    private static final int GREEN_565_MASK = 2016;
    private static final int BLUE_565_MASK = 31;
    private static final int RED_555_MASK = 31744;
    private static final int GREEN_555_MASK = 992;
    private static final int BLUE_555_MASK = 31;
    protected int transparency = 1;
    protected int width;
    protected int height;
    protected MultiRectArea dirtyRegions;
    private final ArrayList<Object> validCaches = new ArrayList();

    public abstract ColorModel getColorModel();

    public abstract WritableRaster getRaster();

    public abstract int getSurfaceType();

    public abstract long lock();

    public abstract void unlock();

    public abstract void dispose();

    public abstract Surface getImageSurface();

    public final boolean isCaheValid(Object cache) {
        return this.validCaches.contains(cache);
    }

    public final void addValidCache(Object cache) {
        this.validCaches.add(cache);
    }

    protected final void clearValidCaches() {
        this.validCaches.clear();
    }

    public boolean isNativeDrawable() {
        return true;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Object getData() {
        return null;
    }

    public boolean invalidated() {
        return true;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void addDirtyRegion(Rectangle r) {
        if (this.dirtyRegions == null) {
            this.dirtyRegions = new MultiRectArea(r);
        } else {
            Rectangle[] rects = this.dirtyRegions.getRectangles();
            if (rects.length == 1 && rects[0].contains(r)) {
                return;
            }
            this.dirtyRegions.add(r);
        }
        this.invalidate();
    }

    public void releaseDurtyRegions() {
        this.dirtyRegions = null;
    }

    public int[] getDirtyRegions() {
        return this.dirtyRegions == null ? null : this.dirtyRegions.rect;
    }

    public static int getType(ColorModel cm, WritableRaster raster) {
        int transferType = cm.getTransferType();
        boolean hasAlpha = cm.hasAlpha();
        ColorSpace cs = cm.getColorSpace();
        int csType = cs.getType();
        SampleModel sm = raster.getSampleModel();
        if (csType == 5) {
            if (cm instanceof DirectColorModel) {
                DirectColorModel dcm = (DirectColorModel)cm;
                switch (transferType) {
                    case 3: {
                        if (dcm.getRedMask() == 0xFF0000 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 255) {
                            if (!hasAlpha) {
                                return 1;
                            }
                            if (dcm.getAlphaMask() == -16777216) {
                                if (dcm.isAlphaPremultiplied()) {
                                    return 3;
                                }
                                return 2;
                            }
                            return 0;
                        }
                        if (dcm.getRedMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 0xFF0000) {
                            if (!hasAlpha) {
                                return 4;
                            }
                        } else {
                            return 0;
                        }
                    }
                    case 1: {
                        if (dcm.getRedMask() == 31744 && dcm.getGreenMask() == 992 && dcm.getBlueMask() == 31 && !hasAlpha) {
                            return 9;
                        }
                        if (dcm.getRedMask() != 63488 || dcm.getGreenMask() != 2016 || dcm.getBlueMask() != 31) break;
                        return 8;
                    }
                }
                return 0;
            }
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int pixelBits = icm.getPixelSize();
                if (transferType == 0) {
                    if (sm instanceof MultiPixelPackedSampleModel && !hasAlpha && pixelBits < 5) {
                        return 12;
                    }
                    if (pixelBits == 8) {
                        return 13;
                    }
                }
                return 0;
            }
            if (cm instanceof ComponentColorModel) {
                ComponentColorModel ccm = (ComponentColorModel)cm;
                if (transferType == 0 && sm instanceof ComponentSampleModel) {
                    ComponentSampleModel csm = (ComponentSampleModel)sm;
                    int[] offsets = csm.getBandOffsets();
                    int[] bits = ccm.getComponentSize();
                    boolean isCustom = false;
                    for (int i = 0; i < bits.length; ++i) {
                        if (bits[i] == 8 && offsets[i] == offsets.length - 1 - i) continue;
                        isCustom = true;
                        break;
                    }
                    if (!isCustom) {
                        if (!ccm.hasAlpha()) {
                            return 5;
                        }
                        if (ccm.isAlphaPremultiplied()) {
                            return 7;
                        }
                        return 6;
                    }
                }
                return 0;
            }
            return 0;
        }
        if (cs == LUTColorConverter.LINEAR_GRAY_CS) {
            if (cm instanceof ComponentColorModel && cm.getNumComponents() == 1) {
                int[] bits = cm.getComponentSize();
                if (transferType == 0 && bits[0] == 8) {
                    return 10;
                }
                if (transferType == 1 && bits[0] == 16) {
                    return 11;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public static Surface getImageSurface(Image image) {
        return AwtImageBackdoorAccessor.getInstance().getImageSurface(image);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static boolean isGrayPallete(IndexColorModel icm) {
        return AwtImageBackdoorAccessor.getInstance().isGrayPallete(icm);
    }
}

