/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.ImageSurface;
import org.apache.harmony.awt.gl.render.JavaBlitter;
import org.apache.harmony.awt.internal.nls.Messages;

public class ICompositeContext
implements CompositeContext {
    Composite composite;
    ColorModel srcCM;
    ColorModel dstCM;
    ImageSurface srcSurf;
    ImageSurface dstSurf;

    public ICompositeContext(Composite comp, ColorModel src, ColorModel dst) {
        this.composite = comp;
        this.srcCM = src;
        this.dstCM = dst;
    }

    @Override
    public void dispose() {
        this.srcSurf.dispose();
        this.dstSurf.dispose();
    }

    @Override
    public void compose(Raster srcIn, Raster dstIn, WritableRaster dstOut) {
        WritableRaster src;
        if (!this.srcCM.isCompatibleRaster(srcIn)) {
            throw new IllegalArgumentException(Messages.getString("awt.48"));
        }
        if (!this.dstCM.isCompatibleRaster(dstIn)) {
            throw new IllegalArgumentException(Messages.getString("awt.49"));
        }
        if (dstIn != dstOut) {
            if (!this.dstCM.isCompatibleRaster(dstOut)) {
                throw new IllegalArgumentException(Messages.getString("awt.4A"));
            }
            dstOut.setDataElements(0, 0, dstIn);
        }
        if (srcIn instanceof WritableRaster) {
            src = (WritableRaster)srcIn;
        } else {
            src = srcIn.createCompatibleWritableRaster();
            src.setDataElements(0, 0, srcIn);
        }
        this.srcSurf = new ImageSurface(this.srcCM, src);
        this.dstSurf = new ImageSurface(this.dstCM, dstOut);
        int w = Math.min(srcIn.getWidth(), dstOut.getWidth());
        int h = Math.min(srcIn.getHeight(), dstOut.getHeight());
        JavaBlitter.getInstance().blit(0, 0, this.srcSurf, 0, 0, this.dstSurf, w, h, this.composite, null, null);
    }
}

