/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.rgbe.RgbeInfo;
import org.apache.commons.imaging.util.IoUtils;

public class RgbeImageParser
extends ImageParser {
    public RgbeImageParser() {
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public String getName() {
        return "Radiance HDR";
    }

    @Override
    public String getDefaultExtension() {
        return ".hdr";
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return new String[]{".hdr", ".pic"};
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.RGBE};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        IImageMetadata iImageMetadata;
        RgbeInfo info = new RgbeInfo(byteSource);
        boolean canThrow = false;
        try {
            IImageMetadata ret = info.getMetadata();
            canThrow = true;
            iImageMetadata = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, info);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, info);
        return iImageMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        ImageInfo imageInfo;
        RgbeInfo info = new RgbeInfo(byteSource);
        boolean canThrow = false;
        try {
            ImageInfo ret = new ImageInfo(this.getName(), 32, new ArrayList<String>(), ImageFormats.RGBE, this.getName(), info.getHeight(), "image/vnd.radiance", 1, -1, -1.0f, -1, -1.0f, info.getWidth(), false, false, false, 2, "Adaptive RLE");
            canThrow = true;
            imageInfo = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, info);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, info);
        return imageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        BufferedImage bufferedImage;
        RgbeInfo info = new RgbeInfo(byteSource);
        boolean canThrow = false;
        try {
            DataBufferFloat buffer = new DataBufferFloat(info.getPixelData(), info.getWidth() * info.getHeight());
            BufferedImage ret = new BufferedImage(new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, buffer.getDataType()), Raster.createWritableRaster(new BandedSampleModel(buffer.getDataType(), info.getWidth(), info.getHeight(), 3), buffer, new Point()), false, null);
            canThrow = true;
            bufferedImage = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, info);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, info);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        Dimension dimension;
        RgbeInfo info = new RgbeInfo(byteSource);
        boolean canThrow = false;
        try {
            Dimension ret = new Dimension(info.getWidth(), info.getHeight());
            canThrow = true;
            dimension = ret;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, info);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, info);
        return dimension;
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }
}

