/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import javax.imageio.spi.RegisterableService;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class ServiceRegistry {
    CategoriesMap categories = new CategoriesMap(this);

    public ServiceRegistry(Iterator<Class<?>> categoriesIterator) {
        if (null == categoriesIterator) {
            throw new IllegalArgumentException(Messages.getString("imageio.5D"));
        }
        while (categoriesIterator.hasNext()) {
            Class<?> c = categoriesIterator.next();
            this.categories.addCategory(c);
        }
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass, ClassLoader loader) {
        return new LookupProvidersIterator<T>(providerClass, loader);
    }

    public static <T> Iterator<T> lookupProviders(Class<T> providerClass) {
        return ServiceRegistry.lookupProviders(providerClass, Thread.currentThread().getContextClassLoader());
    }

    public <T> boolean registerServiceProvider(T provider, Class<T> category) {
        return this.categories.addProvider(provider, category);
    }

    public void registerServiceProviders(Iterator<?> providers) {
        Iterator<?> iterator = providers;
        while (iterator.hasNext()) {
            this.categories.addProvider(iterator.next(), null);
        }
    }

    public void registerServiceProvider(Object provider) {
        this.categories.addProvider(provider, null);
    }

    public <T> boolean deregisterServiceProvider(T provider, Class<T> category) {
        return this.categories.removeProvider(provider, category);
    }

    public void deregisterServiceProvider(Object provider) {
        this.categories.removeProvider(provider);
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, Filter filter, boolean useOrdering) {
        return new FilteredIterator(filter, this.categories.getProviders(category, useOrdering));
    }

    public <T> Iterator<T> getServiceProviders(Class<T> category, boolean useOrdering) {
        return this.categories.getProviders(category, useOrdering);
    }

    public <T> T getServiceProviderByClass(Class<T> providerClass) {
        return this.categories.getServiceProviderByClass(providerClass);
    }

    public <T> boolean setOrdering(Class<T> category, T firstProvider, T secondProvider) {
        return this.categories.setOrdering(category, firstProvider, secondProvider);
    }

    public <T> boolean unsetOrdering(Class<T> category, T firstProvider, T secondProvider) {
        return this.categories.unsetOrdering(category, firstProvider, secondProvider);
    }

    public void deregisterAll(Class<?> category) {
        this.categories.removeAll(category);
    }

    public void deregisterAll() {
        this.categories.removeAll();
    }

    public void finalize() throws Throwable {
        this.deregisterAll();
    }

    public boolean contains(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.5E"));
        }
        return this.categories.contains(provider);
    }

    public Iterator<Class<?>> getCategories() {
        return this.categories.list();
    }

    static class ServiceConfigurationError
    extends Error {
        private static final long serialVersionUID = 74132770414881L;

        public ServiceConfigurationError(String msg) {
            super(msg);
        }

        public ServiceConfigurationError(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    static class LookupProvidersIterator<T>
    implements Iterator {
        private Set<String> providerNames = new HashSet<String>();
        private Iterator<String> it = null;
        private ClassLoader loader = null;

        public LookupProvidersIterator(Class<T> providerClass, ClassLoader loader) {
            this.loader = loader;
            Enumeration<URL> e = null;
            try {
                e = loader.getResources("META-INF/services/" + providerClass.getName());
                while (e.hasMoreElements()) {
                    Set<String> names = this.parse(e.nextElement());
                    this.providerNames.addAll(names);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.it = this.providerNames.iterator();
        }

        private Set<String> parse(URL u) {
            InputStream input = null;
            BufferedReader reader = null;
            HashSet<String> names = new HashSet<String>();
            try {
                String line;
                input = u.openStream();
                reader = new BufferedReader(new InputStreamReader(input, "utf-8"));
                while ((line = reader.readLine()) != null) {
                    int sharpIndex = line.indexOf(35);
                    if (sharpIndex >= 0) {
                        line = line.substring(0, sharpIndex);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    char[] namechars = line.toCharArray();
                    for (int i = 0; i < namechars.length; ++i) {
                        if (Character.isJavaIdentifierPart(namechars[i]) || namechars[i] == '.') continue;
                        throw new ServiceConfigurationError(Messages.getString("imageio.99", line));
                    }
                    names.add(line);
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError(e.toString());
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    throw new ServiceConfigurationError(e.toString());
                }
            }
            return names;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String name = this.it.next();
            try {
                return Class.forName(name, true, this.loader).newInstance();
            }
            catch (Exception e) {
                throw new ServiceConfigurationError(e.toString());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrderedProviderIterator
    implements Iterator {
        private Stack<ProviderNode> firstNodes = new Stack();
        private Map<ProviderNode, Integer> incomingEdges = new HashMap<ProviderNode, Integer>();

        public OrderedProviderIterator(Iterator it) {
            while (it.hasNext()) {
                ProviderNode node = (ProviderNode)it.next();
                this.incomingEdges.put(node, new Integer(node.getIncomingEdges()));
                if (node.getIncomingEdges() != 0) continue;
                this.firstNodes.push(node);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.firstNodes.empty();
        }

        public Object next() {
            if (this.firstNodes.empty()) {
                throw new NoSuchElementException();
            }
            ProviderNode node = this.firstNodes.pop();
            Iterator<Object> it = node.getOutgoingNodes();
            while (it.hasNext()) {
                ProviderNode outNode = (ProviderNode)it.next();
                int edges = this.incomingEdges.get(outNode);
                this.incomingEdges.put(outNode, new Integer(--edges));
                if (edges != 0) continue;
                this.firstNodes.push(outNode);
            }
            this.incomingEdges.remove(node);
            return node.getProvider();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ProviderNode {
        private int incomingEdges = 0;
        private Set<Object> outgoingNodes = new HashSet<Object>();
        private Object provider;

        public ProviderNode(Object provider) {
            this.provider = provider;
        }

        public Object getProvider() {
            return this.provider;
        }

        public Iterator<Object> getOutgoingNodes() {
            return this.outgoingNodes.iterator();
        }

        public boolean addOutEdge(Object secondProvider) {
            return this.outgoingNodes.add(secondProvider);
        }

        public <T> boolean removeOutEdge(Object provider) {
            return this.outgoingNodes.remove(provider);
        }

        public void addInEdge() {
            ++this.incomingEdges;
        }

        public void removeInEdge() {
            --this.incomingEdges;
        }

        public int getIncomingEdges() {
            return this.incomingEdges;
        }

        public boolean contains(Object provider) {
            return this.outgoingNodes.contains(provider);
        }
    }

    private static class FilteredIterator<E>
    implements Iterator<E> {
        private Filter filter;
        private Iterator<E> backend;
        private E nextObj;

        public FilteredIterator(Filter filter, Iterator<E> backend) {
            this.filter = filter;
            this.backend = backend;
            this.findNext();
        }

        @Override
        public E next() {
            if (this.nextObj == null) {
                throw new NoSuchElementException();
            }
            E tmp = this.nextObj;
            this.findNext();
            return tmp;
        }

        @Override
        public boolean hasNext() {
            return this.nextObj != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            this.nextObj = null;
            while (this.backend.hasNext()) {
                E o = this.backend.next();
                if (!this.filter.filter(o)) continue;
                this.nextObj = o;
                return;
            }
        }
    }

    private static class ProvidersMap {
        Map<Class<?>, Object> providers = new HashMap();
        Map<Object, ProviderNode> nodeMap = new HashMap<Object, ProviderNode>();

        private ProvidersMap() {
        }

        boolean addProvider(Object provider) {
            ProviderNode node = new ProviderNode(provider);
            this.nodeMap.put(provider, node);
            Object obj = this.providers.put(provider.getClass(), provider);
            if (obj != null) {
                this.nodeMap.remove(obj);
                return false;
            }
            return true;
        }

        boolean contains(Object provider) {
            return this.providers.containsValue(provider);
        }

        boolean removeProvider(Object provider, ServiceRegistry registry, Class<?> category) {
            Object obj = this.providers.get(provider.getClass());
            if (obj == null || obj != provider) {
                return false;
            }
            this.providers.remove(provider.getClass());
            this.nodeMap.remove(provider);
            if (provider instanceof RegisterableService) {
                ((RegisterableService)provider).onDeregistration(registry, category);
            }
            return true;
        }

        void clear(ServiceRegistry registry) {
            for (Map.Entry<Class<?>, Object> e : this.providers.entrySet()) {
                Object provider = e.getValue();
                if (!(provider instanceof RegisterableService)) continue;
                ((RegisterableService)provider).onDeregistration(registry, e.getKey());
            }
            this.providers.clear();
            this.nodeMap.clear();
        }

        Iterator<Class<?>> getProviderClasses() {
            return this.providers.keySet().iterator();
        }

        Iterator<?> getProviders(boolean useOrdering) {
            if (useOrdering) {
                return new OrderedProviderIterator(this.nodeMap.values().iterator());
            }
            return this.providers.values().iterator();
        }

        <T> T getServiceProviderByClass(Class<T> providerClass) {
            return (T)this.providers.get(providerClass);
        }

        public <T> boolean setOrdering(T firstProvider, T secondProvider) {
            if (firstProvider == secondProvider) {
                throw new IllegalArgumentException(Messages.getString("imageio.98"));
            }
            if (firstProvider == null || secondProvider == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.5E"));
            }
            ProviderNode firstNode = this.nodeMap.get(firstProvider);
            ProviderNode secondNode = this.nodeMap.get(secondProvider);
            if (firstNode == null || firstNode.contains(secondNode)) {
                return false;
            }
            firstNode.addOutEdge(secondNode);
            secondNode.addInEdge();
            return true;
        }

        public <T> boolean unsetOrdering(T firstProvider, T secondProvider) {
            if (firstProvider == secondProvider) {
                throw new IllegalArgumentException(Messages.getString("imageio.98"));
            }
            if (firstProvider == null || secondProvider == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.5E"));
            }
            ProviderNode firstNode = this.nodeMap.get(firstProvider);
            ProviderNode secondNode = this.nodeMap.get(secondProvider);
            if (firstNode == null || !firstNode.contains(secondNode)) {
                return false;
            }
            firstNode.removeOutEdge(secondNode);
            secondNode.removeInEdge();
            return true;
        }
    }

    private static class CategoriesMap {
        Map<Class<?>, ProvidersMap> categories = new HashMap();
        ServiceRegistry registry;

        public CategoriesMap(ServiceRegistry registry) {
            this.registry = registry;
        }

        boolean contains(Object provider) {
            for (Map.Entry<Class<?>, ProvidersMap> e : this.categories.entrySet()) {
                ProvidersMap providers = e.getValue();
                if (!providers.contains(provider)) continue;
                return true;
            }
            return false;
        }

        <T> boolean setOrdering(Class<T> category, T firstProvider, T secondProvider) {
            ProvidersMap providers = this.categories.get(category);
            if (providers == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            return providers.setOrdering(firstProvider, secondProvider);
        }

        <T> boolean unsetOrdering(Class<T> category, T firstProvider, T secondProvider) {
            ProvidersMap providers = this.categories.get(category);
            if (providers == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            return providers.unsetOrdering(firstProvider, secondProvider);
        }

        Iterator<?> getProviders(Class<?> category, boolean useOrdering) {
            ProvidersMap providers = this.categories.get(category);
            if (null == providers) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            return providers.getProviders(useOrdering);
        }

        <T> T getServiceProviderByClass(Class<T> providerClass) {
            for (Map.Entry<Class<?>, ProvidersMap> e : this.categories.entrySet()) {
                T provider;
                if (!e.getKey().isAssignableFrom(providerClass) || (provider = e.getValue().getServiceProviderByClass(providerClass)) == null) continue;
                return provider;
            }
            return null;
        }

        Iterator<Class<?>> list() {
            return this.categories.keySet().iterator();
        }

        void addCategory(Class<?> category) {
            this.categories.put(category, new ProvidersMap());
        }

        boolean addProvider(Object provider, Class<?> category) {
            if (provider == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.5E"));
            }
            boolean rt = category == null ? this.findAndAdd(provider) : this.addToNamed(provider, category);
            if (provider instanceof RegisterableService) {
                ((RegisterableService)provider).onRegistration(this.registry, category);
            }
            return rt;
        }

        private boolean addToNamed(Object provider, Class<?> category) {
            if (!category.isAssignableFrom(provider.getClass())) {
                throw new ClassCastException();
            }
            ProvidersMap obj = this.categories.get(category);
            if (null == obj) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            return obj.addProvider(provider);
        }

        private boolean findAndAdd(Object provider) {
            boolean rt = false;
            for (Map.Entry<Class<?>, ProvidersMap> e : this.categories.entrySet()) {
                if (!e.getKey().isAssignableFrom(provider.getClass())) continue;
                rt |= e.getValue().addProvider(provider);
            }
            return rt;
        }

        boolean removeProvider(Object provider, Class<?> category) {
            if (provider == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.5E"));
            }
            if (!category.isAssignableFrom(provider.getClass())) {
                throw new ClassCastException();
            }
            ProvidersMap obj = this.categories.get(category);
            if (obj == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            return obj.removeProvider(provider, this.registry, category);
        }

        void removeProvider(Object provider) {
            if (provider == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.5E"));
            }
            for (Map.Entry<Class<?>, ProvidersMap> e : this.categories.entrySet()) {
                ProvidersMap providers = e.getValue();
                providers.removeProvider(provider, this.registry, e.getKey());
            }
        }

        void removeAll(Class<?> category) {
            ProvidersMap obj = this.categories.get(category);
            if (obj == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.92", category));
            }
            obj.clear(this.registry);
        }

        void removeAll() {
            for (Map.Entry<Class<?>, ProvidersMap> e : this.categories.entrySet()) {
                this.removeAll(e.getKey());
            }
        }
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

